/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.buffer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.komamitsu.fluency.sender.Sender;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Buffer<T extends Config> {
    private static final Logger LOG = LoggerFactory.getLogger(Buffer.class);
    protected static final Charset CHARSET = Charset.forName("ASCII");
    protected final T bufferConfig;
    protected final ThreadLocal<ObjectMapper> objectMapperHolder = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper((JsonFactory)new MessagePackFactory());
        }
    };
    protected final ThreadLocal<ByteArrayOutputStream> outputStreamHolder = new ThreadLocal<ByteArrayOutputStream>(){

        @Override
        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream();
        }
    };

    public Buffer(T bufferConfig) {
        this.bufferConfig = bufferConfig;
    }

    public abstract void append(String var1, long var2, Map<String, Object> var4) throws IOException;

    public void flush(Sender sender, boolean force) throws IOException {
        LOG.trace("flush(): force={}, bufferUsage={}", (Object)force, (Object)Float.valueOf(this.getBufferUsage()));
        this.flushInternal(sender, force);
    }

    public abstract void flushInternal(Sender var1, boolean var2) throws IOException;

    public void close(Sender sender) throws IOException {
        this.closeInternal(sender);
    }

    protected abstract void closeInternal(Sender var1) throws IOException;

    public abstract long getAllocatedSize();

    public int getMaxSize() {
        return ((Config)this.bufferConfig).getMaxBufferSize();
    }

    public float getBufferUsage() {
        return (float)this.getAllocatedSize() / (float)this.getMaxSize();
    }

    public static abstract class Config<T extends Buffer, C extends Config> {
        protected int maxBufferSize = 0x20000000;
        protected boolean ackResponseMode = false;

        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public C setMaxBufferSize(int maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return (C)this;
        }

        public boolean isAckResponseMode() {
            return this.ackResponseMode;
        }

        public C setAckResponseMode(boolean ackResponseMode) {
            this.ackResponseMode = ackResponseMode;
            return (C)this;
        }

        public String toString() {
            return "Config{maxBufferSize=" + this.maxBufferSize + ", ackResponseMode=" + this.ackResponseMode + '}';
        }

        public abstract T createInstance();
    }

    public static class BufferFullException
    extends IOException {
        public BufferFullException(String s) {
            super(s);
        }
    }
}

