/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.buffer;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.msgpack.core.annotations.VisibleForTesting;

public class BufferPool {
    @VisibleForTesting
    final Map<Integer, LinkedBlockingQueue<ByteBuffer>> bufferPool = new HashMap<Integer, LinkedBlockingQueue<ByteBuffer>>();
    private final AtomicLong allocatedSize = new AtomicLong();
    private final int initialBufferSize;
    private final int maxBufferSize;

    public BufferPool(int initialBufferSize, int maxBufferSize) {
        this.initialBufferSize = initialBufferSize;
        this.maxBufferSize = maxBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer acquireBuffer(int bufferSize) {
        LinkedBlockingQueue<ByteBuffer> buffers;
        int normalizedBufferSize;
        for (normalizedBufferSize = this.initialBufferSize; normalizedBufferSize < bufferSize; normalizedBufferSize *= 2) {
        }
        Map<Integer, LinkedBlockingQueue<ByteBuffer>> map = this.bufferPool;
        synchronized (map) {
            buffers = this.bufferPool.get(normalizedBufferSize);
            if (buffers == null) {
                buffers = new LinkedBlockingQueue();
                this.bufferPool.put(normalizedBufferSize, buffers);
            }
        }
        ByteBuffer buffer = buffers.poll();
        if (buffer != null) {
            return buffer;
        }
        while (true) {
            long currentAllocatedSize;
            if ((currentAllocatedSize = this.allocatedSize.get()) + (long)normalizedBufferSize > (long)this.maxBufferSize) {
                this.releaseBuffers();
                return null;
            }
            if (currentAllocatedSize == this.allocatedSize.getAndAdd(normalizedBufferSize)) {
                return ByteBuffer.allocateDirect(normalizedBufferSize);
            }
            this.allocatedSize.getAndAdd(-normalizedBufferSize);
        }
    }

    public void returnBuffer(ByteBuffer byteBuffer) {
        LinkedBlockingQueue<ByteBuffer> buffers = this.bufferPool.get(byteBuffer.capacity());
        if (buffers == null) {
            throw new IllegalStateException("`buffers` shouldn't be null");
        }
        byteBuffer.position(0);
        byteBuffer.limit(byteBuffer.capacity());
        buffers.offer(byteBuffer);
    }

    public long getAllocatedSize() {
        return this.allocatedSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBuffers() {
        Map<Integer, LinkedBlockingQueue<ByteBuffer>> map = this.bufferPool;
        synchronized (map) {
            for (Map.Entry<Integer, LinkedBlockingQueue<ByteBuffer>> entry : this.bufferPool.entrySet()) {
                ByteBuffer buffer;
                while ((buffer = entry.getValue().poll()) != null) {
                    this.allocatedSize.addAndGet(-buffer.capacity());
                }
            }
        }
    }

    public String toString() {
        return "BufferPool{bufferPool=" + this.bufferPool + ", allocatedSize=" + this.allocatedSize + ", initialBufferSize=" + this.initialBufferSize + ", maxBufferSize=" + this.maxBufferSize + '}';
    }
}

