/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.buffer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.sender.Sender;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuffer
extends Buffer<Config> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageBuffer.class);
    private final AtomicInteger allocatedSize = new AtomicInteger();
    private final LinkedBlockingQueue<ByteBuffer> messages = new LinkedBlockingQueue();
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final Object bufferLock = new Object();

    private MessageBuffer(Config bufferConfig) {
        super(bufferConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String tag, long timestamp, Map<String, Object> data) throws IOException {
        byte[] packedBytes = null;
        ObjectMapper objectMapper = (ObjectMapper)this.objectMapperHolder.get();
        ByteArrayOutputStream outputStream = (ByteArrayOutputStream)this.outputStreamHolder.get();
        outputStream.reset();
        objectMapper.writeValue((OutputStream)outputStream, Arrays.asList(tag, timestamp, data));
        outputStream.close();
        packedBytes = outputStream.toByteArray();
        if (((Config)this.bufferConfig).isAckResponseMode()) {
            if (packedBytes[0] != -109) {
                throw new IllegalStateException("packedBytes[0] should be 0x93, but " + packedBytes[0]);
            }
            packedBytes[0] = -108;
        }
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.allocatedSize.get() + packedBytes.length > ((Config)this.bufferConfig).getMaxBufferSize()) {
                throw new Buffer.BufferFullException("Buffer is full. bufferConfig=" + this.bufferConfig + ", allocatedSize=" + this.allocatedSize);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(packedBytes);
            this.messages.add(byteBuffer);
            this.allocatedSize.getAndAdd(packedBytes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInternal(Sender sender, boolean force) throws IOException {
        ByteBuffer message = null;
        while ((message = this.messages.poll()) != null) {
            Object object = this.bufferLock;
            synchronized (object) {
                this.allocatedSize.addAndGet(-message.capacity());
                if (((Config)this.bufferConfig).isAckResponseMode()) {
                    String uuid = UUID.randomUUID().toString();
                    sender.sendWithAck(Arrays.asList(message), uuid.getBytes(CHARSET));
                } else {
                    sender.send(message);
                }
            }
        }
    }

    @Override
    public void closeInternal(Sender sender) throws IOException {
        this.messages.clear();
    }

    @Override
    public long getAllocatedSize() {
        return this.allocatedSize.get();
    }

    public static class Config
    extends Buffer.Config<MessageBuffer, Config> {
        @Override
        public MessageBuffer createInstance() {
            return new MessageBuffer(this);
        }
    }
}

