/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.buffer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.buffer.BufferPool;
import org.komamitsu.fluency.sender.Sender;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackedForwardBuffer
extends Buffer<Config> {
    private static final Logger LOG = LoggerFactory.getLogger(PackedForwardBuffer.class);
    private final Map<String, RetentionBuffer> retentionBuffers = new HashMap<String, RetentionBuffer>();
    private final LinkedBlockingQueue<TaggableBuffer> flushableBuffers = new LinkedBlockingQueue();
    private final BufferPool bufferPool;

    private PackedForwardBuffer(Config bufferConfig) {
        super(bufferConfig);
        this.bufferPool = new BufferPool(bufferConfig.getInitialBufferSize(), bufferConfig.getMaxBufferSize());
    }

    private RetentionBuffer prepareBuffer(String tag, int writeSize) throws Buffer.BufferFullException {
        RetentionBuffer retentionBuffer = this.retentionBuffers.get(tag);
        if (retentionBuffer != null && retentionBuffer.getByteBuffer().remaining() > writeSize) {
            return retentionBuffer;
        }
        int newRetentionBufferSize = retentionBuffer == null ? ((Config)this.bufferConfig).getInitialBufferSize() : (int)((float)retentionBuffer.getByteBuffer().capacity() * ((Config)this.bufferConfig).getBufferExpandRatio());
        while (newRetentionBufferSize < writeSize) {
            newRetentionBufferSize = (int)((float)newRetentionBufferSize * ((Config)this.bufferConfig).getBufferExpandRatio());
        }
        ByteBuffer acquiredBuffer = this.bufferPool.acquireBuffer(newRetentionBufferSize);
        if (acquiredBuffer == null) {
            throw new Buffer.BufferFullException("Buffer is full. bufferConfig=" + this.bufferConfig + ", bufferPool=" + this.bufferPool);
        }
        RetentionBuffer newBuffer = new RetentionBuffer(acquiredBuffer);
        if (retentionBuffer != null) {
            retentionBuffer.getByteBuffer().flip();
            newBuffer.getByteBuffer().put(retentionBuffer.getByteBuffer());
            this.bufferPool.returnBuffer(retentionBuffer.getByteBuffer());
        }
        LOG.trace("prepareBuffer(): allocate a new buffer. tag={}, buffer={}", (Object)tag, (Object)newBuffer);
        this.retentionBuffers.put(tag, newBuffer);
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String tag, long timestamp, Map<String, Object> data) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)this.objectMapperHolder.get();
        ByteArrayOutputStream outputStream = (ByteArrayOutputStream)this.outputStreamHolder.get();
        outputStream.reset();
        objectMapper.writeValue((OutputStream)outputStream, Arrays.asList(timestamp, data));
        outputStream.close();
        Map<String, RetentionBuffer> map = this.retentionBuffers;
        synchronized (map) {
            RetentionBuffer buffer = this.prepareBuffer(tag, outputStream.size());
            buffer.getByteBuffer().put(outputStream.toByteArray());
            buffer.getLastUpdatedTimeMillis().set(System.currentTimeMillis());
            this.moveRetentionBufferIfNeeded(tag, buffer);
        }
    }

    private void moveRetentionBufferIfNeeded(String tag, RetentionBuffer buffer) throws IOException {
        if (buffer.getByteBuffer().position() > ((Config)this.bufferConfig).getBufferRetentionSize()) {
            this.moveRetentionBufferToFlushable(tag, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveRetentionBuffersToFlushable(boolean force) throws IOException {
        long expiredThreshold = System.currentTimeMillis() - (long)((Config)this.bufferConfig).getBufferRetentionTimeMillis();
        Map<String, RetentionBuffer> map = this.retentionBuffers;
        synchronized (map) {
            for (Map.Entry<String, RetentionBuffer> entry : this.retentionBuffers.entrySet()) {
                if (entry.getValue() == null || !force && entry.getValue().getLastUpdatedTimeMillis().get() >= expiredThreshold) continue;
                this.moveRetentionBufferToFlushable(entry.getKey(), entry.getValue());
            }
        }
    }

    private void moveRetentionBufferToFlushable(String tag, RetentionBuffer buffer) throws IOException {
        try {
            LOG.trace("moveRetentionBufferToFlushable(): tag={}, buffer={}", (Object)tag, (Object)buffer);
            this.flushableBuffers.put(new TaggableBuffer(tag, buffer.getByteBuffer()));
            this.retentionBuffers.put(tag, null);
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to move retention buffer due to interruption", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInternal(Sender sender, boolean force) throws IOException {
        this.moveRetentionBuffersToFlushable(force);
        TaggableBuffer flushableBuffer = null;
        while ((flushableBuffer = this.flushableBuffers.poll()) != null) {
            try {
                ByteArrayOutputStream header = new ByteArrayOutputStream();
                MessagePacker messagePacker = MessagePack.newDefaultPacker((OutputStream)header);
                LOG.trace("flushInternal(): bufferUsage={}, flushableBuffer={}", (Object)Float.valueOf(this.getBufferUsage()), (Object)flushableBuffer);
                String tag = flushableBuffer.getTag();
                ByteBuffer byteBuffer = flushableBuffer.getByteBuffer();
                if (((Config)this.bufferConfig).isAckResponseMode()) {
                    messagePacker.packArrayHeader(3);
                } else {
                    messagePacker.packArrayHeader(2);
                }
                messagePacker.packString(tag);
                messagePacker.packRawStringHeader(byteBuffer.position());
                messagePacker.flush();
                Sender sender2 = sender;
                synchronized (sender2) {
                    ByteBuffer headerBuffer = ByteBuffer.wrap(header.toByteArray());
                    byteBuffer.flip();
                    if (((Config)this.bufferConfig).isAckResponseMode()) {
                        String uuid = UUID.randomUUID().toString();
                        sender.sendWithAck(Arrays.asList(headerBuffer, byteBuffer), uuid.getBytes(CHARSET));
                    } else {
                        sender.send(Arrays.asList(headerBuffer, byteBuffer));
                    }
                }
            }
            finally {
                this.bufferPool.returnBuffer(flushableBuffer.getByteBuffer());
            }
        }
    }

    @Override
    public synchronized void closeInternal(Sender sender) throws IOException {
        this.moveRetentionBuffersToFlushable(true);
        this.retentionBuffers.clear();
        this.flush(sender, true);
        this.bufferPool.releaseBuffers();
    }

    @Override
    public long getAllocatedSize() {
        return this.bufferPool.getAllocatedSize();
    }

    public static class Config
    extends Buffer.Config<PackedForwardBuffer, Config> {
        private int initialBufferSize = 0x100000;
        private float bufferExpandRatio = 2.0f;
        private int bufferRetentionSize = 0x400000;
        private int bufferRetentionTimeMillis = 400;

        public int getInitialBufferSize() {
            return this.initialBufferSize;
        }

        public Config setInitialBufferSize(int initialBufferSize) {
            this.initialBufferSize = initialBufferSize;
            return this;
        }

        public float getBufferExpandRatio() {
            return this.bufferExpandRatio;
        }

        public Config setBufferExpandRatio(float bufferExpandRatio) {
            this.bufferExpandRatio = bufferExpandRatio;
            return this;
        }

        public int getBufferRetentionSize() {
            return this.bufferRetentionSize;
        }

        public Config setBufferRetentionSize(int bufferRetentionSize) {
            this.bufferRetentionSize = bufferRetentionSize;
            return this;
        }

        public int getBufferRetentionTimeMillis() {
            return this.bufferRetentionTimeMillis;
        }

        public Config setBufferRetentionTimeMillis(int bufferRetentionTimeMillis) {
            this.bufferRetentionTimeMillis = bufferRetentionTimeMillis;
            return this;
        }

        @Override
        public String toString() {
            return "Config{initialBufferSize=" + this.initialBufferSize + ", bufferExpandRatio=" + this.bufferExpandRatio + ", bufferRetentionSize=" + this.bufferRetentionSize + ", bufferRetentionTimeMillis=" + this.bufferRetentionTimeMillis + "} " + super.toString();
        }

        @Override
        public PackedForwardBuffer createInstance() {
            return new PackedForwardBuffer(this);
        }
    }

    private static class TaggableBuffer {
        private final String tag;
        private final ByteBuffer byteBuffer;

        public TaggableBuffer(String tag, ByteBuffer byteBuffer) {
            this.tag = tag;
            this.byteBuffer = byteBuffer;
        }

        public String getTag() {
            return this.tag;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public String toString() {
            return "TaggableBuffer{tag='" + this.tag + '\'' + ", byteBuffer=" + this.byteBuffer + '}';
        }
    }

    private static class RetentionBuffer {
        private final AtomicLong lastUpdatedTimeMillis = new AtomicLong();
        private final ByteBuffer byteBuffer;

        public RetentionBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        public AtomicLong getLastUpdatedTimeMillis() {
            return this.lastUpdatedTimeMillis;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public String toString() {
            return "ExpirableBuffer{lastUpdatedTimeMillis=" + this.lastUpdatedTimeMillis + ", byteBuffer=" + this.byteBuffer + '}';
        }
    }
}

