/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.heartbeat;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.komamitsu.fluency.sender.heartbeat.Heartbeater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPHeartbeater
extends Heartbeater {
    private static final Logger LOG = LoggerFactory.getLogger(TCPHeartbeater.class);

    private TCPHeartbeater(Config config) throws IOException {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invoke() throws IOException {
        AbstractInterruptibleChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(new InetSocketAddress(this.config.getHost(), this.config.getPort()));
            this.pong();
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
    }

    public static class Config
    extends Heartbeater.Config<Config> {
        @Override
        public TCPHeartbeater createInstance() throws IOException {
            return new TCPHeartbeater(this);
        }

        @Override
        public Config dupDefaultConfig() {
            return new Config();
        }
    }
}

