/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.sender.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Flusher<C extends Config>
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Flusher.class);
    protected final Buffer buffer;
    protected final Sender sender;
    protected final C flusherConfig;

    public Flusher(Buffer buffer, Sender sender, C flusherConfig) {
        this.buffer = buffer;
        this.sender = sender;
        this.flusherConfig = flusherConfig;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    protected abstract void flushInternal(boolean var1) throws IOException;

    protected abstract void closeInternal() throws IOException;

    public void onUpdate() throws IOException {
        this.flushInternal(false);
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal(true);
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeInternal();
        }
        finally {
            this.sender.close();
        }
    }

    protected void closeBuffer() {
        LOG.trace("closeBuffer(): closing buffer");
        try {
            this.buffer.close(this.sender);
        }
        catch (IOException e) {
            LOG.warn("Interrupted during closing buffer");
        }
        LOG.trace("closeBuffer(): closed buffer");
    }

    public static abstract class Config<T extends Flusher, C extends Config> {
        private int flushIntervalMillis = 600;

        public int getFlushIntervalMillis() {
            return this.flushIntervalMillis;
        }

        public C setFlushIntervalMillis(int flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
            return (C)this;
        }

        public abstract T createInstance(Buffer var1, Sender var2);
    }
}

