/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.retry;

public abstract class RetryStrategy<C extends Config> {
    protected final C config;

    public RetryStrategy(C config) {
        this.config = config;
    }

    public abstract long getNextIntervalMillis(int var1);

    public boolean isRetriedOver(int retryCount) {
        return retryCount > ((Config)this.config).getMaxRetryCount();
    }

    public static abstract class Config<T extends RetryStrategy, C extends Config> {
        private int maxRetryCount = 8;

        public int getMaxRetryCount() {
            return this.maxRetryCount;
        }

        public C setMaxRetryCount(int maxRetryCount) {
            this.maxRetryCount = maxRetryCount;
            return (C)this;
        }

        public abstract T createInstance();
    }
}

