/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.komamitsu.fluency.sender.AckTokenSerDe;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.OutputStreamBufferOutput;

public class MessagePackAckTokenSerDe
implements AckTokenSerDe {
    private final MessagePacker packer;
    private final MessageUnpacker unpacker;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream(64);

    public MessagePackAckTokenSerDe() {
        OutputStreamBufferOutput bufferOutput = new OutputStreamBufferOutput(new ByteArrayOutputStream(0));
        this.packer = MessagePack.newDefaultPacker(bufferOutput);
        ArrayBufferInput bufferInput = new ArrayBufferInput(new byte[0]);
        this.unpacker = MessagePack.newDefaultUnpacker(bufferInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] pack(byte[] token) throws IOException {
        MessagePacker messagePacker = this.packer;
        synchronized (messagePacker) {
            this.outputStream.reset();
            OutputStreamBufferOutput bufferOutput = new OutputStreamBufferOutput(this.outputStream);
            this.packer.reset(bufferOutput);
            this.packer.packMapHeader(1);
            this.packer.packString("chunk");
            this.packer.packBinaryHeader(token.length);
            this.packer.writePayload(token);
            this.packer.flush();
            return this.outputStream.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] unpack(byte[] packedToken) throws IOException {
        MessageUnpacker messageUnpacker = this.unpacker;
        synchronized (messageUnpacker) {
            ArrayBufferInput bufferInput = new ArrayBufferInput(packedToken);
            this.unpacker.reset(bufferInput);
            int mapLen = this.unpacker.unpackMapHeader();
            byte[] unpackedToken = null;
            for (int i = 0; i < mapLen; ++i) {
                if (!this.unpacker.unpackString().equals("ack")) continue;
                unpackedToken = new byte[this.unpacker.unpackBinaryHeader()];
                this.unpacker.readPayload(unpackedToken);
                break;
            }
            return unpackedToken;
        }
    }
}

