/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.failuredetect;

import org.komamitsu.failuredetector.PhiAccuralFailureDetector;
import org.komamitsu.fluency.sender.failuredetect.FailureDetectStrategy;

public class PhiAccrualFailureDetectStrategy
extends FailureDetectStrategy {
    private final PhiAccuralFailureDetector failureDetector;
    private final Config config;

    protected PhiAccrualFailureDetectStrategy(Config config) {
        super(config.getBaseConfig());
        this.config = config;
        this.failureDetector = new PhiAccuralFailureDetector.Builder().setThreshold(config.getPhiThreshold()).setMaxSampleSize(config.getArrivalWindowSize()).build();
    }

    @Override
    public void heartbeat(long now) {
        this.failureDetector.heartbeat(now);
    }

    @Override
    public boolean isAvailable() {
        return this.failureDetector.isAvailable();
    }

    public double getPhiThreshold() {
        return this.config.getPhiThreshold();
    }

    public int getArrivalWindowSize() {
        return this.config.getArrivalWindowSize();
    }

    public String toString() {
        return "PhiAccrualFailureDetectStrategy{failureDetector=" + this.failureDetector + "} " + super.toString();
    }

    public static class Config
    implements FailureDetectStrategy.Instantiator {
        private FailureDetectStrategy.Config baseConfig = new FailureDetectStrategy.Config();
        private double phiThreshold = 16.0;
        private int arrivalWindowSize = 100;

        public FailureDetectStrategy.Config getBaseConfig() {
            return this.baseConfig;
        }

        public double getPhiThreshold() {
            return this.phiThreshold;
        }

        public Config setPhiThreshold(float phiThreshold) {
            this.phiThreshold = phiThreshold;
            return this;
        }

        public int getArrivalWindowSize() {
            return this.arrivalWindowSize;
        }

        public Config setArrivalWindowSize(int arrivalWindowSize) {
            this.arrivalWindowSize = arrivalWindowSize;
            return this;
        }

        @Override
        public FailureDetectStrategy createInstance() {
            return new PhiAccrualFailureDetectStrategy(this);
        }
    }
}

