/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.IOException;
import java.util.Enumeration;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferInput;

public class SequenceMessageBufferInput
implements MessageBufferInput {
    private Enumeration<? extends MessageBufferInput> sequence;
    private MessageBufferInput input;

    public SequenceMessageBufferInput(Enumeration<? extends MessageBufferInput> enumeration) {
        this.sequence = Preconditions.checkNotNull(enumeration, "input sequence is null");
        try {
            this.nextInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public MessageBuffer next() throws IOException {
        if (this.input == null) {
            return null;
        }
        MessageBuffer messageBuffer = this.input.next();
        if (messageBuffer == null) {
            this.nextInput();
            return this.next();
        }
        return messageBuffer;
    }

    private void nextInput() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
        if (this.sequence.hasMoreElements()) {
            this.input = this.sequence.nextElement();
            if (this.input == null) {
                throw new NullPointerException("An element in the MessageBufferInput sequence is null");
            }
        } else {
            this.input = null;
        }
    }

    @Override
    public void close() throws IOException {
        do {
            this.nextInput();
        } while (this.input != null);
    }
}

