/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.buffer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.komamitsu.fluency.buffer.FileBackup;
import org.komamitsu.fluency.sender.Sender;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Buffer {
    private static final Logger LOG = LoggerFactory.getLogger(Buffer.class);
    protected static final Charset CHARSET = Charset.forName("ASCII");
    protected final ObjectMapper objectMapper;
    protected final FileBackup fileBackup;
    private final Config config;

    protected Buffer(Config config) {
        this.config = config;
        this.fileBackup = config.getFileBackupDir() != null ? new FileBackup(new File(config.getFileBackupDir()), this, config.getFileBackupPrefix()) : null;
        this.objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        List<Module> jacksonModules = config.getJacksonModules();
        for (Module module : jacksonModules) {
            this.objectMapper.registerModule(module);
        }
    }

    public void init() {
        if (this.fileBackup != null) {
            for (FileBackup.SavedBuffer savedBuffer : this.fileBackup.getSavedFiles()) {
                savedBuffer.open(new FileBackup.SavedBuffer.Callback(){

                    @Override
                    public void process(List<String> params, FileChannel channel) {
                        LOG.info("Loading buffer: params={}, buffer={}", params, (Object)channel);
                        Buffer.this.loadBufferFromFile(params, channel);
                    }
                });
            }
        }
    }

    public abstract void append(String var1, long var2, Map<String, Object> var4) throws IOException;

    protected abstract void loadBufferFromFile(List<String> var1, FileChannel var2);

    protected abstract void saveAllBuffersToFile() throws IOException;

    protected void saveBuffer(List<String> params, ByteBuffer buffer) {
        if (this.fileBackup == null) {
            return;
        }
        LOG.info("Saving buffer: params={}, buffer={}", params, (Object)buffer);
        this.fileBackup.saveBuffer(params, buffer);
    }

    public void flush(Sender sender, boolean force) throws IOException {
        LOG.trace("flush(): force={}, bufferUsage={}", (Object)force, (Object)Float.valueOf(this.getBufferUsage()));
        this.flushInternal(sender, force);
    }

    protected abstract void flushInternal(Sender var1, boolean var2) throws IOException;

    public abstract String bufferFormatType();

    public void close() {
        try {
            LOG.info("Saving all buffers");
            this.saveAllBuffersToFile();
        }
        catch (Exception e) {
            LOG.warn("Failed to save all buffers", (Throwable)e);
        }
        LOG.info("Closing buffers");
        this.closeInternal();
    }

    protected abstract void closeInternal();

    public abstract long getAllocatedSize();

    public long getMaxSize() {
        return this.config.getMaxBufferSize();
    }

    public float getBufferUsage() {
        return (float)this.getAllocatedSize() / (float)this.getMaxSize();
    }

    public abstract long getBufferedDataSize();

    public void clearBackupFiles() {
        if (this.fileBackup != null) {
            for (FileBackup.SavedBuffer buffer : this.fileBackup.getSavedFiles()) {
                buffer.remove();
            }
        }
    }

    public long getMaxBufferSize() {
        return this.config.getMaxBufferSize();
    }

    public boolean isAckResponseMode() {
        return this.config.isAckResponseMode();
    }

    public String getFileBackupPrefix() {
        return this.config.getFileBackupPrefix();
    }

    public String getFileBackupDir() {
        return this.config.getFileBackupDir();
    }

    public List<Module> getJacksonModules() {
        return Collections.unmodifiableList(this.config.getJacksonModules());
    }

    public String toString() {
        return "Buffer{objectMapper=" + this.objectMapper + ", fileBackup=" + this.fileBackup + ", config=" + this.config + '}';
    }

    public static interface Instantiator {
        public Buffer createInstance();
    }

    public static class Config {
        protected long maxBufferSize = 0x20000000L;
        protected boolean ackResponseMode = false;
        protected String fileBackupDir;
        protected String fileBackupPrefix;
        protected List<Module> jacksonModules = Collections.emptyList();

        public long getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public Config setMaxBufferSize(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public boolean isAckResponseMode() {
            return this.ackResponseMode;
        }

        public Config setAckResponseMode(boolean ackResponseMode) {
            this.ackResponseMode = ackResponseMode;
            return this;
        }

        public String getFileBackupDir() {
            return this.fileBackupDir;
        }

        public Config setFileBackupDir(String fileBackupDir) {
            this.fileBackupDir = fileBackupDir;
            return this;
        }

        public String getFileBackupPrefix() {
            return this.fileBackupPrefix;
        }

        public Config setFileBackupPrefix(String fileBackupPrefix) {
            this.fileBackupPrefix = fileBackupPrefix;
            return this;
        }

        public List<Module> getJacksonModules() {
            return this.jacksonModules;
        }

        public Config setJacksonModules(List<Module> jacksonModules) {
            this.jacksonModules = jacksonModules;
            return this;
        }

        public String toString() {
            return "Config{maxBufferSize=" + this.maxBufferSize + ", ackResponseMode=" + this.ackResponseMode + ", fileBackupDir='" + this.fileBackupDir + '\'' + ", fileBackupPrefix='" + this.fileBackupPrefix + '\'' + ", jacksonModules=" + this.jacksonModules + '}';
        }
    }
}

