/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import org.komamitsu.thirdparty.jackson.core.JsonEncoding;
import org.komamitsu.thirdparty.jackson.core.JsonFactory;
import org.komamitsu.thirdparty.jackson.core.JsonGenerator;
import org.komamitsu.thirdparty.jackson.core.JsonParseException;
import org.komamitsu.thirdparty.jackson.core.JsonParser;
import org.komamitsu.thirdparty.jackson.core.io.IOContext;
import org.msgpack.core.MessagePack;
import org.msgpack.jackson.dataformat.ExtensionTypeCustomDeserializers;
import org.msgpack.jackson.dataformat.MessagePackGenerator;
import org.msgpack.jackson.dataformat.MessagePackParser;

public class MessagePackFactory
extends JsonFactory {
    private static final long serialVersionUID = 2578263992015504347L;
    private final MessagePack.PackerConfig packerConfig;
    private boolean reuseResourceInGenerator = true;
    private boolean reuseResourceInParser = true;
    private ExtensionTypeCustomDeserializers extTypeCustomDesers;

    public MessagePackFactory() {
        this(MessagePack.DEFAULT_PACKER_CONFIG);
    }

    public MessagePackFactory(MessagePack.PackerConfig packerConfig) {
        this.packerConfig = packerConfig;
    }

    public MessagePackFactory setReuseResourceInGenerator(boolean bl) {
        this.reuseResourceInGenerator = bl;
        return this;
    }

    public MessagePackFactory setReuseResourceInParser(boolean bl) {
        this.reuseResourceInParser = bl;
        return this;
    }

    public MessagePackFactory setExtTypeCustomDesers(ExtensionTypeCustomDeserializers extensionTypeCustomDeserializers) {
        this.extTypeCustomDesers = extensionTypeCustomDeserializers;
        return this;
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return new MessagePackGenerator(this._generatorFeatures, this._objectCodec, outputStream, this.packerConfig, this.reuseResourceInGenerator);
    }

    @Override
    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        return this.createGenerator(new FileOutputStream(file), jsonEncoding);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonParser createParser(byte[] byArray) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(byArray, false);
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    @Override
    public JsonParser createParser(InputStream inputStream) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(inputStream, false);
        return this._createParser(inputStream, iOContext);
    }

    @Override
    protected MessagePackParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException {
        MessagePackParser messagePackParser = new MessagePackParser(iOContext, this._parserFeatures, this._objectCodec, inputStream, this.reuseResourceInParser);
        if (this.extTypeCustomDesers != null) {
            messagePackParser.setExtensionTypeCustomDeserializers(this.extTypeCustomDesers);
        }
        return messagePackParser;
    }

    @Override
    protected JsonParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        if (n != 0 || n2 != byArray.length) {
            byArray = Arrays.copyOfRange(byArray, n, n + n2);
        }
        MessagePackParser messagePackParser = new MessagePackParser(iOContext, this._parserFeatures, this._objectCodec, byArray, this.reuseResourceInParser);
        if (this.extTypeCustomDesers != null) {
            messagePackParser.setExtensionTypeCustomDeserializers(this.extTypeCustomDesers);
        }
        return messagePackParser;
    }
}

