/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;
import org.msgpack.jackson.dataformat.MessagePackGenerator;

@JsonSerialize(using=Serilizer.class)
public class EventTime {
    private final int seconds;
    private final int nanoSeconds;

    public static EventTime fromEpoch(int epochSeconds) {
        return new EventTime(epochSeconds, 0);
    }

    public static EventTime fromEpoch(int epochSeconds, int nanoSeconds) {
        return new EventTime(epochSeconds, nanoSeconds);
    }

    public static EventTime fromEpochMilli(long epochMilliSecond) {
        return new EventTime((int)(epochMilliSecond / 1000L), (int)(epochMilliSecond % 1000L * 1000000L));
    }

    public EventTime(int seconds, int nanoSeconds) {
        this.seconds = seconds;
        this.nanoSeconds = nanoSeconds;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNanoSeconds() {
        return this.nanoSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventTime)) {
            return false;
        }
        EventTime eventTime = (EventTime)o;
        if (this.seconds != eventTime.seconds) {
            return false;
        }
        return this.nanoSeconds == eventTime.nanoSeconds;
    }

    public int hashCode() {
        int result = this.seconds;
        result = 31 * result + this.nanoSeconds;
        return result;
    }

    public String toString() {
        return "EventTime{seconds=" + this.seconds + ", nanoSeconds=" + this.nanoSeconds + '}';
    }

    public static class Serilizer
    extends StdSerializer<EventTime> {
        public Serilizer() {
            super(EventTime.class);
        }

        protected Serilizer(Class<EventTime> t) {
            super(t);
        }

        public void serialize(EventTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (!(gen instanceof MessagePackGenerator)) {
                throw new IllegalStateException("This class should be serialized by MessagePackGenerator, but `gen` is " + gen.getClass());
            }
            MessagePackGenerator messagePackGenerator = (MessagePackGenerator)gen;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putInt(value.seconds).putInt(value.nanoSeconds);
            messagePackGenerator.writeExtensionType(new MessagePackExtensionType(0, buffer.array()));
        }
    }
}

