/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.sender.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Flusher
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Flusher.class);
    private final AtomicBoolean isTerminated = new AtomicBoolean();
    protected final Buffer buffer;
    protected final Sender sender;
    private final Config config;

    protected Flusher(Buffer buffer, Sender sender, Config config) {
        this.buffer = buffer;
        this.sender = sender;
        this.config = config;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    protected abstract void flushInternal(boolean var1) throws IOException;

    protected abstract void beforeClosingBuffer() throws IOException;

    public void onUpdate() throws IOException {
        this.flushInternal(false);
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void close() throws IOException {
        block97: {
            this.beforeClosingBuffer();
            this.sender.close();
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Void> future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Flusher.this.closeBuffer();
                    Flusher.this.isTerminated.set(true);
                    return null;
                }
            });
            try {
                future.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOG.warn("closeBuffer() failed", (Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.warn("closeBuffer() timed out", (Throwable)e);
            }
            finally {
                executorService.shutdown();
            }
            catch (Exception e) {
                try {
                    LOG.error("Failed to close the sender", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ExecutorService executorService2 = Executors.newSingleThreadExecutor();
                    Future<Void> future2 = executorService2.submit(new /* invalid duplicate definition of identical inner class */);
                    try {
                        future2.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e2) {
                        LOG.warn("Interrupted", (Throwable)e2);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e3) {
                        LOG.warn("closeBuffer() failed", (Throwable)e3);
                    }
                    catch (TimeoutException e4) {
                        LOG.warn("closeBuffer() timed out", (Throwable)e4);
                    }
                    finally {
                        executorService2.shutdown();
                    }
                    throw throwable;
                }
                executorService = Executors.newSingleThreadExecutor();
                future = executorService.submit(new /* invalid duplicate definition of identical inner class */);
                try {
                    future.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
                    break block97;
                }
                catch (InterruptedException e5) {
                    LOG.warn("Interrupted", (Throwable)e5);
                    Thread.currentThread().interrupt();
                    break block97;
                }
                catch (ExecutionException e6) {
                    LOG.warn("closeBuffer() failed", (Throwable)e6);
                    break block97;
                }
                catch (TimeoutException e7) {
                    LOG.warn("closeBuffer() timed out", (Throwable)e7);
                    break block97;
                }
                finally {
                    executorService.shutdown();
                }
            }
            catch (Exception e) {
                try {
                    LOG.error("Failed to call beforeClosingBuffer()", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.sender.close();
                    ExecutorService executorService3 = Executors.newSingleThreadExecutor();
                    Future<Void> future3 = executorService3.submit(new /* invalid duplicate definition of identical inner class */);
                    try {
                        future3.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e8) {
                        LOG.warn("Interrupted", (Throwable)e8);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e9) {
                        LOG.warn("closeBuffer() failed", (Throwable)e9);
                    }
                    catch (TimeoutException e10) {
                        LOG.warn("closeBuffer() timed out", (Throwable)e10);
                    }
                    finally {
                        executorService3.shutdown();
                    }
                    catch (Exception e11) {
                        try {
                            LOG.error("Failed to close the sender", (Throwable)e11);
                        }
                        catch (Throwable throwable2) {
                            ExecutorService executorService4 = Executors.newSingleThreadExecutor();
                            Future<Void> future4 = executorService4.submit(new /* invalid duplicate definition of identical inner class */);
                            try {
                                future4.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e12) {
                                LOG.warn("Interrupted", (Throwable)e12);
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException e13) {
                                LOG.warn("closeBuffer() failed", (Throwable)e13);
                            }
                            catch (TimeoutException e14) {
                                LOG.warn("closeBuffer() timed out", (Throwable)e14);
                            }
                            finally {
                                executorService4.shutdown();
                            }
                            throw throwable2;
                        }
                        executorService2 = Executors.newSingleThreadExecutor();
                        future2 = executorService2.submit(new /* invalid duplicate definition of identical inner class */);
                        try {
                            future2.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e15) {
                            LOG.warn("Interrupted", (Throwable)e15);
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException e16) {
                            LOG.warn("closeBuffer() failed", (Throwable)e16);
                        }
                        catch (TimeoutException e17) {
                            LOG.warn("closeBuffer() timed out", (Throwable)e17);
                        }
                        finally {
                            executorService2.shutdown();
                        }
                    }
                    throw throwable;
                }
                this.sender.close();
                executorService = Executors.newSingleThreadExecutor();
                future = executorService.submit(new /* invalid duplicate definition of identical inner class */);
                try {
                    future.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e18) {
                    LOG.warn("Interrupted", (Throwable)e18);
                    Thread.currentThread().interrupt();
                    break block97;
                }
                catch (ExecutionException e19) {
                    LOG.warn("closeBuffer() failed", (Throwable)e19);
                    break block97;
                }
                catch (TimeoutException e20) {
                    LOG.warn("closeBuffer() timed out", (Throwable)e20);
                    break block97;
                }
                finally {
                    executorService.shutdown();
                }
                catch (Exception e21) {
                    try {
                        LOG.error("Failed to close the sender", (Throwable)e21);
                    }
                    catch (Throwable throwable) {
                        ExecutorService executorService5 = Executors.newSingleThreadExecutor();
                        Future<Void> future5 = executorService5.submit(new /* invalid duplicate definition of identical inner class */);
                        try {
                            future5.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e22) {
                            LOG.warn("Interrupted", (Throwable)e22);
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException e23) {
                            LOG.warn("closeBuffer() failed", (Throwable)e23);
                        }
                        catch (TimeoutException e24) {
                            LOG.warn("closeBuffer() timed out", (Throwable)e24);
                        }
                        finally {
                            executorService5.shutdown();
                        }
                        throw throwable;
                    }
                    executorService = Executors.newSingleThreadExecutor();
                    future = executorService.submit(new /* invalid duplicate definition of identical inner class */);
                    try {
                        future.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e25) {
                        LOG.warn("Interrupted", (Throwable)e25);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e26) {
                        LOG.warn("closeBuffer() failed", (Throwable)e26);
                    }
                    catch (TimeoutException e27) {
                        LOG.warn("closeBuffer() timed out", (Throwable)e27);
                    }
                    finally {
                        executorService.shutdown();
                    }
                }
            }
        }
    }

    public boolean isTerminated() {
        return this.isTerminated.get();
    }

    private void closeBuffer() {
        LOG.trace("closeBuffer(): closing buffer");
        this.buffer.close();
    }

    public Sender getSender() {
        return this.sender;
    }

    public int getFlushIntervalMillis() {
        return this.config.getFlushIntervalMillis();
    }

    public int getWaitUntilBufferFlushed() {
        return this.config.getWaitUntilBufferFlushed();
    }

    public int getWaitUntilTerminated() {
        return this.config.getWaitUntilTerminated();
    }

    public String toString() {
        return "Flusher{isTerminated=" + this.isTerminated + ", buffer=" + this.buffer + ", sender=" + this.sender + ", config=" + this.config + '}';
    }

    public static interface Instantiator {
        public Flusher createInstance(Buffer var1, Sender var2);
    }

    public static class Config {
        private int flushIntervalMillis = 600;
        private int waitUntilBufferFlushed = 60;
        private int waitUntilTerminated = 60;

        public int getFlushIntervalMillis() {
            return this.flushIntervalMillis;
        }

        public Config setFlushIntervalMillis(int flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
            return this;
        }

        public int getWaitUntilBufferFlushed() {
            return this.waitUntilBufferFlushed;
        }

        public Config setWaitUntilBufferFlushed(int waitUntilBufferFlushed) {
            this.waitUntilBufferFlushed = waitUntilBufferFlushed;
            return this;
        }

        public int getWaitUntilTerminated() {
            return this.waitUntilTerminated;
        }

        public Config setWaitUntilTerminated(int waitUntilTerminated) {
            this.waitUntilTerminated = waitUntilTerminated;
            return this;
        }

        public String toString() {
            return "Config{flushIntervalMillis=" + this.flushIntervalMillis + ", waitUntilBufferFlushed=" + this.waitUntilBufferFlushed + ", waitUntilTerminated=" + this.waitUntilTerminated + '}';
        }
    }
}

