/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.flusher.Flusher;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.util.ExecutorServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFlusher
extends Flusher {
    private static final Logger LOG = LoggerFactory.getLogger(SyncFlusher.class);
    private final AtomicLong lastFlushTimeMillis = new AtomicLong();
    private final Config config;

    private SyncFlusher(Buffer buffer, Sender sender, Config config) {
        super(buffer, sender, config.getBaseConfig());
        this.config = config;
        this.lastFlushTimeMillis.set(System.currentTimeMillis());
    }

    @Override
    protected void flushInternal(boolean force) throws IOException {
        long now = System.currentTimeMillis();
        if (force || now > this.lastFlushTimeMillis.get() + (long)this.config.getFlushIntervalMillis() || this.buffer.getBufferUsage() > this.config.getBufferOccupancyThreshold()) {
            this.buffer.flush(this.sender, force);
            this.lastFlushTimeMillis.set(now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeClosingBuffer() throws IOException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Void> future = executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SyncFlusher.this.flushInternal(true);
                return null;
            }
        });
        try {
            future.get(this.config.getWaitUntilBufferFlushed(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.warn("flushInternal() failed", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.warn("flushInternal() timed out", (Throwable)e);
        }
        finally {
            ExecutorServiceUtils.finishExecutorService(executorService);
        }
    }

    public float getBufferOccupancyThreshold() {
        return this.config.getBufferOccupancyThreshold();
    }

    @Override
    public String toString() {
        return "SyncFlusher{lastFlushTimeMillis=" + this.lastFlushTimeMillis + ", config=" + this.config + "} " + super.toString();
    }

    public static class Config
    implements Flusher.Instantiator {
        private final Flusher.Config baseConfig = new Flusher.Config();
        private float bufferOccupancyThreshold = 0.6f;

        public Flusher.Config getBaseConfig() {
            return this.baseConfig;
        }

        public int getFlushIntervalMillis() {
            return this.baseConfig.getFlushIntervalMillis();
        }

        public Config setFlushIntervalMillis(int flushIntervalMillis) {
            this.baseConfig.setFlushIntervalMillis(flushIntervalMillis);
            return this;
        }

        public int getWaitUntilBufferFlushed() {
            return this.baseConfig.getWaitUntilBufferFlushed();
        }

        public Config setWaitUntilBufferFlushed(int wait) {
            this.baseConfig.setWaitUntilBufferFlushed(wait);
            return this;
        }

        public int getWaitUntilTerminated() {
            return this.baseConfig.getWaitUntilTerminated();
        }

        public Config setWaitUntilTerminated(int wait) {
            this.baseConfig.setWaitUntilTerminated(wait);
            return this;
        }

        public float getBufferOccupancyThreshold() {
            return this.bufferOccupancyThreshold;
        }

        public Config setBufferOccupancyThreshold(float bufferOccupancyThreshold) {
            this.bufferOccupancyThreshold = bufferOccupancyThreshold;
            return this;
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + ", bufferOccupancyThreshold=" + this.bufferOccupancyThreshold + '}';
        }

        @Override
        public SyncFlusher createInstance(Buffer buffer, Sender sender) {
            return new SyncFlusher(buffer, sender, this);
        }
    }
}

