/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class Sender
implements Closeable {
    private final Config config;

    protected Sender(Config config) {
        this.config = config;
    }

    public synchronized void send(ByteBuffer data) throws IOException {
        this.sendInternalWithRestoreBufferPositions(Arrays.asList(data), null);
    }

    public synchronized void send(List<ByteBuffer> dataList) throws IOException {
        this.sendInternalWithRestoreBufferPositions(dataList, null);
    }

    public void sendWithAck(List<ByteBuffer> dataList, byte[] ackToken) throws IOException {
        this.sendInternalWithRestoreBufferPositions(dataList, ackToken);
    }

    private void sendInternalWithRestoreBufferPositions(List<ByteBuffer> dataList, byte[] ackToken) throws IOException {
        ArrayList<Integer> positions = new ArrayList<Integer>(dataList.size());
        for (ByteBuffer data : dataList) {
            positions.add(data.position());
        }
        try {
            this.sendInternal(dataList, ackToken);
        }
        catch (Exception e) {
            for (int i = 0; i < dataList.size(); ++i) {
                dataList.get(i).position((Integer)positions.get(i));
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public abstract boolean isAvailable();

    protected abstract void sendInternal(List<ByteBuffer> var1, byte[] var2) throws IOException;

    public static interface Instantiator {
        public Sender createInstance();
    }

    public static class Config {
    }
}

