/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.buffer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.komamitsu.fluency.BufferFullException;
import org.komamitsu.fluency.EventTime;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.buffer.BufferPool;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.thirdparty.jackson.databind.Module;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackedForwardBuffer
extends Buffer {
    public static final String FORMAT_TYPE = "packed_forward";
    private static final Logger LOG = LoggerFactory.getLogger(PackedForwardBuffer.class);
    private final Map<String, RetentionBuffer> retentionBuffers = new HashMap<String, RetentionBuffer>();
    private final LinkedBlockingQueue<TaggableBuffer> flushableBuffers = new LinkedBlockingQueue();
    private final Queue<TaggableBuffer> backupBuffers = new ConcurrentLinkedQueue<TaggableBuffer>();
    private final BufferPool bufferPool;
    private final Config config;

    protected PackedForwardBuffer(Config config) {
        super(config.getBaseConfig());
        this.config = config;
        if (config.getChunkInitialSize() > config.getChunkRetentionSize()) {
            LOG.warn("Initial Buffer Chunk Size ({}) shouldn't be more than Buffer Chunk Retention Size ({}) for better performance.", (Object)config.getChunkInitialSize(), (Object)config.getChunkRetentionSize());
        }
        this.bufferPool = new BufferPool(config.getChunkInitialSize(), config.getMaxBufferSize(), config.jvmHeapBufferMode);
    }

    private RetentionBuffer prepareBuffer(String tag, int writeSize) throws BufferFullException {
        int newBufferChunkRetentionSize;
        RetentionBuffer retentionBuffer = this.retentionBuffers.get(tag);
        if (retentionBuffer != null && retentionBuffer.getByteBuffer().remaining() > writeSize) {
            return retentionBuffer;
        }
        int existingDataSize = 0;
        if (retentionBuffer == null) {
            newBufferChunkRetentionSize = this.config.getChunkInitialSize();
        } else {
            existingDataSize = retentionBuffer.getByteBuffer().position();
            newBufferChunkRetentionSize = (int)((float)retentionBuffer.getByteBuffer().capacity() * this.config.getChunkExpandRatio());
        }
        while (newBufferChunkRetentionSize < writeSize + existingDataSize) {
            newBufferChunkRetentionSize = (int)((float)newBufferChunkRetentionSize * this.config.getChunkExpandRatio());
        }
        ByteBuffer acquiredBuffer = this.bufferPool.acquireBuffer(newBufferChunkRetentionSize);
        if (acquiredBuffer == null) {
            throw new BufferFullException("Buffer is full. config=" + this.config + ", bufferPool=" + this.bufferPool);
        }
        RetentionBuffer newBuffer = new RetentionBuffer(acquiredBuffer);
        if (retentionBuffer != null) {
            retentionBuffer.getByteBuffer().flip();
            newBuffer.getByteBuffer().put(retentionBuffer.getByteBuffer());
            newBuffer.getCreatedTimeMillis().set(System.currentTimeMillis());
            this.bufferPool.returnBuffer(retentionBuffer.getByteBuffer());
        }
        LOG.trace("prepareBuffer(): allocate a new buffer. tag={}, buffer={}", (Object)tag, (Object)newBuffer);
        this.retentionBuffers.put(tag, newBuffer);
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataToRetentionBuffers(String tag, ByteBuffer src) throws IOException {
        Map<String, RetentionBuffer> map = this.retentionBuffers;
        synchronized (map) {
            RetentionBuffer buffer = this.prepareBuffer(tag, src.remaining());
            buffer.getByteBuffer().put(src);
            this.moveRetentionBufferIfNeeded(tag, buffer);
        }
    }

    @Override
    protected void loadBufferFromFile(List<String> params, FileChannel channel) {
        if (params.size() != 1) {
            throw new IllegalArgumentException("The number of params should be 1: params=" + params);
        }
        String tag = params.get(0);
        try {
            MappedByteBuffer src = channel.map(FileChannel.MapMode.PRIVATE, 0L, channel.size());
            this.loadDataToRetentionBuffers(tag, src);
        }
        catch (Exception e) {
            LOG.error("Failed to load data to flushableBuffers: params={}, channel={}", (Object)params, (Object)channel);
        }
    }

    private void saveBuffer(TaggableBuffer buffer) {
        this.saveBuffer(Collections.singletonList(buffer.getTag()), buffer.getByteBuffer());
    }

    @Override
    protected void saveAllBuffersToFile() throws IOException {
        TaggableBuffer flushableBuffer;
        this.moveRetentionBuffersToFlushable(true);
        while ((flushableBuffer = this.flushableBuffers.poll()) != null) {
            this.saveBuffer(flushableBuffer);
        }
        while ((flushableBuffer = this.backupBuffers.poll()) != null) {
            this.saveBuffer(flushableBuffer);
        }
    }

    private void appendInternal(String tag, Object timestamp, Map<String, Object> data) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.reset();
        this.objectMapper.writeValue(outputStream, Arrays.asList(timestamp, data));
        outputStream.close();
        this.loadDataToRetentionBuffers(tag, ByteBuffer.wrap(outputStream.toByteArray()));
    }

    @Override
    public void append(String tag, long timestamp, Map<String, Object> data) throws IOException {
        this.appendInternal(tag, timestamp, data);
    }

    @Override
    public void append(String tag, EventTime timestamp, Map<String, Object> data) throws IOException {
        this.appendInternal(tag, timestamp, data);
    }

    private void moveRetentionBufferIfNeeded(String tag, RetentionBuffer buffer) throws IOException {
        if (buffer.getByteBuffer().position() > this.config.getChunkRetentionSize()) {
            this.moveRetentionBufferToFlushable(tag, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveRetentionBuffersToFlushable(boolean force) throws IOException {
        long expiredThreshold = System.currentTimeMillis() - (long)this.config.getChunkRetentionTimeMillis();
        Map<String, RetentionBuffer> map = this.retentionBuffers;
        synchronized (map) {
            for (Map.Entry<String, RetentionBuffer> entry : this.retentionBuffers.entrySet()) {
                if (entry.getValue() == null || !force && entry.getValue().getCreatedTimeMillis().get() >= expiredThreshold) continue;
                this.moveRetentionBufferToFlushable(entry.getKey(), entry.getValue());
            }
        }
    }

    private void moveRetentionBufferToFlushable(String tag, RetentionBuffer buffer) throws IOException {
        try {
            LOG.trace("moveRetentionBufferToFlushable(): tag={}, buffer={}", (Object)tag, (Object)buffer);
            buffer.getByteBuffer().flip();
            this.flushableBuffers.put(new TaggableBuffer(tag, buffer.getByteBuffer()));
            this.retentionBuffers.put(tag, null);
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to move retention buffer due to interruption", e);
        }
    }

    @Override
    public String bufferFormatType() {
        return FORMAT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInternal(Sender sender, boolean force) throws IOException {
        TaggableBuffer flushableBuffer;
        this.moveRetentionBuffersToFlushable(force);
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        MessagePacker messagePacker = MessagePack.newDefaultPacker(header);
        while (!Thread.currentThread().isInterrupted() && (flushableBuffer = this.flushableBuffers.poll()) != null) {
            boolean keepBuffer = false;
            try {
                LOG.trace("flushInternal(): bufferUsage={}, flushableBuffer={}", (Object)Float.valueOf(this.getBufferUsage()), (Object)flushableBuffer);
                String tag = flushableBuffer.getTag();
                ByteBuffer byteBuffer = flushableBuffer.getByteBuffer();
                if (this.config.isAckResponseMode()) {
                    messagePacker.packArrayHeader(3);
                } else {
                    messagePacker.packArrayHeader(2);
                }
                messagePacker.packString(tag);
                messagePacker.packRawStringHeader(byteBuffer.limit());
                messagePacker.flush();
                try {
                    ByteBuffer headerBuffer = ByteBuffer.wrap(header.toByteArray());
                    List<ByteBuffer> dataList = Arrays.asList(headerBuffer, byteBuffer);
                    if (this.config.isAckResponseMode()) {
                        String uuid = UUID.randomUUID().toString();
                        byte[] uuidBytes = uuid.getBytes(CHARSET);
                        Sender sender2 = sender;
                        synchronized (sender2) {
                            sender.sendWithAck(dataList, uuidBytes);
                            continue;
                        }
                    }
                    Sender sender3 = sender;
                    synchronized (sender3) {
                        sender.send(dataList);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to send data. The data is going to be saved into the buffer again: data={}", (Object)flushableBuffer);
                    keepBuffer = true;
                    throw e;
                }
            }
            finally {
                header.reset();
                if (keepBuffer) {
                    try {
                        this.flushableBuffers.put(flushableBuffer);
                    }
                    catch (InterruptedException e1) {
                        LOG.warn("Failed to save the data into the buffer. Trying to save it in extra buffer: chunk={}", (Object)flushableBuffer);
                        this.backupBuffers.add(flushableBuffer);
                    }
                    continue;
                }
                this.bufferPool.returnBuffer(flushableBuffer.getByteBuffer());
            }
        }
    }

    @Override
    protected synchronized void closeInternal() {
        this.retentionBuffers.clear();
        this.bufferPool.releaseBuffers();
    }

    @Override
    public long getAllocatedSize() {
        return this.bufferPool.getAllocatedSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBufferedDataSize() {
        long size = 0L;
        Map<String, RetentionBuffer> map = this.retentionBuffers;
        synchronized (map) {
            for (Map.Entry<String, RetentionBuffer> buffer : this.retentionBuffers.entrySet()) {
                if (buffer.getValue() == null || buffer.getValue().getByteBuffer() == null) continue;
                size += (long)buffer.getValue().getByteBuffer().position();
            }
        }
        for (TaggableBuffer buffer : this.flushableBuffers) {
            if (buffer.getByteBuffer() == null) continue;
            size += (long)buffer.getByteBuffer().remaining();
        }
        return size;
    }

    public boolean getJvmHeapBufferMode() {
        return this.bufferPool.getJvmHeapBufferMode();
    }

    public int getChunkInitialSize() {
        return this.config.getChunkInitialSize();
    }

    public float getChunkExpandRatio() {
        return this.config.getChunkExpandRatio();
    }

    public int getChunkRetentionSize() {
        return this.config.getChunkRetentionSize();
    }

    public int getChunkRetentionTimeMillis() {
        return this.config.getChunkRetentionTimeMillis();
    }

    @Override
    public String toString() {
        return "PackedForwardBuffer{retentionBuffers=" + this.retentionBuffers + ", flushableBuffers=" + this.flushableBuffers + ", backupBuffers=" + this.backupBuffers + ", bufferPool=" + this.bufferPool + ", config=" + this.config + "} " + super.toString();
    }

    public static class Config
    implements Buffer.Instantiator {
        private Buffer.Config baseConfig = new Buffer.Config();
        private int chunkInitialSize = 0x100000;
        private float chunkExpandRatio = 2.0f;
        private int chunkRetentionSize = 0x400000;
        private int chunkRetentionTimeMillis = 1000;
        private boolean jvmHeapBufferMode = false;

        public Buffer.Config getBaseConfig() {
            return this.baseConfig;
        }

        public long getMaxBufferSize() {
            return this.baseConfig.getMaxBufferSize();
        }

        public Config setMaxBufferSize(long maxBufferSize) {
            this.baseConfig.setMaxBufferSize(maxBufferSize);
            return this;
        }

        public Config setFileBackupPrefix(String fileBackupPrefix) {
            this.baseConfig.setFileBackupPrefix(fileBackupPrefix);
            return this;
        }

        public Config setFileBackupDir(String fileBackupDir) {
            this.baseConfig.setFileBackupDir(fileBackupDir);
            return this;
        }

        public Config setAckResponseMode(boolean ackResponseMode) {
            this.baseConfig.setAckResponseMode(ackResponseMode);
            return this;
        }

        public boolean isAckResponseMode() {
            return this.baseConfig.isAckResponseMode();
        }

        public List<Module> getJacksonModules() {
            return this.baseConfig.getJacksonModules();
        }

        public String getFileBackupPrefix() {
            return this.baseConfig.getFileBackupPrefix();
        }

        public String getFileBackupDir() {
            return this.baseConfig.getFileBackupDir();
        }

        public Config setJacksonModules(List<Module> jacksonModules) {
            this.baseConfig.setJacksonModules(jacksonModules);
            return this;
        }

        public int getChunkInitialSize() {
            return this.chunkInitialSize;
        }

        public Config setChunkInitialSize(int chunkInitialSize) {
            this.chunkInitialSize = chunkInitialSize;
            return this;
        }

        public float getChunkExpandRatio() {
            return this.chunkExpandRatio;
        }

        public Config setChunkExpandRatio(float chunkExpandRatio) {
            this.chunkExpandRatio = chunkExpandRatio;
            return this;
        }

        public int getChunkRetentionSize() {
            return this.chunkRetentionSize;
        }

        public Config setChunkRetentionSize(int chunkRetentionSize) {
            this.chunkRetentionSize = chunkRetentionSize;
            return this;
        }

        public int getChunkRetentionTimeMillis() {
            return this.chunkRetentionTimeMillis;
        }

        public Config setChunkRetentionTimeMillis(int chunkRetentionTimeMillis) {
            this.chunkRetentionTimeMillis = chunkRetentionTimeMillis;
            return this;
        }

        public boolean getJvmHeapBufferMode() {
            return this.jvmHeapBufferMode;
        }

        public Config setJvmHeapBufferMode(boolean jvmHeapBufferMode) {
            this.jvmHeapBufferMode = jvmHeapBufferMode;
            return this;
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + ", chunkInitialSize=" + this.chunkInitialSize + ", chunkExpandRatio=" + this.chunkExpandRatio + ", chunkRetentionSize=" + this.chunkRetentionSize + ", chunkRetentionTimeMillis=" + this.chunkRetentionTimeMillis + ", jvmHeapBufferMode=" + this.jvmHeapBufferMode + '}';
        }

        protected PackedForwardBuffer createInstanceInternal() {
            return new PackedForwardBuffer(this);
        }

        @Override
        public PackedForwardBuffer createInstance() {
            PackedForwardBuffer buffer = new PackedForwardBuffer(this);
            buffer.init();
            return buffer;
        }
    }

    private static class TaggableBuffer {
        private final String tag;
        private final ByteBuffer byteBuffer;

        public TaggableBuffer(String tag, ByteBuffer byteBuffer) {
            this.tag = tag;
            this.byteBuffer = byteBuffer;
        }

        public String getTag() {
            return this.tag;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public String toString() {
            return "TaggableBuffer{tag='" + this.tag + '\'' + ", byteBuffer=" + this.byteBuffer + '}';
        }
    }

    private static class RetentionBuffer {
        private final AtomicLong createdTimeMillis = new AtomicLong();
        private final ByteBuffer byteBuffer;

        public RetentionBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        public AtomicLong getCreatedTimeMillis() {
            return this.createdTimeMillis;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public String toString() {
            return "RetentionBuffer{createdTimeMillis=" + this.createdTimeMillis + ", byteBuffer=" + this.byteBuffer + '}';
        }
    }
}

