/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.komamitsu.thirdparty.jackson.core.type.TypeReference;
import org.komamitsu.thirdparty.jackson.databind.ObjectMapper;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class ExtensionTypeCustomDeserializers {
    private final ObjectMapper objectMapper;
    private Map<Byte, Deser> deserTable = new ConcurrentHashMap<Byte, Deser>();

    public ExtensionTypeCustomDeserializers() {
        this.objectMapper = new ObjectMapper(new MessagePackFactory().setReuseResourceInParser(false));
    }

    public <T> void addTargetClass(byte by, final Class<T> clazz) {
        this.deserTable.put(by, new Deser(){

            @Override
            public Object deserialize(byte[] byArray) throws IOException {
                return ExtensionTypeCustomDeserializers.this.objectMapper.readValue(byArray, clazz);
            }
        });
    }

    public void addTargetTypeReference(byte by, final TypeReference typeReference) {
        this.deserTable.put(by, new Deser(){

            @Override
            public Object deserialize(byte[] byArray) throws IOException {
                return ExtensionTypeCustomDeserializers.this.objectMapper.readValue(byArray, typeReference);
            }
        });
    }

    public void addCustomDeser(byte by, final Deser deser) {
        this.deserTable.put(by, new Deser(){

            @Override
            public Object deserialize(byte[] byArray) throws IOException {
                return deser.deserialize(byArray);
            }
        });
    }

    public Deser getDeser(byte by) {
        return this.deserTable.get(by);
    }

    public void clearEntries() {
        this.deserTable.clear();
    }

    public static interface Deser {
        public Object deserialize(byte[] var1) throws IOException;
    }
}

