/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.komamitsu.thirdparty.jackson.core.Base64Variant;
import org.komamitsu.thirdparty.jackson.core.JsonGenerationException;
import org.komamitsu.thirdparty.jackson.core.JsonGenerator;
import org.komamitsu.thirdparty.jackson.core.ObjectCodec;
import org.komamitsu.thirdparty.jackson.core.SerializableString;
import org.komamitsu.thirdparty.jackson.core.base.GeneratorBase;
import org.komamitsu.thirdparty.jackson.core.io.SerializedString;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.buffer.OutputStreamBufferOutput;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;
import org.msgpack.jackson.dataformat.MessagePackSerializedString;

public class MessagePackGenerator
extends GeneratorBase {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final MessagePacker messagePacker;
    private static ThreadLocal<OutputStreamBufferOutput> messageBufferOutputHolder = new ThreadLocal();
    private final OutputStream output;
    private final MessagePack.PackerConfig packerConfig;
    private LinkedList<StackItem> stack;
    private StackItem rootStackItem;

    public MessagePackGenerator(int n, ObjectCodec objectCodec, OutputStream outputStream, MessagePack.PackerConfig packerConfig, boolean bl) throws IOException {
        super(n, objectCodec);
        OutputStreamBufferOutput outputStreamBufferOutput;
        this.output = outputStream;
        if (bl) {
            outputStreamBufferOutput = messageBufferOutputHolder.get();
            if (outputStreamBufferOutput == null) {
                outputStreamBufferOutput = new OutputStreamBufferOutput(outputStream);
                messageBufferOutputHolder.set(outputStreamBufferOutput);
            } else {
                outputStreamBufferOutput.reset(outputStream);
            }
        } else {
            outputStreamBufferOutput = new OutputStreamBufferOutput(outputStream);
        }
        this.messagePacker = packerConfig.newPacker(outputStreamBufferOutput);
        this.packerConfig = packerConfig;
        this.stack = new LinkedList();
    }

    @Override
    public void writeStartArray() throws IOException, JsonGenerationException {
        this._writeContext = this._writeContext.createChildArrayContext();
        this.stack.push(new StackItemForArray());
    }

    @Override
    public void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an array but " + this._writeContext.getTypeDesc());
        }
        this.getStackTopForArray();
        this._writeContext = this._writeContext.getParent();
        this.popStackAndStoreTheItemAsValue();
    }

    @Override
    public void writeStartObject() throws IOException, JsonGenerationException {
        this._writeContext = this._writeContext.createChildObjectContext();
        this.stack.push(new StackItemForObject());
    }

    @Override
    public void writeEndObject() throws IOException, JsonGenerationException {
        StackItemForObject stackItemForObject;
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        if ((stackItemForObject = this.getStackTopForObject()).getKeys().size() != stackItemForObject.getValues().size()) {
            throw new IllegalStateException(String.format("objectKeys.size() and objectValues.size() is not same: depth=%d, key=%d, value=%d", this.stack.size(), stackItemForObject.getKeys().size(), stackItemForObject.getValues().size()));
        }
        this._writeContext = this._writeContext.getParent();
        this.popStackAndStoreTheItemAsValue();
    }

    private void pack(Object object) throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        if (object == null) {
            messagePacker.packNil();
        } else if (object instanceof Integer) {
            messagePacker.packInt((Integer)object);
        } else if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            int n = byteBuffer.remaining();
            if (byteBuffer.hasArray()) {
                messagePacker.packBinaryHeader(n);
                messagePacker.writePayload(byteBuffer.array(), byteBuffer.arrayOffset(), n);
            } else {
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                messagePacker.packBinaryHeader(n);
                messagePacker.addPayload(byArray);
            }
        } else if (object instanceof String) {
            messagePacker.packString((String)object);
        } else if (object instanceof Float) {
            messagePacker.packFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            messagePacker.packLong((Long)object);
        } else if (object instanceof StackItemForObject) {
            this.packObject((StackItemForObject)object);
        } else if (object instanceof StackItemForArray) {
            this.packArray((StackItemForArray)object);
        } else if (object instanceof Double) {
            messagePacker.packDouble((Double)object);
        } else if (object instanceof BigInteger) {
            messagePacker.packBigInteger((BigInteger)object);
        } else if (object instanceof BigDecimal) {
            this.packBigDecimal((BigDecimal)object);
        } else if (object instanceof Boolean) {
            messagePacker.packBoolean((Boolean)object);
        } else if (object instanceof MessagePackExtensionType) {
            MessagePackExtensionType messagePackExtensionType = (MessagePackExtensionType)object;
            byte[] byArray = messagePackExtensionType.getData();
            messagePacker.packExtensionTypeHeader(messagePackExtensionType.getType(), byArray.length);
            messagePacker.writePayload(byArray);
        } else {
            messagePacker.flush();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MessagePackGenerator messagePackGenerator = new MessagePackGenerator(this.getFeatureMask(), this.getCodec(), byteArrayOutputStream, this.packerConfig, false);
            this.getCodec().writeValue(messagePackGenerator, object);
            this.output.write(byteArrayOutputStream.toByteArray());
        }
    }

    private void packBigDecimal(BigDecimal bigDecimal) throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        boolean bl = false;
        try {
            BigInteger bigInteger = bigDecimal.toBigIntegerExact();
            messagePacker.packBigInteger(bigInteger);
        }
        catch (ArithmeticException arithmeticException) {
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        if (bl) {
            double d = bigDecimal.doubleValue();
            if (!bigDecimal.stripTrailingZeros().toEngineeringString().equals(BigDecimal.valueOf(d).toEngineeringString())) {
                throw new IllegalArgumentException("MessagePack cannot serialize a BigDecimal that can't be represented as double. " + bigDecimal);
            }
            messagePacker.packDouble(d);
        }
    }

    private void packObject(StackItemForObject stackItemForObject) throws IOException {
        List<Object> list = stackItemForObject.getKeys();
        List<Object> list2 = stackItemForObject.getValues();
        MessagePacker messagePacker = this.getMessagePacker();
        messagePacker.packMapHeader(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.pack(list.get(i));
            this.pack(list2.get(i));
        }
    }

    private void packArray(StackItemForArray stackItemForArray) throws IOException {
        List<Object> list = stackItemForArray.getValues();
        MessagePacker messagePacker = this.getMessagePacker();
        messagePacker.packArrayHeader(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            this.pack(object);
        }
    }

    @Override
    public void writeFieldName(String string) throws IOException, JsonGenerationException {
        this.addKeyToStackTop(string);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
        if (serializableString instanceof MessagePackSerializedString) {
            this.addKeyToStackTop(((MessagePackSerializedString)serializableString).getRawValue());
        } else if (serializableString instanceof SerializedString) {
            this.addKeyToStackTop(serializableString.getValue());
        } else {
            System.out.println(serializableString.getClass());
            throw new IllegalArgumentException("Unsupported key: " + serializableString);
        }
    }

    @Override
    public void writeString(String string) throws IOException, JsonGenerationException {
        this.addValueToStackTop(string);
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(new String(cArray, n, n2));
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(new String(byArray, n, n2, DEFAULT_CHARSET));
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(new String(byArray, n, n2, DEFAULT_CHARSET));
    }

    @Override
    public void writeRaw(String string) throws IOException, JsonGenerationException {
        this.addValueToStackTop(string);
    }

    @Override
    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(string.substring(0, n2));
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(new String(cArray, n, n2));
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.addValueToStackTop(String.valueOf(c));
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(ByteBuffer.wrap(byArray, n, n2));
    }

    @Override
    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this.addValueToStackTop(n);
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this.addValueToStackTop(l);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        this.addValueToStackTop(bigInteger);
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this.addValueToStackTop(d);
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this.addValueToStackTop(Float.valueOf(f));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this.addValueToStackTop(bigDecimal);
    }

    @Override
    public void writeNumber(String string) throws IOException, JsonGenerationException, UnsupportedOperationException {
        throw new UnsupportedOperationException("writeNumber(String encodedValue) isn't supported yet");
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this.addValueToStackTop(bl);
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this.addValueToStackTop(null);
    }

    public void writeExtensionType(MessagePackExtensionType messagePackExtensionType) throws IOException {
        this.addValueToStackTop(messagePackExtensionType);
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                MessagePacker messagePacker = this.getMessagePacker();
                messagePacker.close();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.rootStackItem != null) {
            if (this.rootStackItem instanceof StackItemForObject) {
                this.packObject((StackItemForObject)this.rootStackItem);
            } else if (this.rootStackItem instanceof StackItemForArray) {
                this.packArray((StackItemForArray)this.rootStackItem);
            } else {
                throw new IllegalStateException("Unexpected rootStackItem: " + this.rootStackItem);
            }
            this.rootStackItem = null;
            this.flushMessagePacker();
        }
    }

    private void flushMessagePacker() throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        messagePacker.flush();
    }

    @Override
    protected void _releaseBuffers() {
    }

    @Override
    protected void _verifyValueWrite(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    private StackItem getStackTop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("The stack is empty");
        }
        return this.stack.getFirst();
    }

    private StackItemForObject getStackTopForObject() {
        StackItem stackItem = this.getStackTop();
        if (!(stackItem instanceof StackItemForObject)) {
            throw new IllegalStateException("The stack top should be Object: " + stackItem);
        }
        return (StackItemForObject)stackItem;
    }

    private StackItemForArray getStackTopForArray() {
        StackItem stackItem = this.getStackTop();
        if (!(stackItem instanceof StackItemForArray)) {
            throw new IllegalStateException("The stack top should be Array: " + stackItem);
        }
        return (StackItemForArray)stackItem;
    }

    private void addKeyToStackTop(Object object) {
        this.getStackTop().addKey(object);
    }

    private void addValueToStackTop(Object object) throws IOException {
        if (this.stack.isEmpty()) {
            this.pack(object);
            this.flushMessagePacker();
        } else {
            this.getStackTop().addValue(object);
        }
    }

    private void popStackAndStoreTheItemAsValue() throws IOException {
        StackItem stackItem = this.stack.pop();
        if (this.stack.size() > 0) {
            this.addValueToStackTop(stackItem);
        } else {
            if (this.rootStackItem != null) {
                throw new IllegalStateException("rootStackItem is not null");
            }
            this.rootStackItem = stackItem;
        }
    }

    private MessagePacker getMessagePacker() {
        return this.messagePacker;
    }

    private static class StackItemForArray
    extends StackItem {
        private StackItemForArray() {
        }

        @Override
        void addKey(Object object) {
            throw new IllegalStateException("This method shouldn't be called");
        }

        @Override
        List<Object> getKeys() {
            throw new IllegalStateException("This method shouldn't be called");
        }
    }

    private static class StackItemForObject
    extends StackItem {
        private StackItemForObject() {
        }

        @Override
        void addKey(Object object) {
            this.objectKeys.add(object);
        }

        @Override
        List<Object> getKeys() {
            return this.objectKeys;
        }
    }

    private static abstract class StackItem {
        protected List<Object> objectKeys = new ArrayList<Object>();
        protected List<Object> objectValues = new ArrayList<Object>();

        private StackItem() {
        }

        abstract void addKey(Object var1);

        void addValue(Object object) {
            this.objectValues.add(object);
        }

        abstract List<Object> getKeys();

        List<Object> getValues() {
            return this.objectValues;
        }
    }
}

