/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.komamitsu.fluency.sender.AckTokenSerDe;
import org.komamitsu.fluency.sender.MessagePackAckTokenSerDe;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.SenderErrorHandler;
import org.komamitsu.fluency.sender.failuredetect.FailureDetectStrategy;
import org.komamitsu.fluency.sender.failuredetect.FailureDetector;
import org.komamitsu.fluency.sender.failuredetect.PhiAccrualFailureDetectStrategy;
import org.komamitsu.fluency.sender.heartbeat.Heartbeater;
import org.komamitsu.fluency.util.ExecutorServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPSender
extends Sender {
    private static final Logger LOG = LoggerFactory.getLogger(TCPSender.class);
    private static final Charset CHARSET_FOR_ERRORLOG = Charset.forName("UTF-8");
    private final AtomicReference<SocketChannel> channel = new AtomicReference();
    private final byte[] optionBuffer = new byte[256];
    private final AckTokenSerDe ackTokenSerDe = new MessagePackAckTokenSerDe();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Config config;
    private final FailureDetector failureDetector;

    protected TCPSender(Config config) {
        super(config.getBaseConfig());
        this.config = config;
        FailureDetector failureDetector = null;
        if (config.getHeartbeaterConfig() != null) {
            try {
                failureDetector = new FailureDetector(config.getFailureDetectorStrategyConfig(), config.getHeartbeaterConfig(), config.getFailureDetectorConfig());
            }
            catch (IOException e) {
                LOG.warn("Failed to instantiate FailureDetector. Disabling it", e);
            }
        }
        this.failureDetector = failureDetector;
    }

    @Override
    public boolean isAvailable() {
        return this.failureDetector == null || this.failureDetector.isAvailable();
    }

    private SocketChannel getOrOpenChannel() throws IOException {
        if (this.channel.get() == null) {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.socket().connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), this.config.getConnectionTimeoutMilli());
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setSoTimeout(this.config.getReadTimeoutMilli());
            this.channel.set(socketChannel);
        }
        return this.channel.get();
    }

    private synchronized void sendBuffers(List<ByteBuffer> dataList) throws IOException {
        LOG.trace("send(): sender.host={}, sender.port={}", (Object)this.getHost(), (Object)this.getPort());
        this.getOrOpenChannel().write(dataList.toArray(new ByteBuffer[dataList.size()]));
    }

    private void propagateFailure(Throwable e) {
        if (this.failureDetector != null) {
            this.failureDetector.onFailure(e);
        }
    }

    @Override
    protected synchronized void sendInternal(List<ByteBuffer> dataList, byte[] ackToken) throws IOException {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        buffers.addAll(dataList);
        if (ackToken != null) {
            buffers.add(ByteBuffer.wrap(this.ackTokenSerDe.pack(ackToken)));
        }
        try {
            this.sendBuffers(buffers);
            if (ackToken == null) {
                return;
            }
            final ByteBuffer byteBuffer = ByteBuffer.wrap(this.optionBuffer);
            Future<Void> future = this.executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TCPSender.this.getOrOpenChannel().read(byteBuffer);
                    return null;
                }
            });
            try {
                future.get(this.config.getReadTimeoutMilli(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new IOException("InterruptedException occurred", e);
            }
            catch (ExecutionException e) {
                throw new IOException("ExecutionException occurred", e);
            }
            catch (TimeoutException e) {
                throw new SocketTimeoutException("Socket read timeout");
            }
            byte[] unpackedToken = this.ackTokenSerDe.unpack(this.optionBuffer);
            if (!Arrays.equals(ackToken, unpackedToken)) {
                throw new UnmatchedAckException("Ack tokens don't matched: expected=" + new String(ackToken, CHARSET_FOR_ERRORLOG) + ", got=" + new String(unpackedToken, CHARSET_FOR_ERRORLOG));
            }
        }
        catch (IOException e) {
            this.closeSocket();
            this.propagateFailure(e);
            throw e;
        }
    }

    private void closeSocket() throws IOException {
        SocketChannel socketChannel = this.channel.getAndSet(null);
        if (socketChannel != null) {
            socketChannel.close();
            this.channel.set(null);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.closeSocket();
        }
        finally {
            try {
                if (this.failureDetector != null) {
                    this.failureDetector.close();
                }
            }
            finally {
                ExecutorServiceUtils.finishExecutorService(this.executorService);
            }
        }
    }

    public String getHost() {
        return this.config.getHost();
    }

    public int getPort() {
        return this.config.getPort();
    }

    public int getConnectionTimeoutMilli() {
        return this.config.getConnectionTimeoutMilli();
    }

    public int getReadTimeoutMilli() {
        return this.config.getReadTimeoutMilli();
    }

    public FailureDetector getFailureDetector() {
        return this.failureDetector;
    }

    public String toString() {
        return "TCPSender{channel=" + this.channel + ", config=" + this.config + ", failureDetector=" + this.failureDetector + "} " + super.toString();
    }

    public static class Config
    implements Sender.Instantiator {
        private final Sender.Config baseConfig = new Sender.Config();
        private String host = "127.0.0.1";
        private int port = 24224;
        private int connectionTimeoutMilli = 5000;
        private int readTimeoutMilli = 5000;
        private Heartbeater.Instantiator heartbeaterConfig;
        private FailureDetector.Config failureDetectorConfig = new FailureDetector.Config();
        private FailureDetectStrategy.Instantiator failureDetectorStrategyConfig = new PhiAccrualFailureDetectStrategy.Config();

        public Sender.Config getBaseConfig() {
            return this.baseConfig;
        }

        public SenderErrorHandler getSenderErrorHandler() {
            return this.baseConfig.getSenderErrorHandler();
        }

        public Config setSenderErrorHandler(SenderErrorHandler senderErrorHandler) {
            this.baseConfig.setSenderErrorHandler(senderErrorHandler);
            return this;
        }

        public String getHost() {
            return this.host;
        }

        public Config setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Config setPort(int port) {
            this.port = port;
            return this;
        }

        public int getConnectionTimeoutMilli() {
            return this.connectionTimeoutMilli;
        }

        public Config setConnectionTimeoutMilli(int connectionTimeoutMilli) {
            this.connectionTimeoutMilli = connectionTimeoutMilli;
            return this;
        }

        public int getReadTimeoutMilli() {
            return this.readTimeoutMilli;
        }

        public Config setReadTimeoutMilli(int readTimeoutMilli) {
            this.readTimeoutMilli = readTimeoutMilli;
            return this;
        }

        public Heartbeater.Instantiator getHeartbeaterConfig() {
            return this.heartbeaterConfig;
        }

        public Config setHeartbeaterConfig(Heartbeater.Instantiator heartbeaterConfig) {
            this.heartbeaterConfig = heartbeaterConfig;
            return this;
        }

        public FailureDetector.Config getFailureDetectorConfig() {
            return this.failureDetectorConfig;
        }

        public Config setFailureDetectorConfig(FailureDetector.Config failureDetectorConfig) {
            this.failureDetectorConfig = failureDetectorConfig;
            return this;
        }

        public FailureDetectStrategy.Instantiator getFailureDetectorStrategyConfig() {
            return this.failureDetectorStrategyConfig;
        }

        public Config setFailureDetectorStrategyConfig(FailureDetectStrategy.Instantiator failureDetectorStrategyConfig) {
            this.failureDetectorStrategyConfig = failureDetectorStrategyConfig;
            return this;
        }

        @Override
        public TCPSender createInstance() {
            return new TCPSender(this);
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + ", host='" + this.host + '\'' + ", port=" + this.port + ", connectionTimeoutMilli=" + this.connectionTimeoutMilli + ", readTimeoutMilli=" + this.readTimeoutMilli + ", heartbeaterConfig=" + this.heartbeaterConfig + ", failureDetectorConfig=" + this.failureDetectorConfig + ", failureDetectorStrategyConfig=" + this.failureDetectorStrategyConfig + '}';
        }
    }

    public static class UnmatchedAckException
    extends IOException {
        public UnmatchedAckException(String message) {
            super(message);
        }
    }
}

