/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.retry;

import org.komamitsu.fluency.sender.retry.RetryStrategy;

public class ExponentialBackOffRetryStrategy
extends RetryStrategy {
    private final Config config;

    protected ExponentialBackOffRetryStrategy(Config config) {
        super(config.getBaseConfig());
        this.config = config;
    }

    @Override
    public int getNextIntervalMillis(int retryCount) {
        int interval = this.config.getBaseIntervalMillis() * (int)Math.pow(2.0, retryCount);
        if (interval > this.config.getMaxIntervalMillis()) {
            return this.config.getMaxIntervalMillis();
        }
        return interval;
    }

    public int getBaseIntervalMillis() {
        return this.config.getBaseIntervalMillis();
    }

    public int getMaxIntervalMillis() {
        return this.config.getMaxIntervalMillis();
    }

    @Override
    public String toString() {
        return "ExponentialBackOffRetryStrategy{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    implements RetryStrategy.Instantiator {
        private RetryStrategy.Config baseConfig = new RetryStrategy.Config();
        private int baseIntervalMillis = 400;
        private int maxIntervalMillis = 30000;

        public RetryStrategy.Config getBaseConfig() {
            return this.baseConfig;
        }

        public int getMaxRetryCount() {
            return this.baseConfig.getMaxRetryCount();
        }

        public Config setMaxRetryCount(int maxRetryCount) {
            this.baseConfig.setMaxRetryCount(maxRetryCount);
            return this;
        }

        public int getBaseIntervalMillis() {
            return this.baseIntervalMillis;
        }

        public Config setBaseIntervalMillis(int baseIntervalMillis) {
            this.baseIntervalMillis = baseIntervalMillis;
            return this;
        }

        public int getMaxIntervalMillis() {
            return this.maxIntervalMillis;
        }

        public Config setMaxIntervalMillis(int maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
            return this;
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + ", baseIntervalMillis=" + this.baseIntervalMillis + ", maxIntervalMillis=" + this.maxIntervalMillis + '}';
        }

        @Override
        public ExponentialBackOffRetryStrategy createInstance() {
            return new ExponentialBackOffRetryStrategy(this);
        }
    }
}

