/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.komamitsu.fluency.BufferFullException;
import org.komamitsu.fluency.EventTime;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.buffer.PackedForwardBuffer;
import org.komamitsu.fluency.flusher.AsyncFlusher;
import org.komamitsu.fluency.flusher.Flusher;
import org.komamitsu.fluency.sender.MultiSender;
import org.komamitsu.fluency.sender.RetryableSender;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.SenderErrorHandler;
import org.komamitsu.fluency.sender.TCPSender;
import org.komamitsu.fluency.sender.heartbeat.TCPHeartbeater;
import org.komamitsu.fluency.sender.retry.ExponentialBackOffRetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fluency
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Fluency.class);
    private final Buffer buffer;
    private final Flusher flusher;
    private final Emitter emitter = new Emitter();

    public static Fluency defaultFluency(String host, int port, Config config) throws IOException {
        return Fluency.buildDefaultFluency(new TCPSender.Config().setHost(host).setPort(port), config);
    }

    private static Fluency buildDefaultFluency(Sender.Instantiator baseSenderConfig, Config config) {
        PackedForwardBuffer.Config bufferConfig = new PackedForwardBuffer.Config();
        ExponentialBackOffRetryStrategy.Config retryStrategyConfig = new ExponentialBackOffRetryStrategy.Config();
        AsyncFlusher.Config flusherConfig = new AsyncFlusher.Config();
        if (config != null) {
            if (config.getMaxBufferSize() != null) {
                bufferConfig.setMaxBufferSize(config.getMaxBufferSize());
            }
            if (config.getBufferChunkInitialSize() != null) {
                bufferConfig.setChunkInitialSize(config.getBufferChunkInitialSize());
            }
            if (config.getBufferChunkRetentionSize() != null) {
                bufferConfig.setChunkRetentionSize(config.getBufferChunkRetentionSize());
            }
            bufferConfig.setAckResponseMode(config.isAckResponseMode());
            if (config.getFileBackupDir() != null) {
                bufferConfig.setFileBackupDir(config.getFileBackupDir());
            }
            if (config.getJvmHeapBufferMode() != null) {
                bufferConfig.setJvmHeapBufferMode(config.jvmHeapBufferMode);
            }
            if (config.getFlushIntervalMillis() != null) {
                flusherConfig.setFlushIntervalMillis(config.getFlushIntervalMillis());
            }
            if (config.getWaitUntilBufferFlushed() != null) {
                flusherConfig.setWaitUntilBufferFlushed(config.getWaitUntilBufferFlushed());
            }
            if (config.getWaitUntilFlusherTerminated() != null) {
                flusherConfig.setWaitUntilTerminated(config.getWaitUntilFlusherTerminated());
            }
            if (config.getSenderMaxRetryCount() != null) {
                retryStrategyConfig.setMaxRetryCount(config.getSenderMaxRetryCount());
            }
        }
        RetryableSender.Config senderConfig = new RetryableSender.Config(baseSenderConfig).setRetryStrategyConfig(retryStrategyConfig);
        if (config != null && config.getSenderErrorHandler() != null) {
            senderConfig.setSenderErrorHandler(config.getSenderErrorHandler());
        }
        RetryableSender retryableSender = senderConfig.createInstance();
        return new Builder(retryableSender).setBufferConfig(bufferConfig).setFlusherConfig(flusherConfig).build();
    }

    public static Fluency defaultFluency(int port, Config config) throws IOException {
        return Fluency.buildDefaultFluency(new TCPSender.Config().setPort(port), config);
    }

    public static Fluency defaultFluency(Config config) throws IOException {
        return Fluency.buildDefaultFluency(new TCPSender.Config(), config);
    }

    public static Fluency defaultFluency(List<InetSocketAddress> servers, Config config) throws IOException {
        ArrayList<Sender.Instantiator> tcpSenderConfigs = new ArrayList<Sender.Instantiator>();
        for (InetSocketAddress server : servers) {
            tcpSenderConfigs.add(new TCPSender.Config().setHost(server.getHostName()).setPort(server.getPort()).setHeartbeaterConfig(new TCPHeartbeater.Config().setHost(server.getHostName()).setPort(server.getPort())));
        }
        return Fluency.buildDefaultFluency(new MultiSender.Config(tcpSenderConfigs), config);
    }

    public static Fluency defaultFluency(String host, int port) throws IOException {
        return Fluency.defaultFluency(host, port, null);
    }

    public static Fluency defaultFluency(int port) throws IOException {
        return Fluency.defaultFluency(port, null);
    }

    public static Fluency defaultFluency() throws IOException {
        return Fluency.buildDefaultFluency(new TCPSender.Config(), null);
    }

    public static Fluency defaultFluency(List<InetSocketAddress> servers) throws IOException {
        return Fluency.defaultFluency(servers, null);
    }

    private Fluency(Buffer buffer, Flusher flusher) {
        this.buffer = buffer;
        this.flusher = flusher;
    }

    public void emit(final String tag, final long timestamp, final Map<String, Object> data) throws IOException {
        this.emitter.emit(new Append(){

            @Override
            public void append() throws IOException {
                Fluency.this.buffer.append(tag, timestamp, (Map<String, Object>)data);
            }
        });
    }

    public void emit(String tag, Map<String, Object> data) throws IOException {
        this.emit(tag, System.currentTimeMillis() / 1000L, data);
    }

    public void emit(final String tag, final EventTime eventTime, final Map<String, Object> data) throws IOException {
        this.emitter.emit(new Append(){

            @Override
            public void append() throws IOException {
                Fluency.this.buffer.append(tag, eventTime, (Map<String, Object>)data);
            }
        });
    }

    public void emit(final String tag, final long timestamp, final byte[] mapValue, final int offset, final int len) throws IOException {
        this.emitter.emit(new Append(){

            @Override
            public void append() throws IOException {
                Fluency.this.buffer.appendMessagePackMapValue(tag, timestamp, mapValue, offset, len);
            }
        });
    }

    public void emit(String tag, byte[] mapValue, int offset, int len) throws IOException {
        this.emit(tag, System.currentTimeMillis() / 1000L, mapValue, offset, len);
    }

    public void emit(final String tag, final EventTime eventTime, final byte[] mapValue, final int offset, final int len) throws IOException {
        this.emitter.emit(new Append(){

            @Override
            public void append() throws IOException {
                Fluency.this.buffer.appendMessagePackMapValue(tag, eventTime, mapValue, offset, len);
            }
        });
    }

    public void emit(final String tag, final long timestamp, final ByteBuffer mapValue) throws IOException {
        this.emitter.emit(new Append(){

            @Override
            public void append() throws IOException {
                Fluency.this.buffer.appendMessagePackMapValue(tag, timestamp, mapValue);
            }
        });
    }

    public void emit(String tag, ByteBuffer mapValue) throws IOException {
        this.emit(tag, System.currentTimeMillis() / 1000L, mapValue);
    }

    public void emit(final String tag, final EventTime eventTime, final ByteBuffer mapValue) throws IOException {
        this.emitter.emit(new Append(){

            @Override
            public void append() throws IOException {
                Fluency.this.buffer.appendMessagePackMapValue(tag, eventTime, mapValue);
            }
        });
    }

    @Override
    public void flush() throws IOException {
        this.flusher.flush();
    }

    @Override
    public void close() throws IOException {
        this.flusher.close();
    }

    public void clearBackupFiles() {
        this.buffer.clearBackupFiles();
    }

    public long getAllocatedBufferSize() {
        return this.buffer.getAllocatedSize();
    }

    public long getBufferedDataSize() {
        return this.buffer.getBufferedDataSize();
    }

    public boolean isTerminated() {
        return this.flusher.isTerminated();
    }

    public boolean waitUntilAllBufferFlushed(int maxWaitSeconds) throws InterruptedException {
        int intervalMilli = 500;
        for (int i = 0; i < maxWaitSeconds * (1000 / intervalMilli); ++i) {
            long bufferedDataSize = this.getBufferedDataSize();
            LOG.info("Waiting for flushing all buffer: {}", (Object)bufferedDataSize);
            if (this.getBufferedDataSize() == 0L) {
                return true;
            }
            TimeUnit.MILLISECONDS.sleep(intervalMilli);
        }
        LOG.warn("Buffered data still remains: {}", (Object)this.getBufferedDataSize());
        return false;
    }

    public boolean waitUntilFlusherTerminated(int maxWaitSeconds) throws InterruptedException {
        int intervalMilli = 500;
        for (int i = 0; i < maxWaitSeconds * (1000 / intervalMilli); ++i) {
            boolean terminated = this.isTerminated();
            LOG.info("Waiting until the flusher is terminated: {}", (Object)terminated);
            if (terminated) {
                return true;
            }
            TimeUnit.MILLISECONDS.sleep(intervalMilli);
        }
        LOG.warn("The flusher isn't terminated");
        return false;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Flusher getFlusher() {
        return this.flusher;
    }

    public String toString() {
        return "Fluency{buffer=" + this.buffer + ", flusher=" + this.flusher + '}';
    }

    public static class Config {
        private Long maxBufferSize;
        private Integer bufferChunkInitialSize;
        private Integer bufferChunkRetentionSize;
        private Integer flushIntervalMillis;
        private Integer senderMaxRetryCount;
        private boolean ackResponseMode;
        private String fileBackupDir;
        private Integer waitUntilBufferFlushed;
        private Integer waitUntilFlusherTerminated;
        private Boolean jvmHeapBufferMode;
        private SenderErrorHandler senderErrorHandler;

        public Long getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public Config setMaxBufferSize(Long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public Integer getBufferChunkInitialSize() {
            return this.bufferChunkInitialSize;
        }

        public Config setBufferChunkInitialSize(Integer bufferChunkInitialSize) {
            this.bufferChunkInitialSize = bufferChunkInitialSize;
            return this;
        }

        public Integer getBufferChunkRetentionSize() {
            return this.bufferChunkRetentionSize;
        }

        public Config setBufferChunkRetentionSize(Integer bufferChunkRetentionSize) {
            this.bufferChunkRetentionSize = bufferChunkRetentionSize;
            return this;
        }

        public Integer getFlushIntervalMillis() {
            return this.flushIntervalMillis;
        }

        public Config setFlushIntervalMillis(Integer flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
            return this;
        }

        public Integer getSenderMaxRetryCount() {
            return this.senderMaxRetryCount;
        }

        public Config setSenderMaxRetryCount(Integer senderMaxRetryCount) {
            this.senderMaxRetryCount = senderMaxRetryCount;
            return this;
        }

        public boolean isAckResponseMode() {
            return this.ackResponseMode;
        }

        public Config setAckResponseMode(boolean ackResponseMode) {
            this.ackResponseMode = ackResponseMode;
            return this;
        }

        public String getFileBackupDir() {
            return this.fileBackupDir;
        }

        public Config setFileBackupDir(String fileBackupDir) {
            this.fileBackupDir = fileBackupDir;
            return this;
        }

        public Integer getWaitUntilBufferFlushed() {
            return this.waitUntilBufferFlushed;
        }

        public Config setWaitUntilBufferFlushed(Integer wait) {
            this.waitUntilBufferFlushed = wait;
            return this;
        }

        public Integer getWaitUntilFlusherTerminated() {
            return this.waitUntilFlusherTerminated;
        }

        public Config setWaitUntilFlusherTerminated(Integer wait) {
            this.waitUntilFlusherTerminated = wait;
            return this;
        }

        public Boolean getJvmHeapBufferMode() {
            return this.jvmHeapBufferMode;
        }

        public Config setJvmHeapBufferMode(Boolean jvmHeapBufferMode) {
            this.jvmHeapBufferMode = jvmHeapBufferMode;
            return this;
        }

        public SenderErrorHandler getSenderErrorHandler() {
            return this.senderErrorHandler;
        }

        public Config setSenderErrorHandler(SenderErrorHandler senderErrorHandler) {
            this.senderErrorHandler = senderErrorHandler;
            return this;
        }

        public String toString() {
            return "Config{maxBufferSize=" + this.maxBufferSize + ", bufferChunkInitialSize=" + this.bufferChunkInitialSize + ", bufferChunkRetentionSize=" + this.bufferChunkRetentionSize + ", flushIntervalMillis=" + this.flushIntervalMillis + ", senderMaxRetryCount=" + this.senderMaxRetryCount + ", ackResponseMode=" + this.ackResponseMode + ", fileBackupDir='" + this.fileBackupDir + '\'' + ", waitUntilBufferFlushed=" + this.waitUntilBufferFlushed + ", waitUntilFlusherTerminated=" + this.waitUntilFlusherTerminated + ", jvmHeapBufferMode=" + this.jvmHeapBufferMode + ", senderErrorHandler=" + this.senderErrorHandler + '}';
        }
    }

    public static class Builder {
        private final Sender sender;
        private Buffer.Instantiator bufferConfig;
        private Flusher.Instantiator flusherConfig;

        public Builder(Sender sender) {
            this.sender = sender;
        }

        public Builder setBufferConfig(Buffer.Instantiator bufferConfig) {
            this.bufferConfig = bufferConfig;
            return this;
        }

        public Builder setFlusherConfig(Flusher.Instantiator flusherConfig) {
            this.flusherConfig = flusherConfig;
            return this;
        }

        public Fluency build() {
            Buffer.Instantiator bufferConfig = this.bufferConfig != null ? this.bufferConfig : new PackedForwardBuffer.Config();
            Buffer buffer = bufferConfig.createInstance();
            Flusher.Instantiator flusherConfig = this.flusherConfig != null ? this.flusherConfig : new AsyncFlusher.Config();
            Flusher flusher = flusherConfig.createInstance(buffer, this.sender);
            return new Fluency(buffer, flusher);
        }
    }

    private class Emitter {
        private Emitter() {
        }

        void emit(Append appender) throws IOException {
            try {
                appender.append();
                Fluency.this.flusher.onUpdate();
            }
            catch (BufferFullException e) {
                LOG.error("emit() failed due to buffer full. Flushing buffer. Please try again...");
                Fluency.this.flusher.flush();
                throw e;
            }
        }
    }

    private static interface Append {
        public void append() throws IOException;
    }
}

