/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.SenderErrorHandler;
import org.komamitsu.fluency.sender.retry.ExponentialBackOffRetryStrategy;
import org.komamitsu.fluency.sender.retry.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableSender
extends Sender {
    private static final Logger LOG = LoggerFactory.getLogger(RetryableSender.class);
    private final Sender baseSender;
    private RetryStrategy retryStrategy;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    @Override
    public void close() throws IOException {
        this.baseSender.close();
        this.isClosed.set(true);
    }

    protected RetryableSender(Config config) {
        super(config.getBaseConfig());
        this.baseSender = config.getBaseSenderConfig().createInstance();
        this.retryStrategy = config.getRetryStrategyConfig().createInstance();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    protected synchronized void sendInternal(List<ByteBuffer> dataList, byte[] ackToken) throws IOException {
        IOException firstException = null;
        int retry = 0;
        while (!this.retryStrategy.isRetriedOver(retry)) {
            if (this.isClosed.get()) {
                throw new RetryOverException("This sender is already closed", firstException);
            }
            try {
                if (ackToken == null) {
                    this.baseSender.send(dataList);
                } else {
                    this.baseSender.sendWithAck(dataList, ackToken);
                }
                return;
            }
            catch (IOException e) {
                firstException = e;
                LOG.warn("Sender failed to send data. sender=" + this + ", retry=" + retry, (Throwable)e);
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryStrategy.getNextIntervalMillis(retry));
                }
                catch (InterruptedException e2) {
                    LOG.debug("Interrupted while waiting", (Throwable)e2);
                    Thread.currentThread().interrupt();
                }
                ++retry;
            }
        }
        throw new RetryOverException("Sending data was retried over", firstException);
    }

    public Sender getBaseSender() {
        return this.baseSender;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public String toString() {
        return "RetryableSender{baseSender=" + this.baseSender + ", retryStrategy=" + this.retryStrategy + ", isClosed=" + this.isClosed + "} " + super.toString();
    }

    public static class Config
    implements Sender.Instantiator {
        private final Sender.Config baseConfig = new Sender.Config();
        private RetryStrategy.Instantiator retryStrategyConfig = new ExponentialBackOffRetryStrategy.Config();
        private final Sender.Instantiator baseSenderConfig;

        public Sender.Config getBaseConfig() {
            return this.baseConfig;
        }

        public SenderErrorHandler getSenderErrorHandler() {
            return this.baseConfig.getSenderErrorHandler();
        }

        public Config setSenderErrorHandler(SenderErrorHandler senderErrorHandler) {
            this.baseConfig.setSenderErrorHandler(senderErrorHandler);
            return this;
        }

        public Config(Sender.Instantiator baseSenderConfig) {
            this.baseSenderConfig = baseSenderConfig;
        }

        public Sender.Instantiator getBaseSenderConfig() {
            return this.baseSenderConfig;
        }

        public RetryStrategy.Instantiator getRetryStrategyConfig() {
            return this.retryStrategyConfig;
        }

        public Config setRetryStrategyConfig(RetryStrategy.Instantiator retryStrategyConfig) {
            this.retryStrategyConfig = retryStrategyConfig;
            return this;
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + ", retryStrategyConfig=" + this.retryStrategyConfig + ", baseSenderConfig=" + this.baseSenderConfig + '}';
        }

        @Override
        public RetryableSender createInstance() {
            return new RetryableSender(this);
        }
    }

    public static class RetryOverException
    extends IOException {
        public RetryOverException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

