/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.heartbeat;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.komamitsu.fluency.flusher.AsyncFlusher;
import org.komamitsu.fluency.util.ExecutorServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Heartbeater
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncFlusher.class);
    private final Config config;
    private final ScheduledExecutorService executorService;
    private final AtomicReference<Callback> callback = new AtomicReference();

    protected Heartbeater(Config config) {
        this.config = config;
        this.executorService = Executors.newScheduledThreadPool(1);
    }

    public void start() {
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Heartbeater.this.ping();
            }
        }, this.config.getIntervalMillis(), this.config.getIntervalMillis(), TimeUnit.MILLISECONDS);
    }

    protected abstract void invoke() throws IOException;

    protected void ping() {
        block2: {
            try {
                this.invoke();
            }
            catch (Throwable e) {
                LOG.warn("ping(): failed, config=" + this.config);
                Callback callback = this.callback.get();
                if (callback == null) break block2;
                callback.onFailure(e);
            }
        }
    }

    protected void pong() {
        Callback callback = this.callback.get();
        if (callback != null) {
            callback.onHeartbeat();
        }
    }

    public void setCallback(Callback callback) {
        this.callback.set(callback);
    }

    @Override
    public void close() throws IOException {
        ExecutorServiceUtils.finishExecutorService(this.executorService);
    }

    public String getHost() {
        return this.config.getHost();
    }

    public int getPort() {
        return this.config.getPort();
    }

    public int getIntervalMillis() {
        return this.config.getIntervalMillis();
    }

    public String toString() {
        return "Heartbeater{config=" + this.config + '}';
    }

    public static interface Instantiator {
        public Heartbeater createInstance() throws IOException;
    }

    public static class Config {
        private String host = "127.0.0.1";
        private int port = 24224;
        private int intervalMillis = 1000;

        public String getHost() {
            return this.host;
        }

        public Config setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Config setPort(int port) {
            this.port = port;
            return this;
        }

        public int getIntervalMillis() {
            return this.intervalMillis;
        }

        public Config setIntervalMillis(int intervalMillis) {
            this.intervalMillis = intervalMillis;
            return this;
        }

        public String toString() {
            return "Config{host='" + this.host + '\'' + ", port=" + this.port + ", intervalMillis=" + this.intervalMillis + '}';
        }
    }

    public static interface Callback {
        public void onHeartbeat();

        public void onFailure(Throwable var1);
    }
}

