/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.retry;

import org.komamitsu.fluency.sender.retry.RetryStrategy;

public class ConstantRetryStrategy
extends RetryStrategy {
    private final Config config;

    protected ConstantRetryStrategy(Config config) {
        super(config.getBaseConfig());
        this.config = config;
    }

    @Override
    public int getNextIntervalMillis(int retryCount) {
        return this.config.getRetryIntervalMillis();
    }

    @Override
    public String toString() {
        return "ConstantRetryStrategy{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    implements RetryStrategy.Instantiator {
        private RetryStrategy.Config baseConfig = new RetryStrategy.Config();
        private int retryIntervalMillis = 2000;

        public RetryStrategy.Config getBaseConfig() {
            return this.baseConfig;
        }

        public int getMaxRetryCount() {
            return this.baseConfig.getMaxRetryCount();
        }

        public Config setMaxRetryCount(int maxRetryCount) {
            this.baseConfig.setMaxRetryCount(maxRetryCount);
            return this;
        }

        public int getRetryIntervalMillis() {
            return this.retryIntervalMillis;
        }

        public Config setRetryIntervalMillis(int retryIntervalMillis) {
            this.retryIntervalMillis = retryIntervalMillis;
            return this;
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + ", retryIntervalMillis=" + this.retryIntervalMillis + '}';
        }

        @Override
        public ConstantRetryStrategy createInstance() {
            return new ConstantRetryStrategy(this);
        }
    }
}

