/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.sender.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Flusher
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Flusher.class);
    private final AtomicBoolean isTerminated = new AtomicBoolean();
    protected final Buffer buffer;
    protected final Sender sender;
    private final Config config;

    protected Flusher(Buffer buffer, Sender sender, Config config) {
        this.buffer = buffer;
        this.sender = sender;
        this.config = config;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    protected abstract void flushInternal(boolean var1) throws IOException;

    protected abstract void beforeClosingBuffer() throws IOException;

    public void onUpdate() throws IOException {
        this.flushInternal(false);
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void close() throws IOException {
        this.beforeClosingBuffer();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Void> future = executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Flusher.this.closeBuffer();
                Flusher.this.isTerminated.set(true);
                return null;
            }
        });
        try {
            future.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted", e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.warn("closeBuffer() failed", e);
        }
        catch (TimeoutException e) {
            LOG.warn("closeBuffer() timed out", e);
        }
        finally {
            try {
                executorService.shutdown();
            }
            finally {
                try {
                    this.sender.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close the sender", e);
                }
            }
        }
        catch (Exception e) {
            try {
                LOG.error("Failed to call beforeClosingBuffer()", e);
            }
            catch (Throwable throwable) {
                ExecutorService executorService2 = Executors.newSingleThreadExecutor();
                Future<Void> future2 = executorService2.submit(new /* invalid duplicate definition of identical inner class */);
                try {
                    future2.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e2) {
                    LOG.warn("Interrupted", e2);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e3) {
                    LOG.warn("closeBuffer() failed", e3);
                }
                catch (TimeoutException e4) {
                    LOG.warn("closeBuffer() timed out", e4);
                }
                finally {
                    try {
                        executorService2.shutdown();
                    }
                    finally {
                        try {
                            this.sender.close();
                        }
                        catch (Exception e5) {
                            LOG.error("Failed to close the sender", e5);
                        }
                    }
                }
                throw throwable;
            }
            executorService = Executors.newSingleThreadExecutor();
            future = executorService.submit(new /* invalid duplicate definition of identical inner class */);
            try {
                future.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e6) {
                LOG.warn("Interrupted", e6);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e7) {
                LOG.warn("closeBuffer() failed", e7);
            }
            catch (TimeoutException e8) {
                LOG.warn("closeBuffer() timed out", e8);
            }
            finally {
                try {
                    executorService.shutdown();
                }
                finally {
                    try {
                        this.sender.close();
                    }
                    catch (Exception e9) {
                        LOG.error("Failed to close the sender", e9);
                    }
                }
            }
        }
    }

    public boolean isTerminated() {
        return this.isTerminated.get();
    }

    private void closeBuffer() {
        LOG.trace("closeBuffer(): closing buffer");
        this.buffer.close();
    }

    public Sender getSender() {
        return this.sender;
    }

    public int getFlushIntervalMillis() {
        return this.config.getFlushIntervalMillis();
    }

    public int getWaitUntilBufferFlushed() {
        return this.config.getWaitUntilBufferFlushed();
    }

    public int getWaitUntilTerminated() {
        return this.config.getWaitUntilTerminated();
    }

    public String toString() {
        return "Flusher{isTerminated=" + this.isTerminated + ", buffer=" + this.buffer + ", sender=" + this.sender + ", config=" + this.config + '}';
    }

    public static interface Instantiator {
        public Flusher createInstance(Buffer var1, Sender var2);
    }

    public static class Config {
        private int flushIntervalMillis = 600;
        private int waitUntilBufferFlushed = 60;
        private int waitUntilTerminated = 60;

        public int getFlushIntervalMillis() {
            return this.flushIntervalMillis;
        }

        public Config setFlushIntervalMillis(int flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
            return this;
        }

        public int getWaitUntilBufferFlushed() {
            return this.waitUntilBufferFlushed;
        }

        public Config setWaitUntilBufferFlushed(int waitUntilBufferFlushed) {
            this.waitUntilBufferFlushed = waitUntilBufferFlushed;
            return this;
        }

        public int getWaitUntilTerminated() {
            return this.waitUntilTerminated;
        }

        public Config setWaitUntilTerminated(int waitUntilTerminated) {
            this.waitUntilTerminated = waitUntilTerminated;
            return this;
        }

        public String toString() {
            return "Config{flushIntervalMillis=" + this.flushIntervalMillis + ", waitUntilBufferFlushed=" + this.waitUntilBufferFlushed + ", waitUntilTerminated=" + this.waitUntilTerminated + '}';
        }
    }
}

