/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.SenderErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSender
extends Sender {
    private static final Logger LOG = LoggerFactory.getLogger(MultiSender.class);
    private final List<Sender> senders = new ArrayList<Sender>();

    protected MultiSender(Config config) {
        super(config.getBaseConfig());
        for (Sender.Instantiator senderConfig : config.getSenderConfigs()) {
            this.senders.add(senderConfig.createInstance());
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    protected synchronized void sendInternal(List<ByteBuffer> buffers, byte[] ackToken) throws AllNodesUnavailableException {
        for (Sender sender : this.senders) {
            boolean isAvailable = sender.isAvailable();
            LOG.trace("send(): sender={}, isAvailable={}", (Object)sender, (Object)isAvailable);
            if (!isAvailable) continue;
            try {
                if (ackToken == null) {
                    sender.send(buffers);
                } else {
                    sender.sendWithAck(buffers, ackToken);
                }
                return;
            }
            catch (IOException e) {
                LOG.error("Failed to send: sender=" + sender + ". Trying to use next sender...", e);
            }
        }
        throw new AllNodesUnavailableException("All nodes are unavailable");
    }

    @Override
    public void close() throws IOException {
        IOException firstException = null;
        for (Sender sender : this.senders) {
            try {
                sender.close();
            }
            catch (IOException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public List<Sender> getSenders() {
        return Collections.unmodifiableList(this.senders);
    }

    public String toString() {
        return "MultiSender{senders=" + this.senders + "} " + super.toString();
    }

    public static class Config
    implements Sender.Instantiator {
        private final Sender.Config baseConfig = new Sender.Config();
        private final List<Sender.Instantiator> senderConfigs;

        public Sender.Config getBaseConfig() {
            return this.baseConfig;
        }

        public SenderErrorHandler getSenderErrorHandler() {
            return this.baseConfig.getSenderErrorHandler();
        }

        public Config setSenderErrorHandler(SenderErrorHandler senderErrorHandler) {
            this.baseConfig.setSenderErrorHandler(senderErrorHandler);
            return this;
        }

        public Config(List<Sender.Instantiator> senderConfigs) {
            this.senderConfigs = senderConfigs;
        }

        public List<Sender.Instantiator> getSenderConfigs() {
            return this.senderConfigs;
        }

        public String toString() {
            return "Config{senderConfigs=" + this.senderConfigs + "} " + super.toString();
        }

        @Override
        public MultiSender createInstance() {
            return new MultiSender(this);
        }
    }

    public static class AllNodesUnavailableException
    extends IOException {
        public AllNodesUnavailableException(String s) {
            super(s);
        }
    }
}

