/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.heartbeat;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.komamitsu.fluency.sender.heartbeat.Heartbeater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPHeartbeater
extends Heartbeater {
    private static final Logger LOG = LoggerFactory.getLogger(UDPHeartbeater.class);
    private final SocketAddress socketAddress;

    protected UDPHeartbeater(Config config) throws IOException {
        super(config.getBaseConfig());
        this.socketAddress = new InetSocketAddress(config.getHost(), config.getPort());
    }

    @Override
    protected void invoke() throws IOException {
        DatagramChannel datagramChannel = null;
        try {
            datagramChannel = DatagramChannel.open();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            datagramChannel.send(byteBuffer, this.socketAddress);
            datagramChannel.receive(byteBuffer);
            this.pong();
        }
        finally {
            if (datagramChannel != null) {
                datagramChannel.close();
            }
        }
    }

    @Override
    public String toString() {
        return "UDPHeartbeater{socketAddress=" + this.socketAddress + "} " + super.toString();
    }

    public static class Config
    implements Heartbeater.Instantiator {
        private final Heartbeater.Config baseConfig = new Heartbeater.Config();

        public Heartbeater.Config getBaseConfig() {
            return this.baseConfig;
        }

        public String getHost() {
            return this.baseConfig.getHost();
        }

        public int getPort() {
            return this.baseConfig.getPort();
        }

        public Config setIntervalMillis(int intervalMillis) {
            this.baseConfig.setIntervalMillis(intervalMillis);
            return this;
        }

        public int getIntervalMillis() {
            return this.baseConfig.getIntervalMillis();
        }

        public Config setHost(String host) {
            this.baseConfig.setHost(host);
            return this;
        }

        public Config setPort(int port) {
            this.baseConfig.setPort(port);
            return this;
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + '}';
        }

        @Override
        public UDPHeartbeater createInstance() throws IOException {
            return new UDPHeartbeater(this);
        }
    }
}

