/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocket;
import org.komamitsu.fluency.sender.NetworkSender;
import org.komamitsu.fluency.sender.SSLSocketBuilder;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.SenderErrorHandler;
import org.komamitsu.fluency.sender.failuredetect.FailureDetectStrategy;
import org.komamitsu.fluency.sender.failuredetect.FailureDetector;
import org.komamitsu.fluency.sender.heartbeat.Heartbeater;

public class SSLSender
extends NetworkSender<SSLSocket> {
    private final AtomicReference<SSLSocket> socket = new AtomicReference();
    private final SSLSocketBuilder socketBuilder;
    private final Config config;

    public SSLSender(Config config) {
        super(config.baseConfig);
        this.socketBuilder = new SSLSocketBuilder(config.getHost(), config.getPort(), config.getConnectionTimeoutMilli(), config.getReadTimeoutMilli());
        this.config = config;
    }

    @Override
    protected SSLSocket getOrCreateSocketInternal() throws IOException {
        if (this.socket.get() == null) {
            this.socket.set(this.socketBuilder.build());
        }
        return this.socket.get();
    }

    @Override
    protected void sendBuffers(SSLSocket sslSocket, List<ByteBuffer> buffers) throws IOException {
        for (ByteBuffer buffer : buffers) {
            OutputStream outputStream = sslSocket.getOutputStream();
            if (buffer.isDirect()) {
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                outputStream.write(bytes);
                continue;
            }
            outputStream.write(buffer.array());
        }
    }

    @Override
    protected void recvResponse(SSLSocket sslSocket, ByteBuffer buffer) throws IOException {
        InputStream inputStream = sslSocket.getInputStream();
        byte[] tempBuf = new byte[buffer.remaining()];
        int read = inputStream.read(tempBuf);
        buffer.put(tempBuf, 0, read);
    }

    @Override
    protected void closeSocket() throws IOException {
        SSLSocket existingSocket = this.socket.getAndSet(null);
        if (existingSocket != null) {
            existingSocket.close();
        }
    }

    @Override
    public String toString() {
        return "SSLSender{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    implements Sender.Instantiator {
        private final NetworkSender.Config baseConfig = new NetworkSender.Config();

        public NetworkSender.Config getBaseConfig() {
            return this.baseConfig;
        }

        public SenderErrorHandler getSenderErrorHandler() {
            return this.baseConfig.getSenderErrorHandler();
        }

        public Config setSenderErrorHandler(SenderErrorHandler senderErrorHandler) {
            this.baseConfig.setSenderErrorHandler(senderErrorHandler);
            return this;
        }

        public String getHost() {
            return this.baseConfig.getHost();
        }

        public Config setHost(String host) {
            this.baseConfig.setHost(host);
            return this;
        }

        public int getPort() {
            return this.baseConfig.getPort();
        }

        public Config setPort(int port) {
            this.baseConfig.setPort(port);
            return this;
        }

        public int getConnectionTimeoutMilli() {
            return this.baseConfig.getConnectionTimeoutMilli();
        }

        public Config setConnectionTimeoutMilli(int connectionTimeoutMilli) {
            this.baseConfig.setConnectionTimeoutMilli(connectionTimeoutMilli);
            return this;
        }

        public int getReadTimeoutMilli() {
            return this.baseConfig.getReadTimeoutMilli();
        }

        public Config setReadTimeoutMilli(int readTimeoutMilli) {
            this.baseConfig.setReadTimeoutMilli(readTimeoutMilli);
            return this;
        }

        public Heartbeater.Instantiator getHeartbeaterConfig() {
            return this.baseConfig.getHeartbeaterConfig();
        }

        public Config setHeartbeaterConfig(Heartbeater.Instantiator heartbeaterConfig) {
            this.baseConfig.setHeartbeaterConfig(heartbeaterConfig);
            return this;
        }

        public FailureDetector.Config getFailureDetectorConfig() {
            return this.baseConfig.getFailureDetectorConfig();
        }

        public Config setFailureDetectorConfig(FailureDetector.Config failureDetectorConfig) {
            this.baseConfig.setFailureDetectorConfig(failureDetectorConfig);
            return this;
        }

        public FailureDetectStrategy.Instantiator getFailureDetectorStrategyConfig() {
            return this.baseConfig.getFailureDetectorStrategyConfig();
        }

        public Config setFailureDetectorStrategyConfig(FailureDetectStrategy.Instantiator failureDetectorStrategyConfig) {
            this.baseConfig.setFailureDetectorStrategyConfig(failureDetectorStrategyConfig);
            return this;
        }

        public int getWaitBeforeCloseMilli() {
            return this.baseConfig.getWaitBeforeCloseMilli();
        }

        public Config setWaitBeforeCloseMilli(int waitBeforeCloseMilli) {
            this.baseConfig.setWaitBeforeCloseMilli(waitBeforeCloseMilli);
            return this;
        }

        @Override
        public SSLSender createInstance() {
            return new SSLSender(this);
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + '}';
        }
    }
}

