/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.komamitsu.fluency.sender.NetworkSender;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.SenderErrorHandler;
import org.komamitsu.fluency.sender.failuredetect.FailureDetectStrategy;
import org.komamitsu.fluency.sender.failuredetect.FailureDetector;
import org.komamitsu.fluency.sender.heartbeat.Heartbeater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPSender
extends NetworkSender<SocketChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(TCPSender.class);
    private final AtomicReference<SocketChannel> channel = new AtomicReference();
    private final Config config;

    TCPSender(Config config) {
        super(config.getBaseConfig());
        this.config = config;
    }

    @Override
    protected SocketChannel getOrCreateSocketInternal() throws IOException {
        if (this.channel.get() == null) {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.socket().connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), this.config.getConnectionTimeoutMilli());
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setSoTimeout(this.config.getReadTimeoutMilli());
            this.channel.set(socketChannel);
        }
        return this.channel.get();
    }

    @Override
    protected void sendBuffers(SocketChannel socketChannel, List<ByteBuffer> buffers) throws IOException {
        socketChannel.write(buffers.toArray(new ByteBuffer[buffers.size()]));
    }

    @Override
    protected void recvResponse(SocketChannel socketChannel, ByteBuffer buffer) throws IOException {
        socketChannel.read(buffer);
    }

    @Override
    protected void closeSocket() throws IOException {
        SocketChannel existingSocketChannel = this.channel.getAndSet(null);
        if (existingSocketChannel != null) {
            existingSocketChannel.close();
        }
    }

    @Override
    public String toString() {
        return "TCPSender{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    implements Sender.Instantiator {
        private final NetworkSender.Config baseConfig = new NetworkSender.Config();

        public NetworkSender.Config getBaseConfig() {
            return this.baseConfig;
        }

        public SenderErrorHandler getSenderErrorHandler() {
            return this.baseConfig.getSenderErrorHandler();
        }

        public Config setSenderErrorHandler(SenderErrorHandler senderErrorHandler) {
            this.baseConfig.setSenderErrorHandler(senderErrorHandler);
            return this;
        }

        public String getHost() {
            return this.baseConfig.getHost();
        }

        public Config setHost(String host) {
            this.baseConfig.setHost(host);
            return this;
        }

        public int getPort() {
            return this.baseConfig.getPort();
        }

        public Config setPort(int port) {
            this.baseConfig.setPort(port);
            return this;
        }

        public int getConnectionTimeoutMilli() {
            return this.baseConfig.getConnectionTimeoutMilli();
        }

        public Config setConnectionTimeoutMilli(int connectionTimeoutMilli) {
            this.baseConfig.setConnectionTimeoutMilli(connectionTimeoutMilli);
            return this;
        }

        public int getReadTimeoutMilli() {
            return this.baseConfig.getReadTimeoutMilli();
        }

        public Config setReadTimeoutMilli(int readTimeoutMilli) {
            this.baseConfig.setReadTimeoutMilli(readTimeoutMilli);
            return this;
        }

        public Heartbeater.Instantiator getHeartbeaterConfig() {
            return this.baseConfig.getHeartbeaterConfig();
        }

        public Config setHeartbeaterConfig(Heartbeater.Instantiator heartbeaterConfig) {
            this.baseConfig.setHeartbeaterConfig(heartbeaterConfig);
            return this;
        }

        public FailureDetector.Config getFailureDetectorConfig() {
            return this.baseConfig.getFailureDetectorConfig();
        }

        public Config setFailureDetectorConfig(FailureDetector.Config failureDetectorConfig) {
            this.baseConfig.setFailureDetectorConfig(failureDetectorConfig);
            return this;
        }

        public FailureDetectStrategy.Instantiator getFailureDetectorStrategyConfig() {
            return this.baseConfig.getFailureDetectorStrategyConfig();
        }

        public Config setFailureDetectorStrategyConfig(FailureDetectStrategy.Instantiator failureDetectorStrategyConfig) {
            this.baseConfig.setFailureDetectorStrategyConfig(failureDetectorStrategyConfig);
            return this;
        }

        public int getWaitBeforeCloseMilli() {
            return this.baseConfig.getWaitBeforeCloseMilli();
        }

        public Config setWaitBeforeCloseMilli(int waitBeforeCloseMilli) {
            this.baseConfig.setWaitBeforeCloseMilli(waitBeforeCloseMilli);
            return this;
        }

        @Override
        public TCPSender createInstance() {
            return new TCPSender(this);
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + '}';
        }
    }
}

