/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.thirdparty.jackson.databind;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.komamitsu.thirdparty.jackson.annotation.JsonFormat;
import org.komamitsu.thirdparty.jackson.annotation.ObjectIdGenerator;
import org.komamitsu.thirdparty.jackson.annotation.ObjectIdResolver;
import org.komamitsu.thirdparty.jackson.core.Base64Variant;
import org.komamitsu.thirdparty.jackson.core.JsonParser;
import org.komamitsu.thirdparty.jackson.core.JsonToken;
import org.komamitsu.thirdparty.jackson.databind.AnnotationIntrospector;
import org.komamitsu.thirdparty.jackson.databind.BeanDescription;
import org.komamitsu.thirdparty.jackson.databind.BeanProperty;
import org.komamitsu.thirdparty.jackson.databind.DatabindContext;
import org.komamitsu.thirdparty.jackson.databind.DeserializationConfig;
import org.komamitsu.thirdparty.jackson.databind.DeserializationFeature;
import org.komamitsu.thirdparty.jackson.databind.InjectableValues;
import org.komamitsu.thirdparty.jackson.databind.JavaType;
import org.komamitsu.thirdparty.jackson.databind.JsonDeserializer;
import org.komamitsu.thirdparty.jackson.databind.JsonMappingException;
import org.komamitsu.thirdparty.jackson.databind.KeyDeserializer;
import org.komamitsu.thirdparty.jackson.databind.MapperFeature;
import org.komamitsu.thirdparty.jackson.databind.cfg.ContextAttributes;
import org.komamitsu.thirdparty.jackson.databind.deser.ContextualDeserializer;
import org.komamitsu.thirdparty.jackson.databind.deser.ContextualKeyDeserializer;
import org.komamitsu.thirdparty.jackson.databind.deser.DeserializationProblemHandler;
import org.komamitsu.thirdparty.jackson.databind.deser.DeserializerCache;
import org.komamitsu.thirdparty.jackson.databind.deser.DeserializerFactory;
import org.komamitsu.thirdparty.jackson.databind.deser.UnresolvedForwardReference;
import org.komamitsu.thirdparty.jackson.databind.deser.impl.ObjectIdReader;
import org.komamitsu.thirdparty.jackson.databind.deser.impl.ReadableObjectId;
import org.komamitsu.thirdparty.jackson.databind.deser.impl.TypeWrappedDeserializer;
import org.komamitsu.thirdparty.jackson.databind.exc.InvalidFormatException;
import org.komamitsu.thirdparty.jackson.databind.exc.InvalidTypeIdException;
import org.komamitsu.thirdparty.jackson.databind.exc.UnrecognizedPropertyException;
import org.komamitsu.thirdparty.jackson.databind.introspect.Annotated;
import org.komamitsu.thirdparty.jackson.databind.introspect.BeanPropertyDefinition;
import org.komamitsu.thirdparty.jackson.databind.jsontype.TypeDeserializer;
import org.komamitsu.thirdparty.jackson.databind.jsontype.TypeIdResolver;
import org.komamitsu.thirdparty.jackson.databind.node.JsonNodeFactory;
import org.komamitsu.thirdparty.jackson.databind.type.TypeFactory;
import org.komamitsu.thirdparty.jackson.databind.util.ArrayBuilders;
import org.komamitsu.thirdparty.jackson.databind.util.ClassUtil;
import org.komamitsu.thirdparty.jackson.databind.util.LinkedNode;
import org.komamitsu.thirdparty.jackson.databind.util.ObjectBuffer;

public abstract class DeserializationContext
extends DatabindContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ERROR_STR_LEN = 500;
    protected final DeserializerCache _cache;
    protected final DeserializerFactory _factory;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final Class<?> _view;
    protected transient JsonParser _parser;
    protected final InjectableValues _injectableValues;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;
    protected transient ContextAttributes _attributes;
    protected LinkedNode<JavaType> _currentType;

    protected DeserializationContext(DeserializerFactory df) {
        this(df, null);
    }

    protected DeserializationContext(DeserializerFactory df, DeserializerCache cache) {
        if (df == null) {
            throw new IllegalArgumentException("Can not pass null DeserializerFactory");
        }
        this._factory = df;
        this._cache = cache == null ? new DeserializerCache() : cache;
        this._featureFlags = 0;
        this._config = null;
        this._injectableValues = null;
        this._view = null;
        this._attributes = null;
    }

    protected DeserializationContext(DeserializationContext src, DeserializerFactory factory) {
        this._cache = src._cache;
        this._factory = factory;
        this._config = src._config;
        this._featureFlags = src._featureFlags;
        this._view = src._view;
        this._parser = src._parser;
        this._injectableValues = src._injectableValues;
        this._attributes = src._attributes;
    }

    protected DeserializationContext(DeserializationContext src, DeserializationConfig config, JsonParser p, InjectableValues injectableValues) {
        this._cache = src._cache;
        this._factory = src._factory;
        this._config = config;
        this._featureFlags = config.getDeserializationFeatures();
        this._view = config.getActiveView();
        this._parser = p;
        this._injectableValues = injectableValues;
        this._attributes = config.getAttributes();
    }

    protected DeserializationContext(DeserializationContext src) {
        this._cache = new DeserializerCache();
        this._factory = src._factory;
        this._config = src._config;
        this._featureFlags = src._featureFlags;
        this._view = src._view;
        this._injectableValues = null;
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature feature) {
        return this._config.isEnabled(feature);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> baseType) {
        return this._config.getDefaultPropertyFormat(baseType);
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    public Object getAttribute(Object key) {
        return this._attributes.getAttribute(key);
    }

    @Override
    public DeserializationContext setAttribute(Object key, Object value) {
        this._attributes = this._attributes.withPerCallAttribute(key, value);
        return this;
    }

    public JavaType getContextualType() {
        return this._currentType == null ? null : this._currentType.value();
    }

    public DeserializerFactory getFactory() {
        return this._factory;
    }

    public final boolean isEnabled(DeserializationFeature feat) {
        return (this._featureFlags & feat.getMask()) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._featureFlags;
    }

    public final boolean hasDeserializationFeatures(int featureMask) {
        return (this._featureFlags & featureMask) == featureMask;
    }

    public final boolean hasSomeOfFeatures(int featureMask) {
        return (this._featureFlags & featureMask) != 0;
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object valueId, BeanProperty forProperty, Object beanInstance) {
        if (this._injectableValues == null) {
            throw new IllegalStateException("No 'injectableValues' configured, can not inject value with id [" + valueId + "]");
        }
        return this._injectableValues.findInjectableValue(valueId, this, forProperty, beanInstance);
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    public boolean hasValueDeserializerFor(JavaType type, AtomicReference<Throwable> cause) {
        try {
            return this._cache.hasValueDeserializerFor(this, this._factory, type);
        }
        catch (JsonMappingException e) {
            if (cause != null) {
                cause.set(e);
            }
        }
        catch (RuntimeException e) {
            if (cause == null) {
                throw e;
            }
            cause.set(e);
        }
        return false;
    }

    public final JsonDeserializer<Object> findContextualValueDeserializer(JavaType type, BeanProperty prop) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._cache.findValueDeserializer(this, this._factory, type);
        if (deser != null) {
            deser = this.handleSecondaryContextualization(deser, prop, type);
        }
        return deser;
    }

    public final JsonDeserializer<Object> findNonContextualValueDeserializer(JavaType type) throws JsonMappingException {
        return this._cache.findValueDeserializer(this, this._factory, type);
    }

    public final JsonDeserializer<Object> findRootValueDeserializer(JavaType type) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._cache.findValueDeserializer(this, this._factory, type);
        if (deser == null) {
            return null;
        }
        deser = this.handleSecondaryContextualization(deser, null, type);
        TypeDeserializer typeDeser = this._factory.findTypeDeserializer(this._config, type);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(null);
            return new TypeWrappedDeserializer(typeDeser, deser);
        }
        return deser;
    }

    public final KeyDeserializer findKeyDeserializer(JavaType keyType, BeanProperty prop) throws JsonMappingException {
        KeyDeserializer kd = this._cache.findKeyDeserializer(this, this._factory, keyType);
        if (kd instanceof ContextualKeyDeserializer) {
            kd = ((ContextualKeyDeserializer)((Object)kd)).createContextual(this, prop);
        }
        return kd;
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2, ObjectIdResolver var3);

    public abstract void checkUnresolvedObjectId() throws UnresolvedForwardReference;

    public final JavaType constructType(Class<?> cls) {
        return this._config.constructType(cls);
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        return this.getTypeFactory().findClass(className);
    }

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer buf = this._objectBuffer;
        if (buf == null) {
            buf = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return buf;
    }

    public final void returnObjectBuffer(ObjectBuffer buf) {
        if (this._objectBuffer == null || buf.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = buf;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    public abstract JsonDeserializer<Object> deserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonDeserializer<?> handlePrimaryContextualization(JsonDeserializer<?> deser, BeanProperty prop, JavaType type) throws JsonMappingException {
        if (deser instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(type, this._currentType);
            try {
                deser = ((ContextualDeserializer)((Object)deser)).createContextual(this, prop);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return deser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonDeserializer<?> handleSecondaryContextualization(JsonDeserializer<?> deser, BeanProperty prop, JavaType type) throws JsonMappingException {
        if (deser instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(type, this._currentType);
            try {
                deser = ((ContextualDeserializer)((Object)deser)).createContextual(this, prop);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return deser;
    }

    @Deprecated
    public JsonDeserializer<?> handlePrimaryContextualization(JsonDeserializer<?> deser, BeanProperty prop) throws JsonMappingException {
        return this.handlePrimaryContextualization(deser, prop, TypeFactory.unknownType());
    }

    @Deprecated
    public JsonDeserializer<?> handleSecondaryContextualization(JsonDeserializer<?> deser, BeanProperty prop) throws JsonMappingException {
        if (deser instanceof ContextualDeserializer) {
            deser = ((ContextualDeserializer)((Object)deser)).createContextual(this, prop);
        }
        return deser;
    }

    public Date parseDate(String dateStr) throws IllegalArgumentException {
        try {
            DateFormat df = this.getDateFormat();
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("Failed to parse Date value '%s': %s", dateStr, e.getMessage()));
        }
    }

    public Calendar constructCalendar(Date d) {
        Calendar c = Calendar.getInstance(this.getTimeZone());
        c.setTime(d);
        return c;
    }

    public <T> T readValue(JsonParser p, Class<T> type) throws IOException {
        return this.readValue(p, this.getTypeFactory().constructType(type));
    }

    public <T> T readValue(JsonParser p, JavaType type) throws IOException {
        JsonDeserializer<Object> deser = this.findRootValueDeserializer(type);
        if (deser == null) {
            this.reportMappingException("Could not find JsonDeserializer for type %s", type);
        }
        return (T)deser.deserialize(p, this);
    }

    public <T> T readPropertyValue(JsonParser p, BeanProperty prop, Class<T> type) throws IOException {
        return this.readPropertyValue(p, prop, this.getTypeFactory().constructType(type));
    }

    public <T> T readPropertyValue(JsonParser p, BeanProperty prop, JavaType type) throws IOException {
        JsonDeserializer<Object> deser = this.findContextualValueDeserializer(type, prop);
        if (deser == null) {
            String propName = prop == null ? "NULL" : "'" + prop.getName() + "'";
            this.reportMappingException("Could not find JsonDeserializer for type %s (via property %s)", type, propName);
        }
        return (T)deser.deserialize(p, this);
    }

    public boolean handleUnknownProperty(JsonParser p, JsonDeserializer<?> deser, Object instanceOrClass, String propName) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            if (!h.value().handleUnknownProperty(this, p, deser, instanceOrClass, propName)) continue;
            return true;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            p.skipChildren();
            return true;
        }
        Collection<Object> propIds = deser == null ? null : deser.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, instanceOrClass, propName, propIds);
    }

    public Object handleWeirdKey(Class<?> keyClass, String keyValue, String msg, Object ... msgArgs) throws IOException {
        if (msgArgs.length > 0) {
            msg = String.format(msg, msgArgs);
        }
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object key = h.value().handleWeirdKey(this, keyClass, keyValue, msg);
            if (key == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (key == null || keyClass.isInstance(key)) {
                return key;
            }
            throw this.weirdStringException(keyValue, keyClass, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", keyClass, key.getClass()));
        }
        throw this.weirdKeyException(keyClass, keyValue, msg);
    }

    public Object handleWeirdStringValue(Class<?> targetClass, String value, String msg, Object ... msgArgs) throws IOException {
        if (msgArgs.length > 0) {
            msg = String.format(msg, msgArgs);
        }
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object instance = h.value().handleWeirdStringValue(this, targetClass, value, msg);
            if (instance == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(targetClass, instance)) {
                return instance;
            }
            throw this.weirdStringException(value, targetClass, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", targetClass, instance.getClass()));
        }
        throw this.weirdStringException(value, targetClass, msg);
    }

    public Object handleWeirdNumberValue(Class<?> targetClass, Number value, String msg, Object ... msgArgs) throws IOException {
        if (msgArgs.length > 0) {
            msg = String.format(msg, msgArgs);
        }
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object key = h.value().handleWeirdNumberValue(this, targetClass, value, msg);
            if (key == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(targetClass, key)) {
                return key;
            }
            throw this.weirdNumberException(value, targetClass, String.format("DeserializationProblemHandler.handleWeirdNumberValue() for type %s returned value of type %s", targetClass, key.getClass()));
        }
        throw this.weirdNumberException(value, targetClass, msg);
    }

    public Object handleMissingInstantiator(Class<?> instClass, JsonParser p, String msg, Object ... msgArgs) throws IOException {
        if (msgArgs.length > 0) {
            msg = String.format(msg, msgArgs);
        }
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object instance = h.value().handleMissingInstantiator(this, instClass, p, msg);
            if (instance == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(instClass, instance)) {
                return instance;
            }
            throw this.instantiationException(instClass, String.format("DeserializationProblemHandler.handleMissingInstantiator() for type %s returned value of type %s", instClass, instance.getClass()));
        }
        throw this.instantiationException(instClass, msg);
    }

    public Object handleInstantiationProblem(Class<?> instClass, Object argument, Throwable t) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object instance = h.value().handleInstantiationProblem(this, instClass, argument, t);
            if (instance == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(instClass, instance)) {
                return instance;
            }
            throw this.instantiationException(instClass, String.format("DeserializationProblemHandler.handleInstantiationProblem() for type %s returned value of type %s", instClass, instance.getClass()));
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw this.instantiationException(instClass, t);
    }

    public Object handleUnexpectedToken(Class<?> instClass, JsonParser p) throws IOException {
        return this.handleUnexpectedToken(instClass, p.getCurrentToken(), p, null, new Object[0]);
    }

    public Object handleUnexpectedToken(Class<?> instClass, JsonToken t, JsonParser p, String msg, Object ... msgArgs) throws IOException {
        if (msgArgs.length > 0) {
            msg = String.format(msg, msgArgs);
        }
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            Object instance = h.value().handleUnexpectedToken(this, instClass, t, p, msg);
            if (instance == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(instClass, instance)) {
                return instance;
            }
            this.reportMappingException("DeserializationProblemHandler.handleUnexpectedToken() for type %s returned value of type %s", instClass, instance.getClass());
        }
        if (msg == null) {
            msg = t == null ? String.format("Unexpected end-of-input when binding data into %s", this._calcName(instClass)) : String.format("Can not deserialize instance of %s out of %s token", new Object[]{this._calcName(instClass), t});
        }
        this.reportMappingException(msg, new Object[0]);
        return null;
    }

    public JavaType handleUnknownTypeId(JavaType baseType, String id, TypeIdResolver idResolver, String extraDesc) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers(); h != null; h = h.next()) {
            JavaType type = h.value().handleUnknownTypeId(this, baseType, id, idResolver, extraDesc);
            if (type == null) continue;
            if (type.hasRawClass(Void.class)) {
                return null;
            }
            if (type.isTypeOrSubTypeOf(baseType.getRawClass())) {
                return type;
            }
            throw this.unknownTypeIdException(baseType, id, "problem handler tried to resolve into non-subtype: " + type);
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
            return null;
        }
        throw this.unknownTypeIdException(baseType, id, extraDesc);
    }

    protected boolean _isCompatible(Class<?> target, Object value) {
        if (value == null || target.isInstance(value)) {
            return true;
        }
        return target.isPrimitive() && ClassUtil.wrapperType(target).isInstance(value);
    }

    public void reportWrongTokenException(JsonParser p, JsonToken expToken, String msg, Object ... msgArgs) throws JsonMappingException {
        if (msg != null && msgArgs.length > 0) {
            msg = String.format(msg, msgArgs);
        }
        throw this.wrongTokenException(p, expToken, msg);
    }

    @Deprecated
    public void reportUnknownProperty(Object instanceOrClass, String fieldName, JsonDeserializer<?> deser) throws JsonMappingException {
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            return;
        }
        Collection<Object> propIds = deser == null ? null : deser.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, instanceOrClass, fieldName, propIds);
    }

    public void reportMappingException(String msg, Object ... msgArgs) throws JsonMappingException {
        if (msgArgs.length > 0) {
            msg = String.format(msg, msgArgs);
        }
        throw JsonMappingException.from(this.getParser(), msg);
    }

    public void reportMissingContent(String msg, Object ... msgArgs) throws JsonMappingException {
        if (msg == null) {
            msg = "No content to map due to end-of-input";
        } else if (msgArgs.length > 0) {
            msg = String.format(msg, msgArgs);
        }
        throw JsonMappingException.from(this.getParser(), msg);
    }

    public void reportUnresolvedObjectId(ObjectIdReader oidReader, Object bean) throws JsonMappingException {
        String msg = String.format("No Object Id found for an instance of %s, to assign to property '%s'", bean.getClass().getName(), oidReader.propertyName);
        throw JsonMappingException.from(this.getParser(), msg);
    }

    public <T> T reportBadTypeDefinition(BeanDescription bean, String message, Object ... args) throws JsonMappingException {
        if (args != null && args.length > 0) {
            message = String.format(message, args);
        }
        String beanDesc = bean == null ? "N/A" : this._desc(bean.getType().getGenericSignature());
        throw this.mappingException("Invalid type definition for type %s: %s", beanDesc, message);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription bean, BeanPropertyDefinition prop, String message, Object ... args) throws JsonMappingException {
        if (args != null && args.length > 0) {
            message = String.format(message, args);
        }
        String propName = prop == null ? "N/A" : this._quotedString(prop.getName());
        String beanDesc = bean == null ? "N/A" : this._desc(bean.getType().getGenericSignature());
        throw this.mappingException("Invalid definition for property %s (of type %s): %s", propName, beanDesc, message);
    }

    public JsonMappingException mappingException(String message) {
        return JsonMappingException.from(this.getParser(), message);
    }

    public JsonMappingException mappingException(String msgTemplate, Object ... args) {
        if (args != null && args.length > 0) {
            msgTemplate = String.format(msgTemplate, args);
        }
        return JsonMappingException.from(this.getParser(), msgTemplate);
    }

    @Deprecated
    public JsonMappingException mappingException(Class<?> targetClass) {
        return this.mappingException(targetClass, this._parser.getCurrentToken());
    }

    @Deprecated
    public JsonMappingException mappingException(Class<?> targetClass, JsonToken token) {
        String tokenDesc = token == null ? "<end of input>" : String.format("%s token", new Object[]{token});
        return JsonMappingException.from(this._parser, String.format("Can not deserialize instance of %s out of %s", this._calcName(targetClass), tokenDesc));
    }

    public JsonMappingException wrongTokenException(JsonParser p, JsonToken expToken, String msg0) {
        String msg = String.format("Unexpected token (%s), expected %s", new Object[]{p.getCurrentToken(), expToken});
        if (msg0 != null) {
            msg = msg + ": " + msg0;
        }
        return JsonMappingException.from(p, msg);
    }

    public JsonMappingException weirdKeyException(Class<?> keyClass, String keyValue, String msg) {
        return InvalidFormatException.from(this._parser, String.format("Can not deserialize Map key of type %s from String %s: %s", keyClass.getName(), this._quotedString(keyValue), msg), keyValue, keyClass);
    }

    public JsonMappingException weirdStringException(String value, Class<?> instClass, String msg) {
        return InvalidFormatException.from(this._parser, String.format("Can not deserialize value of type %s from String %s: %s", instClass.getName(), this._quotedString(value), msg), value, instClass);
    }

    public JsonMappingException weirdNumberException(Number value, Class<?> instClass, String msg) {
        return InvalidFormatException.from(this._parser, String.format("Can not deserialize value of type %s from number %s: %s", instClass.getName(), String.valueOf(value), msg), value, instClass);
    }

    public JsonMappingException instantiationException(Class<?> instClass, Throwable t) {
        return JsonMappingException.from(this._parser, String.format("Can not construct instance of %s, problem: %s", instClass.getName(), t.getMessage()), t);
    }

    public JsonMappingException instantiationException(Class<?> instClass, String msg) {
        return JsonMappingException.from(this._parser, String.format("Can not construct instance of %s: %s", instClass.getName(), msg));
    }

    public JsonMappingException unknownTypeIdException(JavaType baseType, String typeId, String extraDesc) {
        String msg = String.format("Could not resolve type id '%s' into a subtype of %s", typeId, baseType);
        if (extraDesc != null) {
            msg = msg + ": " + extraDesc;
        }
        return InvalidTypeIdException.from(this._parser, msg, baseType, typeId);
    }

    @Deprecated
    public JsonMappingException unknownTypeException(JavaType type, String id, String extraDesc) {
        String msg = String.format("Could not resolve type id '%s' into a subtype of %s", id, type);
        if (extraDesc != null) {
            msg = msg + ": " + extraDesc;
        }
        return JsonMappingException.from(this._parser, msg);
    }

    @Deprecated
    public JsonMappingException endOfInputException(Class<?> instClass) {
        return JsonMappingException.from(this._parser, "Unexpected end-of-input when trying to deserialize a " + instClass.getName());
    }

    protected DateFormat getDateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat df = this._config.getDateFormat();
        this._dateFormat = df = (DateFormat)df.clone();
        return df;
    }

    protected String determineClassName(Object instance) {
        return ClassUtil.getClassDescription(instance);
    }

    protected String _calcName(Class<?> cls) {
        if (cls.isArray()) {
            return this._calcName(cls.getComponentType()) + "[]";
        }
        return cls.getName();
    }

    protected String _valueDesc() {
        try {
            return this._desc(this._parser.getText());
        }
        catch (Exception e) {
            return "[N/A]";
        }
    }

    protected String _desc(String desc) {
        if (desc == null) {
            return "[N/A]";
        }
        if (desc.length() > 500) {
            desc = desc.substring(0, 500) + "]...[" + desc.substring(desc.length() - 500);
        }
        return desc;
    }

    protected String _quotedString(String desc) {
        if (desc == null) {
            return "[N/A]";
        }
        if (desc.length() > 500) {
            return String.format("\"%s]...[%s\"", desc.substring(0, 500), desc.substring(desc.length() - 500));
        }
        return "\"" + desc + "\"";
    }
}

