/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.flusher.Flusher;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.util.ExecutorServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFlusher
extends Flusher {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncFlusher.class);
    private final BlockingQueue<Boolean> eventQueue = new LinkedBlockingQueue<Boolean>();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Config config;
    private final Runnable task = new Runnable(){

        @Override
        public void run() {
            Boolean wakeup = null;
            do {
                try {
                    wakeup = (Boolean)AsyncFlusher.this.eventQueue.poll(AsyncFlusher.this.config.getFlushIntervalMillis(), TimeUnit.MILLISECONDS);
                    boolean force = wakeup != null;
                    AsyncFlusher.this.buffer.flush(AsyncFlusher.this.sender, force);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    LOG.error("Failed to flush", (Throwable)e);
                }
            } while (!AsyncFlusher.this.executorService.isShutdown());
            if (wakeup == null) {
                try {
                    AsyncFlusher.this.buffer.flush(AsyncFlusher.this.sender, true);
                }
                catch (IOException e) {
                    LOG.error("Failed to flush", (Throwable)e);
                }
            }
        }
    };

    private AsyncFlusher(Buffer buffer, Sender sender, Config config) {
        super(buffer, sender, config.getBaseConfig());
        this.config = config;
        this.executorService.execute(this.task);
    }

    @Override
    protected void flushInternal(boolean force) throws IOException {
        if (force) {
            try {
                this.eventQueue.put(true);
            }
            catch (InterruptedException e) {
                LOG.warn("Failed to force flushing buffer", (Throwable)e);
            }
        }
    }

    @Override
    protected void beforeClosingBuffer() throws IOException {
        try {
            this.eventQueue.put(true);
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to close buffer", (Throwable)e);
        }
        finally {
            ExecutorServiceUtils.finishExecutorService(this.executorService, this.config.getWaitUntilBufferFlushed());
        }
    }

    @Override
    public String toString() {
        return "AsyncFlusher{eventQueue=" + this.eventQueue + ", config=" + this.config + ", task=" + this.task + "} " + super.toString();
    }

    public static class Config
    implements Flusher.Instantiator {
        private final Flusher.Config baseConfig = new Flusher.Config();

        public Flusher.Config getBaseConfig() {
            return this.baseConfig;
        }

        public int getFlushIntervalMillis() {
            return this.baseConfig.getFlushIntervalMillis();
        }

        public Config setFlushIntervalMillis(int flushIntervalMillis) {
            this.baseConfig.setFlushIntervalMillis(flushIntervalMillis);
            return this;
        }

        public Config setWaitUntilBufferFlushed(int wait) {
            this.baseConfig.setWaitUntilBufferFlushed(wait);
            return this;
        }

        public int getWaitUntilBufferFlushed() {
            return this.baseConfig.getWaitUntilBufferFlushed();
        }

        public Config setWaitUntilTerminated(int wait) {
            this.baseConfig.setWaitUntilTerminated(wait);
            return this;
        }

        public int getWaitUntilTerminated() {
            return this.baseConfig.getWaitUntilTerminated();
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + '}';
        }

        @Override
        public AsyncFlusher createInstance(Buffer buffer, Sender sender) {
            return new AsyncFlusher(buffer, sender, this);
        }
    }
}

