/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.komamitsu.fluency.format.Response;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.SenderErrorHandler;
import org.komamitsu.fluency.sender.failuredetect.FailureDetectStrategy;
import org.komamitsu.fluency.sender.failuredetect.FailureDetector;
import org.komamitsu.fluency.sender.failuredetect.PhiAccrualFailureDetectStrategy;
import org.komamitsu.fluency.sender.heartbeat.Heartbeater;
import org.komamitsu.fluency.util.ExecutorServiceUtils;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetworkSender<T>
extends Sender {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkSender.class);
    private static final Charset CHARSET_FOR_ERRORLOG = Charset.forName("UTF-8");
    private final byte[] optionBuffer = new byte[256];
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Config config;
    private final FailureDetector failureDetector;
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());

    NetworkSender(Config config) {
        super(config.getBaseConfig());
        this.config = config;
        FailureDetector failureDetector = null;
        if (config.getHeartbeaterConfig() != null) {
            try {
                failureDetector = new FailureDetector(config.getFailureDetectorStrategyConfig(), config.getHeartbeaterConfig(), config.getFailureDetectorConfig());
            }
            catch (IOException e) {
                LOG.warn("Failed to instantiate FailureDetector. Disabling it", (Throwable)e);
            }
        }
        this.failureDetector = failureDetector;
    }

    @Override
    public boolean isAvailable() {
        return this.failureDetector == null || this.failureDetector.isAvailable();
    }

    abstract T getOrCreateSocketInternal() throws IOException;

    private synchronized T getOrCreateSocket() throws IOException {
        return this.getOrCreateSocketInternal();
    }

    abstract void sendBuffers(T var1, List<ByteBuffer> var2) throws IOException;

    abstract void recvResponse(T var1, ByteBuffer var2) throws IOException;

    private void propagateFailure(Throwable e) {
        if (this.failureDetector != null) {
            this.failureDetector.onFailure(e);
        }
    }

    @Override
    protected synchronized void sendInternal(List<ByteBuffer> buffers, byte[] ackToken) throws IOException {
        try {
            LOG.trace("send(): sender.host={}, sender.port={}", (Object)this.getHost(), (Object)this.getPort());
            final T socket = this.getOrCreateSocket();
            this.sendBuffers(socket, buffers);
            if (ackToken == null) {
                return;
            }
            final ByteBuffer byteBuffer = ByteBuffer.wrap(this.optionBuffer);
            Future<Void> future = this.executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    LOG.trace("recv(): sender.host={}, sender.port={}", (Object)NetworkSender.this.getHost(), (Object)NetworkSender.this.getPort());
                    NetworkSender.this.recvResponse(socket, byteBuffer);
                    return null;
                }
            });
            try {
                future.get(this.config.getReadTimeoutMilli(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new IOException("InterruptedException occurred", e);
            }
            catch (ExecutionException e) {
                throw new IOException("ExecutionException occurred", e);
            }
            catch (TimeoutException e) {
                throw new SocketTimeoutException("Socket read timeout");
            }
            Response response = (Response)this.objectMapper.readValue(this.optionBuffer, Response.class);
            byte[] unpackedToken = response.getAck();
            if (!Arrays.equals(ackToken, unpackedToken)) {
                throw new UnmatchedAckException("Ack tokens don't matched: expected=" + new String(ackToken, CHARSET_FOR_ERRORLOG) + ", got=" + new String(unpackedToken, CHARSET_FOR_ERRORLOG));
            }
        }
        catch (IOException e) {
            this.closeSocket();
            this.propagateFailure(e);
            throw e;
        }
    }

    abstract void closeSocket() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            try {
                TimeUnit.MILLISECONDS.sleep(this.config.getWaitBeforeCloseMilli());
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.closeSocket();
        }
        finally {
            try {
                if (this.failureDetector != null) {
                    this.failureDetector.close();
                }
            }
            finally {
                ExecutorServiceUtils.finishExecutorService(this.executorService);
            }
        }
    }

    public String getHost() {
        return this.config.getHost();
    }

    public int getPort() {
        return this.config.getPort();
    }

    public int getConnectionTimeoutMilli() {
        return this.config.getConnectionTimeoutMilli();
    }

    public int getReadTimeoutMilli() {
        return this.config.getReadTimeoutMilli();
    }

    public FailureDetector getFailureDetector() {
        return this.failureDetector;
    }

    public String toString() {
        return "NetworkSender{config=" + this.config + ", failureDetector=" + this.failureDetector + "} " + super.toString();
    }

    public static class Config {
        private final Sender.Config baseConfig = new Sender.Config();
        private String host = "127.0.0.1";
        private int port = 24224;
        private int connectionTimeoutMilli = 5000;
        private int readTimeoutMilli = 5000;
        private Heartbeater.Instantiator heartbeaterConfig;
        private FailureDetector.Config failureDetectorConfig = new FailureDetector.Config();
        private FailureDetectStrategy.Instantiator failureDetectorStrategyConfig = new PhiAccrualFailureDetectStrategy.Config();
        private int waitBeforeCloseMilli = 1000;

        public Sender.Config getBaseConfig() {
            return this.baseConfig;
        }

        public SenderErrorHandler getSenderErrorHandler() {
            return this.baseConfig.getSenderErrorHandler();
        }

        public Config setSenderErrorHandler(SenderErrorHandler senderErrorHandler) {
            this.baseConfig.setSenderErrorHandler(senderErrorHandler);
            return this;
        }

        public String getHost() {
            return this.host;
        }

        public Config setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Config setPort(int port) {
            this.port = port;
            return this;
        }

        public int getConnectionTimeoutMilli() {
            return this.connectionTimeoutMilli;
        }

        public Config setConnectionTimeoutMilli(int connectionTimeoutMilli) {
            this.connectionTimeoutMilli = connectionTimeoutMilli;
            return this;
        }

        public int getReadTimeoutMilli() {
            return this.readTimeoutMilli;
        }

        public Config setReadTimeoutMilli(int readTimeoutMilli) {
            this.readTimeoutMilli = readTimeoutMilli;
            return this;
        }

        public Heartbeater.Instantiator getHeartbeaterConfig() {
            return this.heartbeaterConfig;
        }

        public Config setHeartbeaterConfig(Heartbeater.Instantiator heartbeaterConfig) {
            this.heartbeaterConfig = heartbeaterConfig;
            return this;
        }

        public FailureDetector.Config getFailureDetectorConfig() {
            return this.failureDetectorConfig;
        }

        public Config setFailureDetectorConfig(FailureDetector.Config failureDetectorConfig) {
            this.failureDetectorConfig = failureDetectorConfig;
            return this;
        }

        public FailureDetectStrategy.Instantiator getFailureDetectorStrategyConfig() {
            return this.failureDetectorStrategyConfig;
        }

        public Config setFailureDetectorStrategyConfig(FailureDetectStrategy.Instantiator failureDetectorStrategyConfig) {
            this.failureDetectorStrategyConfig = failureDetectorStrategyConfig;
            return this;
        }

        public int getWaitBeforeCloseMilli() {
            return this.waitBeforeCloseMilli;
        }

        public Config setWaitBeforeCloseMilli(int waitBeforeCloseMilli) {
            this.waitBeforeCloseMilli = waitBeforeCloseMilli;
            return this;
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + ", host='" + this.host + '\'' + ", port=" + this.port + ", connectionTimeoutMilli=" + this.connectionTimeoutMilli + ", readTimeoutMilli=" + this.readTimeoutMilli + ", heartbeaterConfig=" + this.heartbeaterConfig + ", failureDetectorConfig=" + this.failureDetectorConfig + ", failureDetectorStrategyConfig=" + this.failureDetectorStrategyConfig + ", waitBeforeCloseMilli=" + this.waitBeforeCloseMilli + '}';
        }
    }

    public static class UnmatchedAckException
    extends IOException {
        public UnmatchedAckException(String message) {
            super(message);
        }
    }
}

