/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.komamitsu.fluency.sender.SenderErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Sender
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Sender.class);
    private final Config config;

    protected Sender(Config config) {
        this.config = config;
    }

    public synchronized void send(ByteBuffer buffer) throws IOException {
        this.sendInternalWithRestoreBufferPositions(Arrays.asList(buffer), null);
    }

    public synchronized void send(List<ByteBuffer> buffers) throws IOException {
        this.sendInternalWithRestoreBufferPositions(buffers, null);
    }

    public void sendWithAck(List<ByteBuffer> buffers, byte[] ackToken) throws IOException {
        this.sendInternalWithRestoreBufferPositions(buffers, ackToken);
    }

    private void sendInternalWithRestoreBufferPositions(List<ByteBuffer> buffers, byte[] ackToken) throws IOException {
        ArrayList<Integer> positions = new ArrayList<Integer>(buffers.size());
        for (ByteBuffer data : buffers) {
            positions.add(data.position());
        }
        try {
            this.sendInternal(buffers, ackToken);
        }
        catch (Exception e) {
            for (int i = 0; i < buffers.size(); ++i) {
                buffers.get(i).position((Integer)positions.get(i));
            }
            if (this.config.senderErrorHandler != null) {
                try {
                    this.config.senderErrorHandler.handle(e);
                }
                catch (Exception ex) {
                    LOG.warn("Failed to handle an error in the error handler {}", (Object)this.config.senderErrorHandler, (Object)ex);
                }
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public abstract boolean isAvailable();

    protected abstract void sendInternal(List<ByteBuffer> var1, byte[] var2) throws IOException;

    public static interface Instantiator {
        public Sender createInstance();
    }

    public static class Config {
        private SenderErrorHandler senderErrorHandler;

        public SenderErrorHandler getSenderErrorHandler() {
            return this.senderErrorHandler;
        }

        public Config setSenderErrorHandler(SenderErrorHandler senderErrorHandler) {
            this.senderErrorHandler = senderErrorHandler;
            return this;
        }

        public String toString() {
            return "Config{senderErrorHandler=" + this.senderErrorHandler + '}';
        }
    }
}

