/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.heartbeat;

import java.io.IOException;
import javax.net.ssl.SSLSocket;
import org.komamitsu.fluency.sender.SSLSocketBuilder;
import org.komamitsu.fluency.sender.heartbeat.Heartbeater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLHeartbeater
extends Heartbeater {
    private static final Logger LOG = LoggerFactory.getLogger(SSLHeartbeater.class);
    private final Config config;
    private final SSLSocketBuilder sslSocketBuilder;

    protected SSLHeartbeater(Config config) throws IOException {
        super(config.getBaseConfig());
        this.config = config;
        this.sslSocketBuilder = new SSLSocketBuilder(config.getHost(), config.getPort(), config.connectionTimeoutMilli, config.readTimeoutMilli);
    }

    @Override
    protected void invoke() throws IOException {
        SSLSocket sslSocket = null;
        try {
            sslSocket = this.sslSocketBuilder.build();
            LOG.trace("SSLHeartbeat: remotePort={}, localPort={}", (Object)sslSocket.getPort(), (Object)sslSocket.getLocalPort());
            sslSocket.getSession();
            this.pong();
        }
        finally {
            if (sslSocket != null) {
                sslSocket.close();
            }
        }
    }

    @Override
    public String toString() {
        return "SSLHeartbeater{config=" + this.config + ", sslSocketBuilder=" + this.sslSocketBuilder + "} " + super.toString();
    }

    public static class Config
    implements Heartbeater.Instantiator {
        private final Heartbeater.Config baseConfig = new Heartbeater.Config();
        private int connectionTimeoutMilli = 5000;
        private int readTimeoutMilli = 5000;

        public Heartbeater.Config getBaseConfig() {
            return this.baseConfig;
        }

        public String getHost() {
            return this.baseConfig.getHost();
        }

        public Config setHost(String host) {
            this.baseConfig.setHost(host);
            return this;
        }

        public int getPort() {
            return this.baseConfig.getPort();
        }

        public Config setPort(int port) {
            this.baseConfig.setPort(port);
            return this;
        }

        public int getIntervalMillis() {
            return this.baseConfig.getIntervalMillis();
        }

        public Config setIntervalMillis(int intervalMillis) {
            this.baseConfig.setIntervalMillis(intervalMillis);
            return this;
        }

        public int getConnectionTimeoutMilli() {
            return this.connectionTimeoutMilli;
        }

        public Config setConnectionTimeoutMilli(int connectionTimeoutMilli) {
            this.connectionTimeoutMilli = connectionTimeoutMilli;
            return this;
        }

        public int getReadTimeoutMilli() {
            return this.readTimeoutMilli;
        }

        public Config setReadTimeoutMilli(int readTimeoutMilli) {
            this.readTimeoutMilli = readTimeoutMilli;
            return this;
        }

        @Override
        public SSLHeartbeater createInstance() throws IOException {
            return new SSLHeartbeater(this);
        }
    }
}

