/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.heartbeat;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.komamitsu.fluency.sender.heartbeat.Heartbeater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPHeartbeater
extends Heartbeater {
    private static final Logger LOG = LoggerFactory.getLogger(TCPHeartbeater.class);
    private final Config config;

    protected TCPHeartbeater(Config config) throws IOException {
        super(config.getBaseConfig());
        this.config = config;
    }

    @Override
    protected void invoke() throws IOException {
        AbstractInterruptibleChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(new InetSocketAddress(this.config.getHost(), this.config.getPort()));
            LOG.trace("TCPHeartbeat: remotePort={}, localPort={}", (Object)((SocketChannel)socketChannel).socket().getPort(), (Object)((SocketChannel)socketChannel).socket().getLocalPort());
            this.pong();
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
    }

    @Override
    public String toString() {
        return "TCPHeartbeater{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    implements Heartbeater.Instantiator {
        private final Heartbeater.Config baseConfig = new Heartbeater.Config();

        public Heartbeater.Config getBaseConfig() {
            return this.baseConfig;
        }

        public String getHost() {
            return this.baseConfig.getHost();
        }

        public int getPort() {
            return this.baseConfig.getPort();
        }

        public Config setIntervalMillis(int intervalMillis) {
            this.baseConfig.setIntervalMillis(intervalMillis);
            return this;
        }

        public int getIntervalMillis() {
            return this.baseConfig.getIntervalMillis();
        }

        public Config setHost(String host) {
            this.baseConfig.setHost(host);
            return this;
        }

        public Config setPort(int port) {
            this.baseConfig.setPort(port);
            return this;
        }

        public String toString() {
            return "Config{baseConfig=" + this.baseConfig + '}';
        }

        @Override
        public TCPHeartbeater createInstance() throws IOException {
            return new TCPHeartbeater(this);
        }
    }
}

