/*
 * Decompiled with CFR 0.152.
 */
package org.kompars.webpush;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.AES;
import dev.whyoleg.cryptography.algorithms.EC;
import dev.whyoleg.cryptography.algorithms.ECDH;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import dev.whyoleg.cryptography.algorithms.HMAC;
import dev.whyoleg.cryptography.algorithms.SHA256;
import dev.whyoleg.cryptography.materials.key.Key;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import dev.whyoleg.cryptography.random.CryptographyRandom;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientJvmKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMethod;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.http.UrlKt;
import io.ktor.http.content.NullBody;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.reflect.TypeInfo;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.io.bytestring.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kompars.webpush.Settings;
import org.kompars.webpush.Subscription;
import org.kompars.webpush.SubscriptionState;
import org.kompars.webpush.VapidKeys;
import org.kompars.webpush.WebPush;
import org.kompars.webpush.WebPushException;
import org.kompars.webpush.utils.Base64Kt;
import org.kompars.webpush.utils.JoseSignatureKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J(\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0016\u0010#\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u00020\u000b2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0'\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/kompars/webpush/WebPush;", "", "subject", "", "vapidKeys", "Lorg/kompars/webpush/VapidKeys;", "httpClient", "Lio/ktor/client/HttpClient;", "<init>", "(Ljava/lang/String;Lorg/kompars/webpush/VapidKeys;Lio/ktor/client/HttpClient;)V", "applicationServerKey", "", "getApplicationServerKey", "()[B", "encodedApplicationServerKey", "send", "Lorg/kompars/webpush/SubscriptionState;", "subscription", "Lorg/kompars/webpush/Subscription;", "payload", "settings", "Lorg/kompars/webpush/Settings;", "(Lorg/kompars/webpush/Subscription;[BLorg/kompars/webpush/Settings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "encryptBody", "p256dh", "auth", "hkdfSha256", "input", "salt", "info", "length", "", "hmacSha256", "key", "data", "createToken", "(Lorg/kompars/webpush/Subscription;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "concatBytes", "arrays", "", "([[B)[B", "Companion", "webpush"})
@SourceDebugExtension(value={"SMAP\nWebPush.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPush.kt\norg/kompars/webpush/WebPush\n+ 2 builders.kt\nio/ktor/client/request/BuildersKt\n+ 3 RequestBody.kt\nio/ktor/client/request/RequestBodyKt\n+ 4 Type.kt\nio/ktor/util/reflect/TypeKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n548#2:161\n369#2,3:162\n549#2,2:165\n551#2:190\n43#2:191\n16#3,4:167\n21#3,10:180\n69#4:171\n84#4,8:172\n1#5:192\n*S KotlinDebug\n*F\n+ 1 WebPush.kt\norg/kompars/webpush/WebPush\n*L\n41#1:161\n41#1:162,3\n41#1:165,2\n41#1:190\n41#1:191\n48#1:167,4\n48#1:180,10\n48#1:171\n48#1:172,8\n*E\n"})
public final class WebPush {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String subject;
    @NotNull
    private final VapidKeys vapidKeys;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final byte[] applicationServerKey;
    @NotNull
    private final String encodedApplicationServerKey;
    @NotNull
    private static final byte[] WEBPUSH_INFO = io.ktor.utils.io.core.StringsKt.toByteArray$default((String)"WebPush: info\u0000", null, (int)1, null);
    @NotNull
    private static final byte[] KEY_INFO = io.ktor.utils.io.core.StringsKt.toByteArray$default((String)"Content-Encoding: aes128gcm\u0000", null, (int)1, null);
    @NotNull
    private static final byte[] NONCE_INFO = io.ktor.utils.io.core.StringsKt.toByteArray$default((String)"Content-Encoding: nonce\u0000", null, (int)1, null);
    private static final long DEFAULT_TTL = Duration.getInWholeSeconds-impl((long)DurationKt.toDuration((int)28, (DurationUnit)DurationUnit.DAYS));
    private static final long TOKEN_TTL = Duration.getInWholeSeconds-impl((long)DurationKt.toDuration((int)12, (DurationUnit)DurationUnit.HOURS));

    public WebPush(@NotNull String subject, @NotNull VapidKeys vapidKeys, @NotNull HttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)vapidKeys, (String)"vapidKeys");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.subject = subject;
        this.vapidKeys = vapidKeys;
        this.httpClient = httpClient;
        this.applicationServerKey = this.vapidKeys.getPublicKey$webpush().encodeToByteArrayBlocking((KeyFormat)EC.PublicKey.Format.RAW.INSTANCE);
        this.encodedApplicationServerKey = Base64.encode$default((Base64)Base64Kt.getBase64(), (byte[])this.applicationServerKey, (int)0, (int)0, (int)6, null);
    }

    public /* synthetic */ WebPush(String string, VapidKeys vapidKeys, HttpClient httpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            httpClient = HttpClientJvmKt.HttpClient$default(null, (int)1, null);
        }
        this(string, vapidKeys, httpClient);
    }

    @NotNull
    public final byte[] getApplicationServerKey() {
        return this.applicationServerKey;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object send(@NotNull Subscription subscription, @NotNull byte[] payload, @Nullable Settings settings, @NotNull Continuation<? super SubscriptionState> $completion) {
        if (!($completion instanceof send.1)) ** GOTO lbl-1000
        var34_5 = $completion;
        if ((var34_5.label & -2147483648) != 0) {
            var34_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ WebPush this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.send(null, null, null, (Continuation<? super SubscriptionState>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var35_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = subscription;
                $continuation.L$1 = payload;
                $continuation.L$2 = settings;
                $continuation.label = 1;
                v0 = this.createToken(subscription, (Continuation<? super String>)$continuation);
                if (v0 == var35_7) {
                    return var35_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                settings = (Settings)$continuation.L$2;
                payload = (byte[])$continuation.L$1;
                subscription = (Subscription)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                token = (String)v0;
                body = this.encryptBody(payload, subscription.getKeys().getP256dh(), subscription.getKeys().getAuth());
                var8_12 = this.httpClient;
                urlString$iv = subscription.getEndpoint();
                $i$f$post = 0;
                $this$post$iv$iv = $this$post$iv;
                $i$f$post = 0;
                builder$iv$iv = new HttpRequestBuilder();
                builder$iv$iv.setMethod(HttpMethod.Companion.getPost());
                var14_23 = $this$post$iv$iv;
                $this$post_u24lambda_u245$iv = var15_25 = builder$iv$iv;
                $i$a$-post-BuildersKt$post$5$iv = false;
                HttpRequestKt.url((HttpRequestBuilder)$this$post_u24lambda_u245$iv, (String)urlString$iv);
                $this$send_u24lambda_u240 = $this$post_u24lambda_u245$iv;
                $i$a$-post-WebPush$send$response$1 = false;
                UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)$this$send_u24lambda_u240), (String)"Authorization", (Object)("vapid t=" + token + ", k=" + this.encodedApplicationServerKey));
                UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)$this$send_u24lambda_u240), (String)"Content-Encoding", (Object)"aes128gcm");
                UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)$this$send_u24lambda_u240), (String)"Content-Type", (Object)"application/octet-stream");
                v1 = settings;
                UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)$this$send_u24lambda_u240), (String)"TTL", (Object)Boxing.boxLong((long)(v1 != null && (v1 = v1.getTtl-FghU774()) != null ? Duration.getInWholeSeconds-impl((long)v1.unbox-impl()) : WebPush.DEFAULT_TTL)));
                v2 = settings;
                UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)$this$send_u24lambda_u240), (String)"Urgency", v2 != null && (v2 = v2.getUrgency()) != null ? v2.getHeaderValue$webpush() : null);
                v3 = settings;
                UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)$this$send_u24lambda_u240), (String)"Topic", (Object)(v3 != null ? v3.getTopic() : null));
                var20_31 = $this$send_u24lambda_u240;
                body$iv = body;
                $i$f$setBody = false;
                var23_34 = body$iv;
                if (var23_34 == null) {
                    $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                    var24_35 = $this$setBody$iv;
                    $i$f$typeInfo = false;
                    var26_39 = Reflection.getOrCreateKotlinClass(byte[].class);
                    $i$f$typeOfOrNull = false;
                    try {
                        var28_43 = Reflection.typeOf(byte[].class);
                    }
                    catch (Throwable <unused var>$iv$iv$iv) {
                        var28_43 = null;
                    }
                    var30_47 = var28_43;
                    var31_49 = var26_39;
                    var24_35.setBodyType(new TypeInfo(var31_49, var30_47));
                } else if (var23_34 instanceof OutgoingContent) {
                    $this$setBody$iv.setBody((Object)body$iv);
                    $this$setBody$iv.setBodyType(null);
                } else {
                    $this$setBody$iv.setBody((Object)body$iv);
                    var24_36 = $this$setBody$iv;
                    $i$f$typeInfo = false;
                    var26_40 = Reflection.getOrCreateKotlinClass(byte[].class);
                    $i$f$typeOfOrNull = false;
                    try {
                        var28_44 = Reflection.typeOf(byte[].class);
                    }
                    catch (Throwable <unused var>$iv$iv$iv) {
                        var28_44 = null;
                    }
                    var30_48 = var28_44;
                    var31_50 = var26_40;
                    var24_36.setBodyType(new TypeInfo(var31_50, var30_48));
                }
                $i$f$request = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)subscription);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)payload);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)settings);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)token);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)body);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$post$iv);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)urlString$iv);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$post$iv$iv);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)builder$iv$iv);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)$this$request$iv$iv$iv);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)builder$iv$iv$iv);
                $continuation.I$0 = $i$f$post;
                $continuation.I$1 = $i$f$post;
                $continuation.I$2 = $i$f$request;
                $continuation.label = 2;
                v4 = new HttpStatement((HttpRequestBuilder)builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv).execute((Continuation)$continuation);
                if (v4 == var35_7) {
                    return var35_7;
                }
                ** GOTO lbl134
            }
            case 2: {
                $i$f$request = $continuation.I$2;
                $i$f$post = $continuation.I$1;
                $i$f$post = $continuation.I$0;
                builder$iv$iv$iv = (HttpRequestBuilder)$continuation.L$10;
                $this$request$iv$iv$iv = (HttpClient)$continuation.L$9;
                builder$iv$iv = (HttpRequestBuilder)$continuation.L$8;
                $this$post$iv$iv = (HttpClient)$continuation.L$7;
                urlString$iv = (String)$continuation.L$6;
                $this$post$iv = (HttpClient)$continuation.L$5;
                body = (byte[])$continuation.L$4;
                token = (String)$continuation.L$3;
                settings = (Settings)$continuation.L$2;
                payload = (byte[])$continuation.L$1;
                subscription = (Subscription)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl134:
                // 2 sources

                response = (HttpResponse)v4;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)subscription);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)payload);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)settings);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)token);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)body);
                $continuation.L$5 = response;
                $continuation.L$6 = null;
                $continuation.L$7 = null;
                $continuation.L$8 = null;
                $continuation.L$9 = null;
                $continuation.L$10 = null;
                $continuation.label = 3;
                v5 = HttpResponseKt.bodyAsText$default((HttpResponse)response, null, (Continuation)$continuation, (int)1, null);
                if (v5 == var35_7) {
                    return var35_7;
                }
                ** GOTO lbl160
            }
            case 3: {
                response = (HttpResponse)$continuation.L$5;
                body = (byte[])$continuation.L$4;
                token = (String)$continuation.L$3;
                settings = (Settings)$continuation.L$2;
                payload = (byte[])$continuation.L$1;
                subscription = (Subscription)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl160:
                // 2 sources

                responseText = StringsKt.take((String)((String)v5), (int)200);
                switch (response.getStatus().getValue()) {
                    case 200: 
                    case 201: 
                    case 202: {
                        v6 = SubscriptionState.ACTIVE;
                        break;
                    }
                    case 404: 
                    case 410: {
                        v6 = SubscriptionState.EXPIRED;
                        break;
                    }
                    case 401: 
                    case 403: {
                        throw new WebPushException("Authentication failed: " + responseText, null, 2, null);
                    }
                    case 502: 
                    case 503: {
                        throw new WebPushException("Service unavailable: " + responseText, null, 2, null);
                    }
                    default: {
                        throw new WebPushException("Unexpected response: " + responseText, null, 2, null);
                    }
                }
                return v6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object send$default(WebPush webPush, Subscription subscription, byte[] byArray, Settings settings, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            settings = null;
        }
        return webPush.send(subscription, byArray, settings, (Continuation<? super SubscriptionState>)continuation);
    }

    private final byte[] encryptBody(byte[] payload, byte[] p256dh, byte[] auth) {
        ECDH.PublicKey userPublicKey = (ECDH.PublicKey)((ECDH)CryptographyProvider.Companion.getDefault().get((CryptographyAlgorithmId)ECDH.Companion)).publicKeyDecoder-yfdS0HE(EC.Curve.Companion.getP256-pVITJAk()).decodeFromByteArrayBlocking((KeyFormat)EC.PublicKey.Format.RAW.INSTANCE, p256dh);
        ECDH.KeyPair auxKeyPair = (ECDH.KeyPair)((ECDH)CryptographyProvider.Companion.getDefault().get((CryptographyAlgorithmId)ECDH.Companion)).keyPairGenerator-yfdS0HE(EC.Curve.Companion.getP256-pVITJAk()).generateKeyBlocking();
        byte[] auxPublicKey = ((ECDH.PublicKey)auxKeyPair.getPublicKey()).encodeToByteArrayBlocking((KeyFormat)EC.PublicKey.Format.RAW.INSTANCE);
        byte[] secret = ByteString.toByteArray$default((ByteString)((ECDH.PrivateKey)auxKeyPair.getPrivateKey()).sharedSecretGenerator().generateSharedSecretBlocking((Key)userPublicKey), (int)0, (int)0, (int)3, null);
        byte[] salt = CryptographyRandom.Default.nextBytes(16);
        byte[][] byArrayArray = new byte[][]{WEBPUSH_INFO, p256dh, auxPublicKey};
        byte[] secretInfo = this.concatBytes(byArrayArray);
        byte[] derivedSecret = this.hkdfSha256(secret, auth, secretInfo, 32);
        byte[] derivedKey = this.hkdfSha256(derivedSecret, salt, KEY_INFO, 16);
        byte[] derivedNonce = this.hkdfSha256(derivedSecret, salt, NONCE_INFO, 12);
        Object object = new byte[]{2};
        byte[] encryptedPayload = AES.GCM.Key.cipher-6q1zMKY$default((AES.GCM.Key)((AES.GCM.Key)((AES.GCM)CryptographyProvider.Companion.getDefault().get((CryptographyAlgorithmId)AES.GCM.Companion)).keyDecoder().decodeFromByteArrayBlocking((KeyFormat)AES.Key.Format.RAW, derivedKey)), (int)0, (int)1, null).encryptWithIvBlocking(derivedNonce, ArraysKt.plus((byte[])payload, (byte[])object), null);
        object = new byte[5][];
        object[0] = (byte)salt;
        byte[] byArray = new byte[]{0, 0, 16, 0};
        object[1] = (byte)byArray;
        byArray = new byte[]{(byte)auxPublicKey.length};
        object[2] = (byte)byArray;
        object[3] = (byte)auxPublicKey;
        object[4] = (byte)encryptedPayload;
        return this.concatBytes((byte[][])object);
    }

    private final byte[] hkdfSha256(byte[] input, byte[] salt, byte[] info, int length) {
        return ArraysKt.copyOfRange((byte[])this.hmacSha256(this.hmacSha256(salt, input), ArraysKt.plus((byte[])info, (byte)1)), (int)0, (int)length);
    }

    private final byte[] hmacSha256(byte[] key, byte[] data) {
        return ((HMAC.Key)((HMAC)CryptographyProvider.Companion.getDefault().get((CryptographyAlgorithmId)HMAC.Companion)).keyDecoder((CryptographyAlgorithmId)SHA256.INSTANCE).decodeFromByteArrayBlocking((KeyFormat)HMAC.Key.Format.RAW, key)).signatureGenerator().generateSignatureBlocking(data);
    }

    /*
     * Unable to fully structure code
     */
    private final Object createToken(Subscription subscription, Continuation<? super String> $completion) {
        if (!($completion instanceof createToken.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ WebPush this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WebPush.access$createToken(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                audience = UrlKt.getProtocolWithAuthority((Url)URLUtilsKt.Url((String)subscription.getEndpoint()));
                expiresAt = Clock.System.INSTANCE.now().toEpochMilliseconds() / (long)1000 + WebPush.TOKEN_TTL;
                payload = "{\"sub\":\"" + this.subject + "\",\"aud\":\"" + audience + "\",\"exp\":" + expiresAt + "}";
                encodedHeader = Base64.encode$default((Base64)Base64Kt.getBase64(), (byte[])StringsKt.encodeToByteArray((String)"{\"alg\":\"ES256\",\"typ\":\"JWT\"}"), (int)0, (int)0, (int)6, null);
                encodedPayload = Base64.encode$default((Base64)Base64Kt.getBase64(), (byte[])StringsKt.encodeToByteArray((String)payload), (int)0, (int)0, (int)6, null);
                encodedToken = encodedHeader + "." + encodedPayload;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)subscription);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)audience);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)payload);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)encodedHeader);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)encodedPayload);
                $continuation.L$5 = encodedToken;
                $continuation.J$0 = expiresAt;
                $continuation.label = 1;
                v0 = this.vapidKeys.getPrivateKey$webpush().signatureGenerator((CryptographyAlgorithmId)SHA256.INSTANCE, ECDSA.SignatureFormat.DER).generateSignature(StringsKt.encodeToByteArray((String)encodedToken), (Continuation)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl40
            }
            case 1: {
                expiresAt = $continuation.J$0;
                encodedToken = (String)$continuation.L$5;
                encodedPayload = (String)$continuation.L$4;
                encodedHeader = (String)$continuation.L$3;
                payload = (String)$continuation.L$2;
                audience = (String)$continuation.L$1;
                subscription = (Subscription)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl40:
                // 2 sources

                signature = (byte[])v0;
                encodedSignature = Base64.encode$default((Base64)Base64Kt.getBase64(), (byte[])JoseSignatureKt.convertDerToJose(signature), (int)0, (int)0, (int)6, null);
                return (String)encodedToken + "." + encodedSignature;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] concatBytes(byte[] ... arrays) {
        Object[] objectArray = (Object[])arrays;
        int n = 0;
        for (Object object : objectArray) {
            void it;
            byte[] byArray = (byte[])object;
            int n2 = n;
            boolean bl = false;
            int n3 = ((void)it).length;
            n = n2 + n3;
        }
        byte[] result = new byte[n];
        int position = 0;
        int n4 = ((Object[])arrays).length;
        for (n = 0; n < n4; ++n) {
            byte[] array = arrays[n];
            ArraysKt.copyInto$default((byte[])array, (byte[])result, (int)position, (int)0, (int)0, (int)12, null);
            position += array.length;
        }
        return result;
    }

    public static final /* synthetic */ Object access$createToken(WebPush $this, Subscription subscription, Continuation $completion) {
        return $this.createToken(subscription, (Continuation<? super String>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kompars/webpush/WebPush$Companion;", "", "<init>", "()V", "WEBPUSH_INFO", "", "KEY_INFO", "NONCE_INFO", "DEFAULT_TTL", "", "TOKEN_TTL", "webpush"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

