/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.plugins.generator;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KVisibility;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.AutoIncColumnType;
import org.jetbrains.exposed.sql.BasicBinaryColumnType;
import org.jetbrains.exposed.sql.BinaryColumnType;
import org.jetbrains.exposed.sql.BlobColumnType;
import org.jetbrains.exposed.sql.BooleanColumnType;
import org.jetbrains.exposed.sql.ByteColumnType;
import org.jetbrains.exposed.sql.CharColumnType;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.DecimalColumnType;
import org.jetbrains.exposed.sql.DoubleColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.IntegerColumnType;
import org.jetbrains.exposed.sql.LongColumnType;
import org.jetbrains.exposed.sql.ShortColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.UUIDColumnType;
import org.jetbrains.exposed.sql.VarCharColumnType;
import org.jetbrains.exposed.sql.javatime.JavaLocalDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaLocalDateTimeColumnType;
import org.jetbrains.exposed.sql.javatime.JavaLocalTimeColumnType;
import org.kopi.galite.plugins.generator.DBSchemaGenerator;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0014\u0010\n\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u001c\u0010\r\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001b\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u0015*\u00060\u001aj\u0002`\u001b2\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\u0015*\u00060\u001aj\u0002`\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/kopi/galite/plugins/generator/DBSchemaGenerator;", "", "()V", "GENERATED_KOTLIN_SRC", "", "GENERATED_SRC", "createGeneratedPath", "packageName", "schema", "directory", "getColumnName", "column", "Lorg/jetbrains/exposed/sql/Column;", "getColumnType", "type", "Lorg/jetbrains/exposed/sql/IColumnType;", "getIndexName", "index", "Lorg/jetbrains/exposed/sql/Index;", "getTableIndexDefinition", "main", "", "args", "", "([Ljava/lang/String;)V", "addClassComment", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addHeader", "dbschema-generator"})
@SourceDebugExtension(value={"SMAP\nDBSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DBSchemaGenerator.kt\norg/kopi/galite/plugins/generator/DBSchemaGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n766#2:242\n857#2,2:243\n1045#2:245\n1855#2:246\n1855#2,2:247\n1855#2,2:249\n1856#2:251\n1#3:252\n*S KotlinDebug\n*F\n+ 1 DBSchemaGenerator.kt\norg/kopi/galite/plugins/generator/DBSchemaGenerator\n*L\n48#1:242\n48#1:243,2\n74#1:245\n74#1:246\n80#1:247,2\n87#1:249,2\n74#1:251\n*E\n"})
public final class DBSchemaGenerator {
    @NotNull
    public static final DBSchemaGenerator INSTANCE = new DBSchemaGenerator();
    @NotNull
    public static final String GENERATED_KOTLIN_SRC = "src/generated/kotlin";
    @NotNull
    public static final String GENERATED_SRC = "src/generated";

    private DBSchemaGenerator() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        void $this$forEach$iv;
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length != 3) {
            return;
        }
        String packageName = args[0];
        String schemaName = args[1];
        String directory = args[2];
        File generatedFile = new File(INSTANCE.createGeneratedPath(packageName, schemaName, directory));
        String[] stringArray = new String[]{packageName};
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().forPackages(stringArray);
        stringArray = new Scanner[]{Scanners.SubTypes};
        Reflections reflections = new Reflections((Configuration)configurationBuilder.addScanners((Scanner[])stringArray));
        Set set = reflections.getSubTypesOf(Table.class);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"reflections.getSubTypesOf(Table::class.java)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean kClass22;
            Class it = (Class)element$iv$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                KClass kClass22 = JvmClassMappingKt.getKotlinClass((Class)it);
                kClass22 = kClass22.getVisibility() == KVisibility.PUBLIC;
            }
            catch (Exception e) {
                kClass22 = false;
            }
            if (!kClass22) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tableClasses = (List)destination$iv$iv;
        StringBuilder $this$main_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.addHeader($this$main_u24lambda_u247);
        Intrinsics.checkNotNullExpressionValue((Object)$this$main_u24lambda_u247.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder2 = $this$main_u24lambda_u247.append("package " + packageName + "." + schemaName);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        Intrinsics.checkNotNullExpressionValue((Object)$this$main_u24lambda_u247.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = $this$main_u24lambda_u247.append("import java.math.BigDecimal");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        Intrinsics.checkNotNullExpressionValue((Object)$this$main_u24lambda_u247.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder4 = $this$main_u24lambda_u247.append("import org.jetbrains.exposed.sql.Table");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder5 = $this$main_u24lambda_u247.append("import org.jetbrains.exposed.sql.javatime.date");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder6 = $this$main_u24lambda_u247.append("import org.jetbrains.exposed.sql.javatime.datetime");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder7 = $this$main_u24lambda_u247.append("import org.jetbrains.exposed.sql.javatime.time");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        Intrinsics.checkNotNullExpressionValue((Object)$this$main_u24lambda_u247.append('\n'), (String)"append('\\n')");
        INSTANCE.addClassComment($this$main_u24lambda_u247, schemaName);
        Intrinsics.checkNotNullExpressionValue((Object)$this$main_u24lambda_u247.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder8 = $this$main_u24lambda_u247.append("val sch\u00e9ma = \"" + schemaName + "\"");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
        Iterable $this$sortedBy$iv = tableClasses;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Class it = (Class)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Class)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder9;
            Table table;
            Class it = (Class)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if ((Table)JvmClassMappingKt.getKotlinClass((Class)it).getObjectInstance() == null) continue;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$main_u24lambda_u247.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder10 = $this$main_u24lambda_u247.append("object " + it.getSimpleName() + " : Table(\"$sch\u00e9ma." + table.getTableName() + "\") {");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append('\\n')");
            Iterable $this$forEach$iv2 = table.getColumns();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Column column = (Column)element$iv2;
                boolean bl4 = false;
                StringBuilder stringBuilder11 = $this$main_u24lambda_u247.append("  val " + INSTANCE.getColumnName(column) + " = " + INSTANCE.getColumnType(column, column.getColumnType()));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
            }
            if (!((Collection)table.getIndices()).isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)$this$main_u24lambda_u247.append('\n'), (String)"append('\\n')");
                StringBuilder stringBuilder12 = $this$main_u24lambda_u247.append("  init {");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append('\\n')");
                $this$forEach$iv2 = table.getIndices();
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Index index = (Index)element$iv2;
                    boolean bl5 = false;
                    StringBuilder stringBuilder13 = $this$main_u24lambda_u247.append(INSTANCE.getTableIndexDefinition(index));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13.append('\n'), (String)"append('\\n')");
                }
                StringBuilder stringBuilder14 = $this$main_u24lambda_u247.append("  }");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14.append('\n'), (String)"append('\\n')");
            }
            if (table.getPrimaryKey() != null) {
                Table.PrimaryKey primaryKey;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$main_u24lambda_u247.append('\n'), (String)"append('\\n')");
                StringBuilder stringBuilder15 = $this$main_u24lambda_u247.append("  override val primaryKey = PrimaryKey(" + ArraysKt.joinToString$default((Object[])primaryKey.getColumns(), (CharSequence)", ", null, null, (int)0, null, (Function1)main.generatedCode.1.2.1.3.1.INSTANCE, (int)30, null) + ")");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(value)");
                StringBuilder stringBuilder16 = stringBuilder15.append('\n');
                stringBuilder9 = stringBuilder16;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append('\\n')");
            } else {
                stringBuilder9 = null;
            }
            StringBuilder stringBuilder17 = $this$main_u24lambda_u247.append("}");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String generatedCode2 = string;
        File file = generatedFile.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        FilesKt.writeText$default((File)generatedFile, (String)generatedCode2, null, (int)2, null);
    }

    private final String createGeneratedPath(String packageName, String schema, String directory) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String string2 = StringsKt.replace$default((String)packageName, (String)".", (String)string, (boolean)false, (int)4, null);
        String string3 = schema.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return directory + File.separator + string2 + File.separator + schema + File.separator + "DBSchema" + string3 + ".kt";
    }

    private final String getColumnName(Column<?> column) {
        String string;
        String string2 = column.getName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)string2, (Object)"source")) {
            String string3 = column.getName().toUpperCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        } else {
            String string4 = column.getName().toLowerCase(Locale.ROOT);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        }
        return string;
    }

    private final String getColumnType(Column<?> column, IColumnType type) {
        String columnDefinition;
        block1: {
            String string;
            columnDefinition = null;
            IColumnType iColumnType = type;
            String string2 = iColumnType instanceof JavaLocalDateColumnType ? "date(\"" + column.getName() + "\")" : (iColumnType instanceof JavaLocalTimeColumnType ? "time(\"" + column.getName() + "\")" : (iColumnType instanceof JavaLocalDateTimeColumnType ? "datetime(\"" + column.getName() + "\")" : (iColumnType instanceof BooleanColumnType ? "bool(\"" + column.getName() + "\")" : (iColumnType instanceof IntegerColumnType ? "integer(\"" + column.getName() + "\")" : (iColumnType instanceof LongColumnType ? "long(\"" + column.getName() + "\")" : (iColumnType instanceof ByteColumnType ? "byte(\"" + column.getName() + "\")" : (iColumnType instanceof ShortColumnType ? "short(\"" + column.getName() + "\")" : (iColumnType instanceof AutoIncColumnType ? (((AutoIncColumnType)type).getDelegate() instanceof LongColumnType ? "long(\"" + column.getName() + "\").autoIncrement()" : "integer(\"" + column.getName() + "\").autoIncrement()") : (iColumnType instanceof DecimalColumnType ? "decimal(\"" + column.getName() + "\", " + ((DecimalColumnType)type).getPrecision() + ", " + ((DecimalColumnType)type).getScale() + ")" : (((iColumnType instanceof BlobColumnType ? true : iColumnType instanceof BinaryColumnType) ? true : iColumnType instanceof BasicBinaryColumnType) ? "blob(\"" + column.getName() + "\")" : (iColumnType instanceof DoubleColumnType ? "double(\"" + column.getName() + "\")" : (iColumnType instanceof UUIDColumnType ? "uuid(\"" + column.getName() + "\")" : (iColumnType instanceof VarCharColumnType ? "varchar(\"" + column.getName() + "\", " + ((VarCharColumnType)type).getColLength() + ")" : (iColumnType instanceof TextColumnType ? "text(\"" + column.getName() + "\")" : (columnDefinition = iColumnType instanceof CharColumnType ? "char(\"" + column.getName() + "\", " + ((CharColumnType)type).getColLength() + ")" : "!!! FIXME !!!")))))))))))))));
            if (type.getNullable()) {
                columnDefinition = columnDefinition + ".nullable()";
            }
            Function0 function0 = column.getDefaultValueFun();
            if (function0 == null) break block1;
            Function0 it = function0;
            boolean bl = false;
            IColumnType iColumnType2 = type;
            columnDefinition = columnDefinition + ((iColumnType2 instanceof TextColumnType ? true : iColumnType2 instanceof VarCharColumnType) ? ".default(\"" + it.invoke() + "\")" : (iColumnType2 instanceof DecimalColumnType ? ".default(" + (String)(Intrinsics.areEqual((Object)(string = String.valueOf(it.invoke())), (Object)"0") ? "BigDecimal.ZERO" : (Intrinsics.areEqual((Object)string, (Object)"1") ? "BigDecimal.ONE" : "BigDecimal(\"" + it.invoke() + "\")")) + ")" : ".default(" + it.invoke() + ")"));
        }
        return columnDefinition;
    }

    private final String getTableIndexDefinition(Index index) {
        return index.getUnique() ? "    uniqueIndex(" + this.getIndexName(index) + ", " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), (CharSequence)", ", null, null, (int)0, null, (Function1)getTableIndexDefinition.1.INSTANCE, (int)30, null) + ")" : "    index(" + this.getIndexName(index) + ", false, " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), (CharSequence)", ", null, null, (int)0, null, (Function1)getTableIndexDefinition.2.INSTANCE, (int)30, null) + ")";
    }

    private final String getIndexName(Index index) {
        Object object;
        block3: {
            block2: {
                object = index.getCustomName();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "\"" + it + "\"";
                object = string;
                if (string != null) break block3;
            }
            object = "null";
        }
        return object;
    }

    private final void addHeader(StringBuilder $this$addHeader) {
        $this$addHeader.append(StringsKt.trimIndent((String)("\n/*\n * Copyright (c) 2013-" + LocalDate.now().getYear() + " kopiLeft Services SARL, Tunis TN\n * Copyright (c) 1990-" + LocalDate.now().getYear() + " kopiRight Managed Solutions GmbH, Wien AT\n *\n * This library is free software; you can redistribute it and/or\n * modify it under the terms of the GNU Lesser General Public\n * License version 2.1 as published by the Free Software Foundation.\n *\n * This library is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n * Lesser General Public License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public\n * License along with this library; if not, write to the Free Software\n * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA\n */\n      ")));
        Intrinsics.checkNotNullExpressionValue((Object)$this$addHeader.append('\n'), (String)"append('\\n')");
    }

    private final void addClassComment(StringBuilder $this$addClassComment, String schema) {
        $this$addClassComment.append(StringsKt.trimIndent((String)("\n/*\n * Database structure generated for schema: " + schema + "\n *\n * Automatically generated - do not modify.\n */\n      ")));
        Intrinsics.checkNotNullExpressionValue((Object)$this$addClassComment.append('\n'), (String)"append('\\n')");
    }

    public static final /* synthetic */ String access$getColumnName(DBSchemaGenerator $this, Column column) {
        return $this.getColumnName(column);
    }
}

