/*
 * Copyright (c) 2013-2021 kopiLeft Services SARL, Tunis TN
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.kopi.galite.visual.dsl.form

import org.kopi.galite.visual.cross.VDynamicReport
import org.kopi.galite.visual.db.DBContext
import org.kopi.galite.visual.form.VDictionary
import org.kopi.galite.visual.form.VDictionaryForm
import org.kopi.galite.visual.visual.ApplicationContext
import org.kopi.galite.visual.visual.VWindow

/**
 * Represents a dictionary form.
 */
abstract class DictionaryForm : VDictionary, Form() {

  override fun search(parent: VWindow): Int = model.search(parent)

  override fun edit(parent: VWindow, id: Int): Int = model.edit(parent, id)

  override fun add(parent: VWindow): Int = model.add(parent)

  override var dBContext: DBContext?
    get() = model.dBContext
    set(value) {
      model.dBContext = value
    }

  override fun doNotModal() {
    model.doNotModal()
  }

  /**
   * create a report for this form
   */
  protected fun FormBlock.createDynamicReport() {
    val field = this.vBlock.activeField
    field?.validate()
    VDynamicReport.createDynamicReport(this.vBlock)
  }

  // ----------------------------------------------------------------------
  // DICTIONARY FORM MODEL
  // ----------------------------------------------------------------------
  override val model: VDictionaryForm by lazy { DictionaryFormModel() }

  inner class DictionaryFormModel: VDictionaryForm() {
    override val locale get() = this@DictionaryForm.locale ?: ApplicationContext.getDefaultLocale()
    override fun init() {
      initialize()
    }
  }
}
