/*
 * Copyright (c) 2013-2021 kopiLeft Services SARL, Tunis TN
 * Copyright (c) 1990-2021 kopiRight Managed Solutions GmbH, Wien AT
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package org.kopi.galite.visual.visual

/**
 * Child of this class represents objects than can be executed asynchronously
 * by the action mechanism
 */
interface ActionHandler {

  /**
   * Performs a void trigger
   *
   * @param  VKT_Type   the number of the trigger
   */
  fun executeVoidTrigger(VKT_Type: Int)

  /**
   * Performs the appropriate action asynchronously.
   * You can use this method to perform any operation out of the UI event process
   *
   * @param  action  represents the action to perform.
   */
  fun performAsyncAction(action: Action)

  /**
   * Performs the appropriate action asynchronously.
   * You can use this method to perform any operation out of the UI event process
   *
   * @param        action                the action to perform.
   * @param        block                This action should block the UI thread ?
   */
  @Deprecated("use method performAsyncAction")
  fun performAction(action: Action, block: Boolean)

  fun displayError(Message: String) {
    TODO()
  }
}
