/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.type;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.type.Type;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 +2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0011\b\u0010\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0004J\u0011\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001d\u001a\u0004\u0018\u00010 H\u0096\u0002J\u001a\u0010!\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\b\b\u0002\u0010\"\u001a\u00020#H\u0017J\b\u0010$\u001a\u00020\u0004H\u0016J\b\u0010%\u001a\u00020\u0004H\u0016J\u000e\u0010&\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\nH\u0016J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0015\"\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006,"}, d2={"Lorg/kopi/galite/visual/type/Date;", "Lorg/kopi/galite/visual/type/Type;", "Ljava/time/LocalDate;", "year", "", "month", "day", "(III)V", "date", "(Ljava/time/LocalDate;)V", "Ljava/sql/Date;", "(Ljava/sql/Date;)V", "calendar", "Ljava/util/Calendar;", "(Ljava/util/Calendar;)V", "image", "", "(Ljava/lang/String;)V", "scalar", "(I)V", "getDay", "()I", "getMonth", "getScalar", "setScalar", "getYear", "add", "days", "compareTo", "other", "equals", "", "", "format", "locale", "Ljava/util/Locale;", "getWeekday", "hashCode", "subtract", "toCalendar", "Ljava/util/GregorianCalendar;", "toSql", "toString", "Companion", "galite-core"})
public class Date
extends Type<Date, LocalDate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int scalar;
    @NotNull
    private static final GregorianCalendar calendar = new GregorianCalendar();
    @NotNull
    private static final Date ORIGIN = new Date(1970, 1, 1);
    @NotNull
    private static final Date DEFAULT = new Date(0);

    public Date(int year, int month, int day) {
        this.scalar = Date.Companion.gregorianToJulian(year, month, day);
    }

    public Date(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.scalar = Date.Companion.gregorianToJulian(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date(@NotNull java.sql.Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        GregorianCalendar gregorianCalendar = calendar;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (gregorianCalendar) {
            boolean bl3 = false;
            calendar.setTime(date);
            this.setScalar(Date.Companion.gregorianToJulian(Date.calendar.get(1), Date.calendar.get(2) + 1, Date.calendar.get(5)));
            Unit unit = Unit.INSTANCE;
        }
    }

    public Date(@Nullable Calendar calendar) {
        if (calendar != null) {
            this.scalar = Date.Companion.gregorianToJulian(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        }
    }

    public Date(@NotNull String image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Pattern pattern = Pattern.compile("(\\d\\d\\d\\d)[-.]{1}(\\d\\d?)[-.]{1}(\\d\\d?)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"(\\\\d\\\\d\\\\d\\\\d)[\u2026\\d\\\\d?)[-.]{1}(\\\\d\\\\d?)\")");
        Pattern pattern2 = pattern;
        Matcher matcher = pattern2.matcher(image);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"pattern.matcher(image)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"invalid date string ", (Object)image));
        }
        String[] res = Pattern.compile("[-.]").split(image);
        String string = res[0];
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"res[0]");
        boolean bl = false;
        int n = Integer.parseInt(string);
        string = res[1];
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"res[1]");
        bl = false;
        int n2 = Integer.parseInt(string);
        string = res[2];
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"res[2]");
        bl = false;
        this.scalar = Date.Companion.gregorianToJulian(n, n2, Integer.parseInt(string));
    }

    @JvmOverloads
    @NotNull
    public String format(@NotNull String format2, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, this.getYear());
        cal.set(2, this.getMonth() - 1);
        cal.set(5, this.getDay());
        String string = new SimpleDateFormat(format2, locale).format(cal.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(format, locale).format(cal.time)");
        return string;
    }

    public static /* synthetic */ String format$default(Date date, String string, Locale locale, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: format");
        }
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return date.format(string, locale);
    }

    @NotNull
    public final GregorianCalendar toCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.set(1, this.getYear());
        calendar.set(2, this.getMonth() - 1);
        calendar.set(5, this.getDay());
        return calendar;
    }

    public Date(int scalar) {
        this.scalar = scalar;
    }

    public final int getYear() {
        return Date.Companion.julianToGregorian(this.scalar)[0];
    }

    public final int getMonth() {
        return Date.Companion.julianToGregorian(this.scalar)[1];
    }

    public final int getDay() {
        return Date.Companion.julianToGregorian(this.scalar)[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWeekday() {
        GregorianCalendar gregorianCalendar = calendar;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (gregorianCalendar) {
            boolean bl3 = false;
            int[] gregorian = Date.Companion.julianToGregorian(this.getScalar());
            calendar.set(1, gregorian[0]);
            calendar.set(2, gregorian[1] - 1);
            calendar.set(5, gregorian[2]);
            int n = calendar.get(7);
            return n;
        }
    }

    @NotNull
    public final Date add(int days) {
        return new Date(this.scalar + days);
    }

    public final int subtract(@NotNull Date other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.scalar - other.scalar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other == null ? true : other instanceof Date)) return false;
        int n = this.scalar;
        Date date = (Date)other;
        if (date == null) {
            return false;
        }
        if (n != date.scalar) return false;
        return true;
    }

    @Override
    public int compareTo(@NotNull Date other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int v1 = this.scalar;
        int v2 = other.scalar;
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    @Override
    @NotNull
    public String toString(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        int[] gregorian = Date.Companion.julianToGregorian(this.scalar);
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d2 = stringBuilder;
        boolean bl5 = false;
        $this$toString_u24lambda_u2d2.append(gregorian[2] / 10);
        $this$toString_u24lambda_u2d2.append(gregorian[2] % 10);
        $this$toString_u24lambda_u2d2.append('.');
        $this$toString_u24lambda_u2d2.append(gregorian[1] / 10);
        $this$toString_u24lambda_u2d2.append(gregorian[1] % 10);
        $this$toString_u24lambda_u2d2.append('.');
        $this$toString_u24lambda_u2d2.append(gregorian[0]);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public java.sql.Date toSql() {
        int[] gregorian = Date.Companion.julianToGregorian(this.scalar);
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toSql_u24lambda_u2d3 = stringBuilder;
        boolean bl5 = false;
        $this$toSql_u24lambda_u2d3.append(gregorian[0]);
        $this$toSql_u24lambda_u2d3.append('-');
        $this$toSql_u24lambda_u2d3.append(gregorian[1] / 10);
        $this$toSql_u24lambda_u2d3.append(gregorian[1] % 10);
        $this$toSql_u24lambda_u2d3.append('-');
        $this$toSql_u24lambda_u2d3.append(gregorian[2] / 10);
        $this$toSql_u24lambda_u2d3.append(gregorian[2] % 10);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String date = string;
        java.sql.Date date2 = java.sql.Date.valueOf(date);
        Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"valueOf(date)");
        return date2;
    }

    public final int getScalar() {
        return this.scalar;
    }

    public final void setScalar(int n) {
        this.scalar = n;
    }

    public int hashCode() {
        return Integer.hashCode(this.scalar);
    }

    @JvmOverloads
    @NotNull
    public final String format(@NotNull String format2) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        return Date.format$default(this, format2, null, 2, null);
    }

    static {
        calendar.setMinimalDaysInFirstWeek(4);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0006\u0010\u0012\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/kopi/galite/visual/type/Date$Companion;", "", "()V", "DEFAULT", "Lorg/kopi/galite/visual/type/Date;", "getDEFAULT", "()Lorg/kopi/galite/visual/type/Date;", "ORIGIN", "calendar", "Ljava/util/GregorianCalendar;", "gregorianToJulian", "", "y", "m", "d", "julianToGregorian", "", "julian", "now", "parse", "input", "", "format", "locale", "Ljava/util/Locale;", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Date now() {
            Calendar now = Calendar.getInstance();
            return new Date(now.get(1), now.get(2) + 1, now.get(5));
        }

        @NotNull
        public final Date parse(@NotNull String input, @NotNull String format2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            return this.parse(input, format2, locale);
        }

        @NotNull
        public final Date parse(@NotNull String input, @NotNull String format2, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            GregorianCalendar cal = new GregorianCalendar();
            try {
                cal.setTime(new SimpleDateFormat(format2, locale).parse(input));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage());
            }
            return new Date(cal.get(1), cal.get(2) + 1, cal.get(5));
        }

        private final int gregorianToJulian(int y, int m, int d) {
            int y2 = y;
            int m2 = m;
            int c = 0;
            if (m2 > 2) {
                m2 -= 3;
            } else {
                m2 += 9;
                --y2;
            }
            c = y2 / 100;
            return (146097 * c >> 2) + (1461 * (y2 %= 100) >> 2) + (153 * m2 + 2) / 5 + d + 1721119;
        }

        private final int[] julianToGregorian(int julian) {
            int y = 0;
            int m = 0;
            int d = 0;
            int j = julian - 1721119;
            y = ((j << 2) - 1) / 146097;
            j = (j << 2) - 1 - 146097 * y;
            d = j >> 2;
            j = ((d << 2) + 3) / 1461;
            d = (d << 2) + 3 - 1461 * j;
            d = d + 4 >> 2;
            m = (5 * d - 3) / 153;
            d = 5 * d - 3 - 153 * m;
            d = (d + 5) / 5;
            y = 100 * y + j;
            m = m < 10 ? (m += 3) : (m -= 9);
            int[] nArray = new int[]{++y, m, d};
            return nArray;
        }

        @NotNull
        public final Date getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

