/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.type.Type0;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 A2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001AB\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012B\r\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0013J\u0011\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0011\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0013\u0010#\u001a\u00020$2\b\u0010\u001e\u001a\u0004\u0018\u00010%H\u0096\u0002J\b\u0010&\u001a\u00020\u000bH\u0016J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0011\u0010(\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0011\u0010*\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0011\u0010,\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u000bJ\u0016\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u0011\u0010/\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0011\u00100\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020\u000eH\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u000bH\u0016J\b\u00109\u001a\u00020\tH\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0004H\u0016J\b\u0010=\u001a\u00020\u0011H\u0016J\u0010\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020?H\u0016J\t\u0010@\u001a\u00020\u0000H\u0086\u0002R\u001a\u0010\u0014\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u0013\u00a8\u0006B"}, d2={"Lorg/kopi/galite/visual/type/Decimal;", "", "", "Lorg/kopi/galite/visual/type/Type0;", "Ljava/math/BigDecimal;", "b", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "value", "", "scale", "", "(JI)V", "d", "", "(D)V", "s", "", "(Ljava/lang/String;)V", "(Ljava/math/BigDecimal;)V", "maxScale", "getMaxScale", "()I", "setMaxScale", "(I)V", "getScale", "getValue", "()Ljava/math/BigDecimal;", "setValue", "compareTo", "other", "div", "f", "divAssign", "", "equals", "", "", "hashCode", "minus", "minusAssign", "plus", "plusAssign", "rem", "remAssign", "setScale", "v", "times", "timesAssign", "toByte", "", "toChar", "", "toDouble", "toFloat", "", "toInt", "toLong", "toShort", "", "toSql", "toString", "locale", "Ljava/util/Locale;", "unaryMinus", "Companion", "galite-core"})
public final class Decimal
extends Number
implements Comparable<Decimal>,
Type0<BigDecimal> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BigDecimal value;
    private int maxScale;
    @NotNull
    private static final MathContext MATH_CONTEXT = new MathContext(0, RoundingMode.HALF_UP);
    @NotNull
    private static final MathContext DIV_CONTEXT = new MathContext(30, RoundingMode.HALF_UP);
    @NotNull
    private static final Decimal DEFAULT = new Decimal(0.0);
    private static final long serialVersionUID = 1L;

    public Decimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.maxScale = -1;
    }

    @NotNull
    public final BigDecimal getValue() {
        return this.value;
    }

    public final void setValue(@NotNull BigDecimal bigDecimal) {
        Intrinsics.checkNotNullParameter((Object)bigDecimal, (String)"<set-?>");
        this.value = bigDecimal;
    }

    public Decimal(@NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this(new BigDecimal(b));
    }

    public Decimal(long value, int scale) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value, scale);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(value, scale)");
        this(bigDecimal);
    }

    public Decimal(double d) {
        this(new BigDecimal(d));
    }

    public Decimal(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this(new BigDecimal(s));
    }

    @NotNull
    public final Decimal plus(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            return f;
        }
        if (f.value.compareTo(BigDecimal.ZERO) == 0) {
            return new Decimal(this.value);
        }
        BigDecimal bigDecimal = this.value.add(f.value, MATH_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.add(f.value, MATH_CONTEXT)");
        return new Decimal(bigDecimal);
    }

    public final void plusAssign(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            this.value = f.value;
        } else if (f.value.compareTo(BigDecimal.ZERO) != 0) {
            this.value.add(f.value, MATH_CONTEXT);
        }
    }

    @NotNull
    public final Decimal div(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        BigDecimal bigDecimal = this.value.divide(f.value, DIV_CONTEXT).plus(MATH_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.divide(f.value, DI\u2026NTEXT).plus(MATH_CONTEXT)");
        return new Decimal(bigDecimal);
    }

    public final void divAssign(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        BigDecimal bigDecimal = this.value.divide(f.value, DIV_CONTEXT).plus(MATH_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.divide(f.value, DI\u2026NTEXT).plus(MATH_CONTEXT)");
        this.value = bigDecimal;
    }

    @NotNull
    public final Decimal times(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        BigDecimal bigDecimal = this.value.multiply(f.value, MATH_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.multiply(f.value, MATH_CONTEXT)");
        return new Decimal(bigDecimal);
    }

    public final void timesAssign(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        BigDecimal bigDecimal = this.value.multiply(f.value, MATH_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.multiply(f.value, MATH_CONTEXT)");
        this.value = bigDecimal;
    }

    @NotNull
    public final Decimal minus(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal bigDecimal = f.value.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"f.value.negate()");
            return new Decimal(bigDecimal);
        }
        if (f.value.compareTo(BigDecimal.ZERO) == 0) {
            return new Decimal(this.value);
        }
        BigDecimal bigDecimal = this.value.subtract(f.value, MATH_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.subtract(f.value, MATH_CONTEXT)");
        return new Decimal(bigDecimal);
    }

    public final void minusAssign(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal bigDecimal = f.value.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"f.value.negate()");
            this.value = bigDecimal;
        } else if (f.value.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal bigDecimal = this.value.subtract(f.value, MATH_CONTEXT);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.subtract(f.value, MATH_CONTEXT)");
            this.value = bigDecimal;
        }
    }

    @NotNull
    public final Decimal unaryMinus() {
        BigDecimal bigDecimal = this.value.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.negate()");
        return new Decimal(bigDecimal);
    }

    @NotNull
    public final Decimal rem(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        BigDecimal bigDecimal = this.value.remainder(f.value, MATH_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.remainder(f.value, MATH_CONTEXT)");
        return new Decimal(bigDecimal);
    }

    public final void remAssign(@NotNull Decimal f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        BigDecimal bigDecimal = this.value.remainder(f.value, MATH_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.remainder(f.value, MATH_CONTEXT)");
        this.value = bigDecimal;
    }

    @NotNull
    public final Decimal setScale(int v) {
        BigDecimal bigDecimal = this.value.setScale(v, RoundingMode.HALF_UP);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.setScale(v, RoundingMode.HALF_UP)");
        return new Decimal(bigDecimal);
    }

    @NotNull
    public final Decimal setScale(int v, int d) {
        BigDecimal bigDecimal = this.value.setScale(v, d);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.setScale(v, d)");
        return new Decimal(bigDecimal);
    }

    public final int getScale() {
        return this.value.scale();
    }

    public double toDouble() {
        return this.value.doubleValue();
    }

    @Override
    public int compareTo(@NotNull Decimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(other.value);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof Decimal && Intrinsics.areEqual((Object)this.value, (Object)((Decimal)other).value);
    }

    @NotNull
    public String toString() {
        Locale locale = Locale.GERMAN;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"GERMAN");
        return this.toString(locale);
    }

    @Override
    @NotNull
    public String toString(@NotNull Locale locale) {
        int n;
        String string;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string2 = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.toString()");
        String str = string2;
        int pos = 0;
        int dot = 0;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d2 = stringBuilder;
        boolean bl5 = false;
        if (str.charAt(0) == '-') {
            $this$toString_u24lambda_u2d2.append('-');
            pos = 1;
        }
        int n2 = StringsKt.indexOf$default((CharSequence)str, (char)'.', (int)0, (boolean)false, (int)6, null);
        int n3 = 0;
        int n4 = 0;
        int it = n2;
        boolean bl6 = false;
        dot = it;
        if (n2 == -1) {
            n2 = StringsKt.indexOf$default((CharSequence)str, (char)' ', (int)0, (boolean)false, (int)6, null);
            n3 = 0;
            n4 = 0;
            it = n2;
            boolean bl7 = false;
            dot = it;
            if (n2 == -1) {
                dot = str.length();
            }
        }
        if (dot - pos <= 3) {
            string = str;
            n3 = pos;
            n4 = dot;
            n = 0;
            String string3 = string.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            $this$toString_u24lambda_u2d2.append(string3);
            pos = dot;
        } else {
            n2 = (dot - pos) % 3;
            switch (n2) {
                case 1: {
                    String string4 = str;
                    n4 = pos;
                    n = pos + 1;
                    boolean bl8 = false;
                    String string5 = string4.substring(n4, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$toString_u24lambda_u2d2.append(string5);
                    ++pos;
                    break;
                }
                case 2: {
                    String string6 = str;
                    n4 = pos;
                    n = pos + 2;
                    boolean bl8 = false;
                    String string7 = string6.substring(n4, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$toString_u24lambda_u2d2.append(string7);
                    pos += 2;
                    break;
                }
                case 0: {
                    String string8 = str;
                    n4 = pos;
                    n = pos + 3;
                    boolean bl8 = false;
                    String string9 = string8.substring(n4, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$toString_u24lambda_u2d2.append(string9);
                    pos += 3;
                }
            }
            do {
                StringBuilder stringBuilder2 = $this$toString_u24lambda_u2d2.append(".");
                string = str;
                n3 = pos;
                n4 = pos + 3;
                n = 0;
                String string10 = string.substring(n3, n4);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                stringBuilder2.append(string10);
            } while (dot - (pos += 3) > 0);
        }
        if (str.length() > pos) {
            StringBuilder stringBuilder3 = $this$toString_u24lambda_u2d2.append(",");
            string = str;
            n3 = pos + 1;
            n4 = 0;
            String string11 = string.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.String).substring(startIndex)");
            stringBuilder3.append(string11);
        }
        String string12 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"StringBuilder().apply(builderAction).toString()");
        return string12;
    }

    @Override
    @NotNull
    public BigDecimal toSql() {
        return this.value;
    }

    public int toInt() {
        return this.value.intValue();
    }

    public long toLong() {
        return this.value.longValue();
    }

    public short toShort() {
        return this.value.shortValue();
    }

    public float toFloat() {
        return this.value.floatValue();
    }

    public byte toByte() {
        return this.value.byteValue();
    }

    public char toChar() {
        return this.value.toChar();
    }

    public int hashCode() {
        this.value.hashCode();
        int result = this.value.hashCode();
        result = 31 * result + this.maxScale;
        return result;
    }

    public final int getMaxScale() {
        return this.maxScale;
    }

    public final void setMaxScale(int n) {
        this.maxScale = n;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kopi/galite/visual/type/Decimal$Companion;", "", "()V", "DEFAULT", "Lorg/kopi/galite/visual/type/Decimal;", "getDEFAULT", "()Lorg/kopi/galite/visual/type/Decimal;", "DIV_CONTEXT", "Ljava/math/MathContext;", "MATH_CONTEXT", "serialVersionUID", "", "valueOf", "value", "", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Decimal valueOf(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Decimal(value);
        }

        @NotNull
        public final Decimal getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

