/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.base;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.server.Command;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B3\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\fH&J\u0006\u0010\u0016\u001a\u00020\fR\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/base/ShortcutAction;", "T", "Lcom/vaadin/flow/component/Component;", "Lcom/vaadin/flow/server/Command;", "field", "key", "Lcom/vaadin/flow/component/Key;", "modifiers", "", "Lcom/vaadin/flow/component/KeyModifier;", "navigationAction", "Lkotlin/Function0;", "", "(Lcom/vaadin/flow/component/Component;Lcom/vaadin/flow/component/Key;[Lcom/vaadin/flow/component/KeyModifier;Lkotlin/jvm/functions/Function0;)V", "getField", "()Lcom/vaadin/flow/component/Component;", "Lcom/vaadin/flow/component/Component;", "[Lcom/vaadin/flow/component/KeyModifier;", "getNavigationAction", "()Lkotlin/jvm/functions/Function0;", "execute", "performAction", "registerShortcut", "galite-core"})
public abstract class ShortcutAction<T extends Component>
implements Command {
    @NotNull
    private final T field;
    @NotNull
    private final Key key;
    @NotNull
    private final KeyModifier[] modifiers;
    @NotNull
    private final Function0<Unit> navigationAction;

    public ShortcutAction(@NotNull T field2, @NotNull Key key, @NotNull KeyModifier[] modifiers, @NotNull Function0<Unit> navigationAction) {
        Intrinsics.checkNotNullParameter(field2, (String)"field");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        Intrinsics.checkNotNullParameter(navigationAction, (String)"navigationAction");
        this.field = field2;
        this.key = key;
        this.modifiers = modifiers;
        this.navigationAction = navigationAction;
    }

    @NotNull
    protected final T getField() {
        return this.field;
    }

    @NotNull
    protected final Function0<Unit> getNavigationAction() {
        return this.navigationAction;
    }

    public void execute() {
        this.performAction();
    }

    public abstract void performAction();

    public final void registerShortcut() {
        KeyModifier[] keyModifierArray = this.modifiers;
        ShortcutRegistration shortcutRegistration = Shortcuts.addShortcutListener(this.field, (Command)this, (Key)this.key, (KeyModifier[])Arrays.copyOf(keyModifierArray, keyModifierArray.length));
        keyModifierArray = new Component[]{this.field};
        ShortcutRegistration registration2 = shortcutRegistration.listenOn((Component[])keyModifierArray);
        registration2.setBrowserDefaultAllowed(false);
    }
}

