/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.block;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.field.Field;
import org.kopi.galite.visual.ui.vaadin.field.FieldListener;
import org.kopi.galite.visual.ui.vaadin.form.DBlock;
import org.kopi.galite.visual.ui.vaadin.label.Label;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0014J\u000e\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u0006J\u0006\u00101\u001a\u00020-J\u0006\u00102\u001a\u00020\"J\u0006\u00103\u001a\u00020-J\u0006\u00104\u001a\u00020-J\u0006\u00105\u001a\u00020-J\u0010\u00106\u001a\u0004\u0018\u00010\u000b2\u0006\u00107\u001a\u00020\u0006J\u0010\u00108\u001a\u0004\u0018\u00010\u00142\u0006\u00107\u001a\u00020\u0006J\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010;\u001a\u0004\u0018\u00010\u000b2\u0006\u00107\u001a\u00020\u0006J\u000e\u0010<\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006J\u0010\u0010=\u001a\u0004\u0018\u00010\u000b2\u0006\u0010>\u001a\u00020\u0006J\u0010\u0010?\u001a\u0004\u0018\u00010\u000b2\u0006\u00107\u001a\u00020\u0006J\u0006\u0010@\u001a\u00020-J\u0006\u0010A\u001a\u00020-J\u0006\u0010B\u001a\u00020-J\u0006\u0010C\u001a\u00020-J\u0006\u0010D\u001a\u00020-J\u0006\u0010E\u001a\u00020-J\u0006\u0010F\u001a\u00020-J\u0006\u0010G\u001a\u00020\"J\u0006\u0010H\u001a\u00020\"J\u0006\u0010I\u001a\u00020\"J\u000e\u0010J\u001a\u00020-2\u0006\u00100\u001a\u00020\u0006J\u000e\u0010K\u001a\u00020-2\u0006\u00100\u001a\u00020\u0006J\u0006\u0010L\u001a\u00020\"J\u0006\u0010M\u001a\u00020\"J\u000e\u0010N\u001a\u00020-2\u0006\u0010O\u001a\u00020\u0006J\u000e\u0010P\u001a\u00020-2\u0006\u0010Q\u001a\u00020\"J\u0006\u0010R\u001a\u00020-J\u000e\u0010R\u001a\u00020-2\u0006\u00100\u001a\u00020\u0006J\u0018\u0010S\u001a\u00020-2\u0006\u0010>\u001a\u00020\u00062\b\u0010T\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010U\u001a\u00020-2\u0006\u00107\u001a\u00020\u0006J\u000e\u0010V\u001a\u00020-2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010W\u001a\u00020-2\u0006\u0010>\u001a\u00020\u00062\b\u0010T\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010X\u001a\u00020-2\u0006\u00100\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020\"J\u0016\u0010Z\u001a\u00020-2\u0006\u00100\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020\"J\u0018\u0010[\u001a\u00020-2\u0006\u0010>\u001a\u00020\u00062\b\u0010\\\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010]\u001a\u00020-J\u0006\u0010^\u001a\u00020-J\b\u0010_\u001a\u00020-H\u0004J\u000e\u0010_\u001a\u00020-2\u0006\u0010>\u001a\u00020\u0006J\u0006\u0010`\u001a\u00020-J\u000e\u0010`\u001a\u00020-2\u0006\u0010>\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0018\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u001e\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0011\u0010$\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010#R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0011\u0010&\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010#R\u0011\u0010'\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R\u001c\u0010(\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0018\"\u0004\b*\u0010\u001aR\u0018\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006a"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/ColumnView;", "", "block", "Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;", "(Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;)V", "access", "", "getAccess", "()I", "bgColors", "", "", "[Ljava/lang/String;", "getBlock", "()Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;", "blockActiveRecord", "getBlockActiveRecord", "blockOldActiveRecord", "getBlockOldActiveRecord", "detailDisplay", "Lorg/kopi/galite/visual/ui/vaadin/field/Field;", "detailLabel", "Lorg/kopi/galite/visual/ui/vaadin/label/Label;", "getDetailLabel", "()Lorg/kopi/galite/visual/ui/vaadin/label/Label;", "setDetailLabel", "(Lorg/kopi/galite/visual/ui/vaadin/label/Label;)V", "displays", "[Lorg/kopi/galite/visual/ui/vaadin/field/Field;", "fgColors", "<set-?>", "index", "getIndex", "isBlockActiveField", "", "()Z", "isBlockActiveFieldNull", "isDirty", "isMultiBlock", "isNull", "label", "getLabel", "setLabel", "values", "addField", "", "field", "checkValue", "rec", "cleanDirtyValues", "delegateNavigationToServer", "disableAllBlocksActors", "disableBlockActors", "enter", "getBackgroundColorAt", "displayLine", "getField", "getFieldListener", "Lorg/kopi/galite/visual/ui/vaadin/field/FieldListener;", "getForegroundColorAt", "getRecordFromDisplayLine", "getRecordValueAt", "record", "getValueAt", "gotoFirstRecord", "gotoLastRecord", "gotoNextEmptyMustfill", "gotoNextField", "gotoNextRecord", "gotoPrevField", "gotoPrevRecord", "hasAction", "hasAutofill", "hasPreFieldTrigger", "leave", "maybeHasDirtyValues", "noChart", "noDetail", "scrollTo", "toprec", "setActorsEnabled", "enabled", "setAsActiveField", "setBackgroundColorAt", "color", "setBlockActiveRecordFromDisplayLine", "setDetailDisplay", "setForegroundColorAt", "setRecordChanged", "val", "setRecordFetched", "setValueAt", "newValue", "transferFocus", "unsetAsActiveField", "updateColor", "updateValue", "galite-core"})
public final class ColumnView {
    @NotNull
    private final DBlock block;
    @Nullable
    private Label label;
    @Nullable
    private Label detailLabel;
    @Nullable
    private Field detailDisplay;
    @NotNull
    private Field[] displays;
    @NotNull
    private String[] values;
    @NotNull
    private String[] fgColors;
    @NotNull
    private String[] bgColors;
    private int index;

    public ColumnView(@NotNull DBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.block = block;
        this.displays = new Field[this.block.getDisplaySize()];
        this.values = new String[this.block.getBufferSize()];
        this.fgColors = new String[this.block.getBufferSize()];
        this.bgColors = new String[this.block.getBufferSize()];
        this.index = -1;
    }

    @NotNull
    public final DBlock getBlock() {
        return this.block;
    }

    @Nullable
    public final Label getLabel() {
        return this.label;
    }

    public final void setLabel(@Nullable Label label) {
        this.label = label;
    }

    @Nullable
    public final Label getDetailLabel() {
        return this.detailLabel;
    }

    public final void setDetailLabel(@Nullable Label label) {
        this.detailLabel = label;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setDetailDisplay(@NotNull Field detailDisplay) {
        Intrinsics.checkNotNullParameter((Object)detailDisplay, (String)"detailDisplay");
        Field field2 = this.detailDisplay = detailDisplay;
        Intrinsics.checkNotNull((Object)field2);
        field2.setColumnView(this);
        if (this.index == -1) {
            this.index = detailDisplay.getIndex();
        }
    }

    public final void addField(@NotNull Field field2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        this.displays[field2.getPosition()] = field2;
        field2.setColumnView(this);
        this.index = field2.getIndex();
    }

    @Nullable
    public final Field getField(int displayLine) {
        return displayLine != -1 ? this.displays[displayLine] : (Field)null;
    }

    public final boolean hasPreFieldTrigger() {
        if (this.block.inDetailMode()) {
            if (this.detailDisplay != null) {
                Field field2 = this.detailDisplay;
                Intrinsics.checkNotNull((Object)field2);
                return field2.getHasPreFieldTrigger();
            }
        } else if (this.block.getDisplayLine() != -1) {
            Field field3 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field3);
            return field3.getHasPreFieldTrigger();
        }
        return false;
    }

    public final int getAccess() {
        if (this.block.inDetailMode()) {
            if (this.detailDisplay != null) {
                Field field2 = this.detailDisplay;
                Intrinsics.checkNotNull((Object)field2);
                return field2.getAccess(this.block.getActiveRecord());
            }
        } else if (this.block.getDisplayLine() != -1) {
            Field field3 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field3);
            return field3.getAccess(this.block.getActiveRecord());
        }
        return 0;
    }

    public final boolean hasAction() {
        if (this.block.inDetailMode()) {
            if (this.detailDisplay != null) {
                Field field2 = this.detailDisplay;
                Intrinsics.checkNotNull((Object)field2);
                return field2.getHasAction();
            }
        } else if (this.block.getDisplayLine() != -1) {
            Field field3 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field3);
            return field3.getHasAction();
        }
        return false;
    }

    public final boolean noChart() {
        boolean bl;
        if (this.block.getDisplayLine() != -1) {
            Field field2 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field2);
            bl = field2.getNoChart();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean noDetail() {
        boolean bl;
        if (this.block.getDisplayLine() != -1) {
            Field field2 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field2);
            bl = field2.getNoDetail();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean delegateNavigationToServer() {
        return true;
    }

    public final void transferFocus() {
        if (this.getFieldListener() != null) {
            FieldListener fieldListener = this.getFieldListener();
            Intrinsics.checkNotNull((Object)fieldListener);
            fieldListener.transferFocus();
        }
    }

    @Nullable
    public final FieldListener getFieldListener() {
        if (this.block.inDetailMode()) {
            if (this.detailDisplay != null) {
                return this.detailDisplay;
            }
        } else if (this.block.getDisplayLine() != -1) {
            return this.displays[this.block.getDisplayLine()];
        }
        return null;
    }

    public final void leave(int rec) {
        if (this.block.inDetailMode()) {
            if (this.detailDisplay != null) {
                Field field2 = this.detailDisplay;
                Intrinsics.checkNotNull((Object)field2);
                field2.leave(rec);
            }
        } else if (this.block.getDisplayLine() != -1) {
            Field field3 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field3);
            field3.leave(rec);
        }
    }

    public final void enter() {
        if (this.block.inDetailMode()) {
            if (this.detailDisplay != null) {
                Field field2 = this.detailDisplay;
                Intrinsics.checkNotNull((Object)field2);
                field2.enter();
            }
        } else if (this.block.getDisplayLine() != -1) {
            Field field3 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field3);
            field3.enter();
        }
    }

    public final boolean isNull() {
        boolean bl;
        if (this.block.getDisplayLine() != -1) {
            Field field2 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field2);
            bl = field2.isNull();
        } else {
            bl = true;
        }
        return bl;
    }

    public final void cleanDirtyValues() {
        if (this.displays == null) {
            return;
        }
        for (Field field2 : this.displays) {
            if (field2 == null || !field2.isDirty()) continue;
            field2.cleanDirtyValues();
        }
        if (this.detailDisplay != null) {
            Field field3 = this.detailDisplay;
            Intrinsics.checkNotNull((Object)field3);
            if (field3.isDirty()) {
                Field field4 = this.detailDisplay;
                Intrinsics.checkNotNull((Object)field4);
                field4.cleanDirtyValues();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDirty() {
        if (this.displays == null) {
            return false;
        }
        for (Field field2 : this.displays) {
            if (field2 == null || !field2.isDirty()) continue;
            return true;
        }
        if (this.detailDisplay == null) return false;
        Field field3 = this.detailDisplay;
        Intrinsics.checkNotNull((Object)field3);
        if (!field3.isDirty()) return false;
        return true;
    }

    public final void updateValue() {
        Field field2;
        if (this.block.getDisplayLine() != -1) {
            Field field3 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field3);
            field3.updateValue();
        }
        if ((field2 = this.detailDisplay) != null) {
            field2.updateValue();
        }
    }

    protected final void updateColor() {
        Field field2;
        if (this.block.getDisplayLine() != -1) {
            Field field3 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field3);
            field3.updateColor();
        }
        if ((field2 = this.detailDisplay) != null) {
            field2.updateColor();
        }
    }

    public final void updateValue(int record) {
        Field field2;
        int displayLine = this.block.getDisplayLine(record);
        if (displayLine != -1) {
            Field field3 = this.displays[displayLine];
            Intrinsics.checkNotNull((Object)field3);
            field3.updateValue();
        }
        if ((field2 = this.detailDisplay) != null) {
            field2.updateValue();
        }
    }

    public final void updateColor(int record) {
        Field field2;
        int displayLine = this.block.getDisplayLine(record);
        if (displayLine != -1) {
            Field field3 = this.displays[displayLine];
            Intrinsics.checkNotNull((Object)field3);
            field3.updateColor();
        }
        if ((field2 = this.detailDisplay) != null) {
            field2.updateColor();
        }
    }

    public final void checkValue(int rec) {
        if (this.block.inDetailMode()) {
            if (this.detailDisplay != null) {
                Field field2 = this.detailDisplay;
                Intrinsics.checkNotNull((Object)field2);
                field2.checkValue(rec);
            }
        } else if (this.block.getDisplayLine() != -1) {
            Field field3 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field3);
            if (field3.isChanged()) {
                Field field4 = this.displays[this.block.getDisplayLine()];
                Intrinsics.checkNotNull((Object)field4);
                field4.checkValue(rec);
            }
        }
    }

    public final void maybeHasDirtyValues(int rec) {
        if (this.block.inDetailMode()) {
            Field field2 = this.detailDisplay;
            if (field2 != null) {
                field2.markAsDirty(rec);
            }
        } else if (this.block.getDisplayLine() != -1) {
            Field field3 = this.displays[this.block.getDisplayLine()];
            Intrinsics.checkNotNull((Object)field3);
            if (field3.isChanged()) {
                Field field4 = this.displays[this.block.getDisplayLine()];
                Intrinsics.checkNotNull((Object)field4);
                field4.markAsDirty(rec);
            }
        }
    }

    public final void setValueAt(int record, @Nullable String newValue) {
        String newValue2 = newValue;
        String oldValue = null;
        oldValue = this.values[record];
        if (oldValue == null) {
            oldValue = "";
        }
        if (newValue2 == null) {
            newValue2 = "";
        }
        if (!Intrinsics.areEqual((Object)newValue2, (Object)oldValue)) {
            this.values[record] = newValue2;
            this.setRecordChanged(record, true);
        }
    }

    public final void setForegroundColorAt(int record, @Nullable String color) {
        this.fgColors[record] = color;
    }

    public final void setBackgroundColorAt(int record, @Nullable String color) {
        this.bgColors[record] = color;
    }

    @Nullable
    public final String getValueAt(int displayLine) {
        return this.values[this.getRecordFromDisplayLine(displayLine)];
    }

    @Nullable
    public final String getForegroundColorAt(int displayLine) {
        return this.fgColors[this.getRecordFromDisplayLine(displayLine)];
    }

    @Nullable
    public final String getBackgroundColorAt(int displayLine) {
        return this.bgColors[this.getRecordFromDisplayLine(displayLine)];
    }

    public final int getRecordFromDisplayLine(int displayLine) {
        return this.block != null ? this.block.getRecordFromDisplayLine(displayLine) : -1;
    }

    @Nullable
    public final String getRecordValueAt(int record) {
        Intrinsics.checkNotNull((Object)this.values);
        return this.values[record];
    }

    public final void scrollTo(int toprec) {
        if (this.displays == null) {
            return;
        }
        for (Field field2 : this.displays) {
            if (field2 == null) continue;
            field2.updateValue();
            field2.updateColor();
        }
        if (this.detailDisplay != null) {
            int dispLine;
            int record = this.block.getActiveRecord();
            int n = dispLine = record >= 0 ? this.block.getDisplayLine(record) : 0;
            if (dispLine < 0) {
                dispLine = 0;
            }
            Field field3 = this.detailDisplay;
            Intrinsics.checkNotNull((Object)field3);
            field3.setPosition(dispLine);
            Field field4 = this.detailDisplay;
            Intrinsics.checkNotNull((Object)field4);
            field4.updateValue();
            Field field5 = this.detailDisplay;
            Intrinsics.checkNotNull((Object)field5);
            field5.updateColor();
        }
    }

    public final void setAsActiveField() {
        this.setAsActiveField(-1);
    }

    public final void setAsActiveField(int rec) {
        if (this.block != null) {
            this.block.setActiveField(this);
            if (rec != -1) {
                this.block.setActiveRecord(rec);
            }
        }
    }

    public final void unsetAsActiveField() {
        if (this.block != null) {
            this.block.setActiveField(null);
        }
    }

    public final boolean isBlockActiveField() {
        return Intrinsics.areEqual((Object)this.block.getActiveField(), (Object)this);
    }

    public final boolean isBlockActiveFieldNull() {
        return this.block.getActiveField() == null;
    }

    public final int getBlockActiveRecord() {
        return this.block.getActiveRecord();
    }

    public final int getBlockOldActiveRecord() {
        return this.block.getOldActiveRecord();
    }

    public final void gotoNextField() {
        if (this.block != null) {
            this.block.gotoNextField();
        }
    }

    public final void gotoPrevField() {
        if (this.block != null) {
            this.block.gotoPrevField();
        }
    }

    public final void gotoNextEmptyMustfill() {
        if (this.block != null) {
            this.block.gotoNextEmptyMustfill();
        }
    }

    public final void gotoNextRecord() {
        if (this.block != null) {
            this.block.gotoNextRecord();
        }
    }

    public final void gotoPrevRecord() {
        if (this.block != null) {
            this.block.gotoPrevRecord();
        }
    }

    public final void gotoFirstRecord() {
        if (this.block != null) {
            this.block.gotoFirstRecord();
        }
    }

    public final void gotoLastRecord() {
        if (this.block != null) {
            this.block.gotoLastRecord();
        }
    }

    public final void setRecordChanged(int rec, boolean val) {
        if (this.block != null) {
            this.block.setRecordChanged(rec, val);
        }
    }

    public final void setRecordFetched(int rec, boolean val) {
        if (this.block != null) {
            this.block.setRecordFetched(rec, val);
        }
    }

    public final void setBlockActiveRecordFromDisplayLine(int displayLine) {
        if (this.block != null) {
            this.block.setActiveRecordFromDisplay(displayLine);
        }
    }

    public final boolean isMultiBlock() {
        return this.block == null ? false : this.block.isMulti();
    }

    public final boolean hasAutofill() {
        boolean hasAutofill = false;
        hasAutofill = false;
        if (this.label != null) {
            Label label = this.label;
            Intrinsics.checkNotNull((Object)((Object)label));
            hasAutofill |= label.getHasAction();
        }
        if (this.detailLabel != null) {
            Label label = this.detailLabel;
            Intrinsics.checkNotNull((Object)((Object)label));
            hasAutofill |= label.getHasAction();
        }
        return hasAutofill;
    }

    public final void setActorsEnabled(boolean enabled) {
        if (this.displays == null) {
            return;
        }
        for (Field display : this.displays) {
            Field field2 = display;
            if (field2 == null) continue;
            field2.setActionEnabled(enabled);
        }
        Field field3 = this.detailDisplay;
        if (field3 != null) {
            field3.setActionEnabled(enabled);
        }
    }

    public final void disableBlockActors() {
        if (this.block != null) {
            this.block.setColumnViewsActorsEnabled(false);
        }
    }

    public final void disableAllBlocksActors() {
        this.block.getParent().getContent().disableAllBlocksActors();
    }
}

