/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.block;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.ui.vaadin.block.AbstractBlockLayout;
import org.kopi.galite.visual.ui.vaadin.block.AlignPanel;
import org.kopi.galite.visual.ui.vaadin.block.BlockAlignment;
import org.kopi.galite.visual.ui.vaadin.block.ColumnView;
import org.kopi.galite.visual.ui.vaadin.block.ComponentConstraint;
import org.kopi.galite.visual.ui.vaadin.block.LayoutManager;
import org.kopi.galite.visual.ui.vaadin.field.Field;
import org.kopi.galite.visual.ui.vaadin.form.DActorField;
import org.kopi.galite.visual.ui.vaadin.form.DBlock;
import org.kopi.galite.visual.ui.vaadin.form.DField;
import org.kopi.galite.visual.ui.vaadin.form.DGridMultiBlock;
import org.kopi.galite.visual.ui.vaadin.label.Label;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016JB\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\"\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0004J\u0006\u0010\u001f\u001a\u00020\u001bJ\b\u0010 \u001a\u00020\u0012H\u0016J\u0018\u0010!\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0004J\u0018\u0010#\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u000eH\u0004J\b\u0010(\u001a\u00020\u0012H\u0014J\u0018\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0016J\b\u0010+\u001a\u00020\u0012H\u0016J \u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001bH\u0016J(\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u0003H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/SimpleBlockLayout;", "Lorg/kopi/galite/visual/ui/vaadin/block/AbstractBlockLayout;", "col", "", "line", "(II)V", "align", "Lorg/kopi/galite/visual/ui/vaadin/block/BlockAlignment;", "getAlign", "()Lorg/kopi/galite/visual/ui/vaadin/block/BlockAlignment;", "setAlign", "(Lorg/kopi/galite/visual/ui/vaadin/block/BlockAlignment;)V", "follows", "", "Lcom/vaadin/flow/component/Component;", "followsAligns", "Lorg/kopi/galite/visual/ui/vaadin/block/ComponentConstraint;", "add", "", "component", "constraints", "addComponent", "x", "y", "width", "height", "alignRight", "", "useAll", "addInfoComponentAt", "info", "blockInDetailMode", "clear", "getAllocatedHeight", "row", "getAllocatedWidth", "getBlock", "Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;", "getComponentHeight", "comp", "initSize", "columns", "rows", "layout", "setBlockAlignment", "original", "targets", "", "isChart", "updateScroll", "pageSize", "maxValue", "enable", "value", "galite-core"})
public class SimpleBlockLayout
extends AbstractBlockLayout {
    @Nullable
    private BlockAlignment align;
    @Nullable
    private List<Component> follows;
    @Nullable
    private List<ComponentConstraint> followsAligns;

    public SimpleBlockLayout(int col, int line) {
        super(col, line);
        this.setClassName("simple");
        this.initSize();
    }

    @Nullable
    public final BlockAlignment getAlign() {
        return this.align;
    }

    public final void setAlign(@Nullable BlockAlignment blockAlignment) {
        this.align = blockAlignment;
    }

    @Override
    protected void initSize() {
        this.initSize(this.getCol(), this.getLine());
    }

    @Override
    public void initSize(int columns, int rows) {
        super.initSize(columns, rows);
        this.follows = new ArrayList();
        this.followsAligns = new ArrayList();
    }

    @Override
    public void addComponent(@Nullable Component component, int x, int y, int width, int height, boolean alignRight, boolean useAll) {
        ComponentConstraint constraints = new ComponentConstraint(x, y, width, height, alignRight, useAll);
        if (this.getParent().get() instanceof DGridMultiBlock) {
            this.getBlock().setLayoutBelongsToGridDetail(true);
            if (component != null && component instanceof DField) {
                ColumnView columnView;
                ColumnView columnView2;
                boolean bl;
                boolean bl2;
                ColumnView columnView3;
                if (constraints.getWidth() < 0 || component instanceof DActorField) {
                    columnView3 = new ColumnView(this.getBlock());
                    bl2 = false;
                    bl = false;
                    columnView2 = columnView3;
                    boolean bl3 = false;
                    columnView2.setLabel(null);
                    columnView2.addField((Field)component);
                    if (this.blockInDetailMode()) {
                        columnView2.setDetailLabel(null);
                        columnView2.setDetailDisplay((Field)component);
                    }
                    columnView = columnView3;
                } else {
                    columnView3 = new ColumnView(this.getBlock());
                    bl2 = false;
                    bl = false;
                    columnView2 = columnView3;
                    boolean bl4 = false;
                    columnView2.setLabel(((DField)component).getLabel$galite_core());
                    if (this.blockInDetailMode()) {
                        columnView2.setDetailLabel(((DField)component).getLabel$galite_core());
                    }
                    columnView2.addField((Field)component);
                    if (this.blockInDetailMode()) {
                        columnView2.setDetailDisplay((Field)component);
                    }
                    columnView = columnView3;
                }
                ColumnView columnView4 = columnView;
                this.getBlock().addField(columnView4);
            }
        } else if (component != null) {
            if (component instanceof FormLayout.FormItem) {
                Component[][] componentArray = this.getComponents();
                Intrinsics.checkNotNull((Object)componentArray);
                componentArray[x][y] = component;
            } else if (component instanceof DField) {
                ColumnView columnView;
                ColumnView columnView5;
                boolean bl;
                boolean bl5;
                ColumnView columnView6;
                this.add(component, constraints);
                if (constraints.getWidth() < 0 || component instanceof DActorField) {
                    columnView6 = new ColumnView(this.getBlock());
                    bl5 = false;
                    bl = false;
                    columnView5 = columnView6;
                    boolean bl6 = false;
                    columnView5.setLabel(null);
                    columnView5.addField((Field)component);
                    if (this.blockInDetailMode()) {
                        columnView5.setDetailLabel(null);
                        columnView5.setDetailDisplay((Field)component);
                    }
                    columnView = columnView6;
                } else {
                    columnView6 = new ColumnView(this.getBlock());
                    bl5 = false;
                    bl = false;
                    columnView5 = columnView6;
                    boolean bl7 = false;
                    columnView5.setLabel(((DField)component).getLabel$galite_core());
                    if (this.blockInDetailMode()) {
                        columnView5.setDetailLabel(((DField)component).getLabel$galite_core());
                    }
                    columnView5.addField((Field)component);
                    if (this.blockInDetailMode()) {
                        columnView5.setDetailDisplay((Field)component);
                    }
                    columnView = columnView6;
                }
                ColumnView columnView7 = columnView;
                this.getBlock().addField(columnView7);
            } else if (component instanceof Label) {
                this.add(component, constraints);
            }
        }
        if (component instanceof Grid) {
            this.add(component, constraints);
        }
    }

    @Override
    public void add(@Nullable Component component, @NotNull ComponentConstraint constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        if (this.align == null) {
            if (constraints.getWidth() < 0) {
                List<Component> list = this.follows;
                Intrinsics.checkNotNull(list);
                Component component2 = component;
                Intrinsics.checkNotNull((Object)component2);
                list.add(component2);
                List<ComponentConstraint> list2 = this.followsAligns;
                Intrinsics.checkNotNull(list2);
                list2.add(constraints);
            } else {
                ComponentConstraint[][] componentConstraintArray = this.getAligns();
                Intrinsics.checkNotNull((Object)componentConstraintArray);
                componentConstraintArray[constraints.getX()][constraints.getY()] = constraints;
                Component[][] componentArray = this.getComponents();
                Intrinsics.checkNotNull((Object)componentArray);
                componentArray[constraints.getX()][constraints.getY()] = component;
            }
        } else {
            if (component == null) {
                return;
            }
            BlockAlignment blockAlignment = this.align;
            Intrinsics.checkNotNull((Object)blockAlignment);
            ComponentConstraint newConstraint = new ComponentConstraint(blockAlignment.getTargetPos$galite_core(constraints.getX()), constraints.getY(), constraints.getWidth(), constraints.getHeight(), constraints.getAlignRight(), constraints.getUseAll());
            this.addAlignedComponent(component, newConstraint);
        }
    }

    @Override
    public void layout() {
        if (this.align != null) {
            return;
        }
        LayoutManager manager = new LayoutManager(this);
        int n = 0;
        Component[][] componentArray = this.getComponents();
        Intrinsics.checkNotNull((Object)componentArray);
        int n2 = componentArray[0].length + -1;
        if (n <= n2) {
            do {
                int y = n++;
                int n3 = 0;
                Component[][] componentArray2 = this.getComponents();
                Intrinsics.checkNotNull((Object)componentArray2);
                int n4 = ((Object[])componentArray2).length + -1;
                if (n3 > n4) continue;
                do {
                    int x = n3++;
                    Component[][] componentArray3 = this.getComponents();
                    Intrinsics.checkNotNull((Object)componentArray3);
                    if (componentArray3[x][y] == null) continue;
                    ComponentConstraint[][] componentConstraintArray = this.getAligns();
                    Intrinsics.checkNotNull((Object)componentConstraintArray);
                    if (componentConstraintArray[x][y] == null) continue;
                    Component[][] componentArray4 = this.getComponents();
                    Intrinsics.checkNotNull((Object)componentArray4);
                    Component component = componentArray4[x][y];
                    Intrinsics.checkNotNull((Object)component);
                    ComponentConstraint[][] componentConstraintArray2 = this.getAligns();
                    Intrinsics.checkNotNull((Object)componentConstraintArray2);
                    ComponentConstraint componentConstraint = componentConstraintArray2[x][y];
                    Intrinsics.checkNotNull((Object)componentConstraint);
                    ComponentConstraint[][] componentConstraintArray3 = this.getAligns();
                    Intrinsics.checkNotNull((Object)componentConstraintArray3);
                    ComponentConstraint componentConstraint2 = componentConstraintArray3[x][y];
                    Intrinsics.checkNotNull((Object)componentConstraint2);
                    int n5 = RangesKt.coerceAtMost((int)componentConstraint2.getWidth(), (int)this.getAllocatedWidth(x, y));
                    ComponentConstraint[][] componentConstraintArray4 = this.getAligns();
                    Intrinsics.checkNotNull((Object)componentConstraintArray4);
                    ComponentConstraint componentConstraint3 = componentConstraintArray4[x][y];
                    Intrinsics.checkNotNull((Object)componentConstraint3);
                    manager.setComponent(component, componentConstraint, n5, RangesKt.coerceAtMost((int)componentConstraint3.getHeight(), (int)this.getAllocatedHeight(x, y)));
                    ComponentConstraint[][] componentConstraintArray5 = this.getAligns();
                    Intrinsics.checkNotNull((Object)componentConstraintArray5);
                    ComponentConstraint componentConstraint4 = componentConstraintArray5[x][y];
                    Intrinsics.checkNotNull((Object)componentConstraint4);
                    int n6 = componentConstraint4.getY();
                    ComponentConstraint[][] componentConstraintArray6 = this.getAligns();
                    Intrinsics.checkNotNull((Object)componentConstraintArray6);
                    ComponentConstraint componentConstraint5 = componentConstraintArray6[x][y];
                    Intrinsics.checkNotNull((Object)componentConstraint5);
                    int n7 = componentConstraint5.getX();
                    ComponentConstraint[][] componentConstraintArray7 = this.getAligns();
                    Intrinsics.checkNotNull((Object)componentConstraintArray7);
                    ComponentConstraint componentConstraint6 = componentConstraintArray7[x][y];
                    Intrinsics.checkNotNull((Object)componentConstraint6);
                    this.setAlignment(n6, n7, componentConstraint6.getAlignRight());
                } while (n3 <= n4);
            } while (n <= n2);
        }
        manager.layout$galite_core();
        n = 0;
        List<Component> list = this.follows;
        Intrinsics.checkNotNull(list);
        n2 = list.size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                List<ComponentConstraint> list2 = this.followsAligns;
                Intrinsics.checkNotNull(list2);
                ComponentConstraint align = list2.get(i);
                List<Component> list3 = this.follows;
                Intrinsics.checkNotNull(list3);
                Component comp = list3.get(i);
                this.addInfoComponentAt(comp, align.getX(), align.getY());
            } while (n <= n2);
        }
    }

    protected final void addInfoComponentAt(@Nullable Component info, int x, int y) {
        Component[][] componentArray = this.getComponents();
        Intrinsics.checkNotNull((Object)componentArray);
        Component component = componentArray[x][y];
        Intrinsics.checkNotNull((Object)component);
        Iterator iterator = component.getChildren().iterator();
        if (iterator.hasNext()) {
            Component field2 = (Component)iterator.next();
            Component[] componentArray2 = new Component[]{field2, info};
            HorizontalLayout content = new HorizontalLayout(componentArray2);
            content.setClassName("info-content");
            Component[] componentArray3 = new Component[]{(Component)content};
            Component[] componentArray4 = componentArray3;
            FormLayout.FormItem formItem2 = new FormLayout.FormItem(componentArray4){};
            Component component2 = (Component)content;
            ComponentConstraint[][] componentConstraintArray = this.getAligns();
            Intrinsics.checkNotNull((Object)componentConstraintArray);
            ComponentConstraint componentConstraint = componentConstraintArray[x][y];
            Intrinsics.checkNotNull((Object)componentConstraint);
            int n = componentConstraint.getX();
            ComponentConstraint[][] componentConstraintArray2 = this.getAligns();
            Intrinsics.checkNotNull((Object)componentConstraintArray2);
            ComponentConstraint componentConstraint2 = componentConstraintArray2[x][y];
            Intrinsics.checkNotNull((Object)componentConstraint2);
            int n2 = componentConstraint2.getY();
            ComponentConstraint[][] componentConstraintArray3 = this.getAligns();
            Intrinsics.checkNotNull((Object)componentConstraintArray3);
            ComponentConstraint componentConstraint3 = componentConstraintArray3[x][y];
            Intrinsics.checkNotNull((Object)componentConstraint3);
            int n3 = RangesKt.coerceAtMost((int)componentConstraint3.getWidth(), (int)this.getAllocatedWidth(x, y));
            Component[][] componentArray5 = this.getComponents();
            Intrinsics.checkNotNull((Object)componentArray5);
            Component component3 = componentArray5[x][y];
            Intrinsics.checkNotNull((Object)component3);
            int n4 = this.getComponentHeight(component3);
            Component component4 = info;
            Intrinsics.checkNotNull((Object)component4);
            this.setComponent(component2, n, n2, n3, RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)n4, (int)this.getComponentHeight(component4)), (int)this.getAllocatedHeight(x, y)));
        }
    }

    protected final int getComponentHeight(@NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        return comp instanceof VField ? ((VField)comp).getHeight() : 1;
    }

    protected final int getAllocatedHeight(int col, int row) {
        int allocatedHeight = 1;
        int n = row + 1;
        Component[][] componentArray = this.getComponents();
        Intrinsics.checkNotNull((Object)componentArray);
        int n2 = componentArray[col].length;
        if (n < n2) {
            do {
                int y = n++;
                Component[][] componentArray2 = this.getComponents();
                Intrinsics.checkNotNull((Object)componentArray2);
                if (componentArray2[col][y] != null) break;
                int n3 = allocatedHeight;
                allocatedHeight = n3 + 1;
            } while (n < n2);
        }
        return allocatedHeight;
    }

    private final int getAllocatedWidth(int col, int row) {
        int allocatedWidth = 1;
        int n = col + 1;
        Component[][] componentArray = this.getComponents();
        Intrinsics.checkNotNull((Object)componentArray);
        int n2 = ((Object[])componentArray).length;
        if (n < n2) {
            do {
                int x = n++;
                Component[][] componentArray2 = this.getComponents();
                Intrinsics.checkNotNull((Object)componentArray2);
                if (componentArray2[x][row] != null) break;
                int n3 = allocatedWidth;
                allocatedWidth = n3 + 1;
            } while (n < n2);
        }
        return allocatedWidth;
    }

    @NotNull
    public final DBlock getBlock() {
        return (DBlock)this.getParent().get();
    }

    public final boolean blockInDetailMode() {
        return this.getBlock().getNoChart();
    }

    @Override
    public void clear() {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void updateScroll(int pageSize, int maxValue, boolean enable, int value) {
    }

    public void setBlockAlignment(@NotNull Component original, @NotNull int[] targets, boolean isChart) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        BlockAlignment blockAlignment = this.align = new BlockAlignment();
        Intrinsics.checkNotNull((Object)blockAlignment);
        blockAlignment.setChart(isChart);
        BlockAlignment blockAlignment2 = this.align;
        Intrinsics.checkNotNull((Object)blockAlignment2);
        blockAlignment2.setTargets(targets);
        BlockAlignment blockAlignment3 = this.align;
        Intrinsics.checkNotNull((Object)blockAlignment3);
        blockAlignment3.setOri(original);
        this.setAlignPane(new AlignPanel(this.align));
    }
}

