/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.ui.vaadin.field.AllowAllValidator;
import org.kopi.galite.visual.ui.vaadin.field.CheckTypeException;
import org.kopi.galite.visual.ui.vaadin.field.InputTextField;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/DateValidator;", "Lorg/kopi/galite/visual/ui/vaadin/field/AllowAllValidator;", "maxLength", "", "(I)V", "checkType", "", "field", "Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "text", "", "parseDate", "f", "s", "validate", "", "c", "", "Companion", "galite-core"})
public final class DateValidator
extends AllowAllValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DateValidator(int maxLength) {
        super(maxLength);
    }

    @Override
    public boolean validate(char c) {
        return ('0' <= c ? c <= '9' : false) || c == '.' || c == '/';
    }

    @Override
    public void checkType(@NotNull InputTextField<?> field2, @NotNull String text) {
        Intrinsics.checkNotNullParameter(field2, (String)"field");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)"", (Object)text)) {
            field2.setValue(null);
        } else {
            this.parseDate(field2, text);
        }
    }

    private final void parseDate(InputTextField<?> f, String s) {
        Date now;
        String[] tokens;
        String[] $this$toTypedArray$iv;
        int day = 0;
        int month = 0;
        int year = -2;
        Object object = s;
        String string = "#|\\.|/";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        object = string.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$toTypedArray$iv = tokens = stringArray;
        boolean bl2 = false;
        if ($this$toTypedArray$iv.length == 0) {
            throw new CheckTypeException(f, "00003");
        }
        day = DateValidator.Companion.stringToInt(tokens[0]);
        if (tokens.length >= 2) {
            month = DateValidator.Companion.stringToInt(tokens[1]);
        }
        if (tokens.length >= 3) {
            year = DateValidator.Companion.stringToInt(tokens[2]);
        }
        if (tokens.length > 3 || day == -1 || month == -1 || year == -1) {
            throw new CheckTypeException(f, "00003");
        }
        if (month == 0) {
            now = new Date();
            month = now.getMonth() + 1;
            year = now.getYear() + 1900;
        } else if (year == -2) {
            now = new Date();
            year = now.getYear() + 1900;
        } else if (year < 50) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        } else if (year < 1000) {
            throw new CheckTypeException(f, "00003");
        }
        if (!DateValidator.Companion.isDate(day, month, year)) {
            throw new CheckTypeException(f, "00003");
        }
        f.setValue(DateValidator.Companion.format(year, month, day));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/DateValidator$Companion;", "", "()V", "format", "", "year", "", "month", "day", "isDate", "", "d", "m", "y", "isLeapYear", "stringToInt", "in", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int stringToInt(String in) {
            int n;
            try {
                n = Integer.valueOf(in);
            }
            catch (Exception e) {
                n = -1;
            }
            return n;
        }

        private final boolean isDate(int d, int m, int y) {
            boolean bl;
            if (y < 1 || m < 1 || m > 12 || d < 1) {
                bl = false;
            } else {
                int n = m;
                switch (n) {
                    case 2: {
                        if (d <= (this.isLeapYear(y) ? 29 : 28)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        if (d <= 30) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        bl = d <= 31;
                    }
                }
            }
            return bl;
        }

        private final boolean isLeapYear(int year) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }

        private final String format(int year, int month, int day) {
            String string = new SimpleDateFormat("dd.MM.yyyy").format(new Date(year - 1900, month - 1, day));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(\"dd.MM.\u2026 - 1900, month - 1, day))");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

