/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyDownEvent;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.KeyPressEvent;
import com.vaadin.flow.component.KeyUpEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.textfield.Autocomplete;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.block.Block;
import org.kopi.galite.visual.ui.vaadin.block.ColumnView;
import org.kopi.galite.visual.ui.vaadin.field.CheckTypeException;
import org.kopi.galite.visual.ui.vaadin.field.DecimalValidator;
import org.kopi.galite.visual.ui.vaadin.field.EnumValidator;
import org.kopi.galite.visual.ui.vaadin.field.Field;
import org.kopi.galite.visual.ui.vaadin.field.NoeditValidator;
import org.kopi.galite.visual.ui.vaadin.field.StringValidator;
import org.kopi.galite.visual.ui.vaadin.field.TextField;
import org.kopi.galite.visual.ui.vaadin.field.TextValidator;
import org.kopi.galite.visual.ui.vaadin.main.MainWindow;
import org.kopi.galite.visual.ui.vaadin.window.Window;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b0\b\u0016\u0018\u0000*\u0016\b\u0000\u0010\u0001*\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\u00020\u00042\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\u0004\u0012\u00020\u00060\u00052\u00020\u00072\u00020\b2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\t2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\n2\u00020\u000b2\u00020\fB\u000f\b\u0000\u0012\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0006J\u001c\u0010F\u001a\u00020G2\u0014\u0010H\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030J0IJ\u0006\u0010K\u001a\u00020DJ\u000e\u0010L\u001a\u00020D2\u0006\u0010M\u001a\u000201J\b\u0010N\u001a\u00020DH\u0004J\r\u0010O\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\bPJ\b\u0010Q\u001a\u00020DH\u0016J\u0014\u0010R\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010T\u001a\u00020UH\u0016J\b\u0010V\u001a\u0004\u0018\u00010\u0006J\n\u0010W\u001a\u0004\u0018\u00010\u0006H\u0016J\u0006\u0010X\u001a\u00020DJ\u0010\u0010Y\u001a\u00020D2\u0006\u0010M\u001a\u000201H\u0004J\b\u0010Z\u001a\u00020\u001fH\u0016J\u0006\u0010[\u001a\u00020DJ\r\u0010\\\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010!J\u0006\u0010]\u001a\u00020DJ\b\u0010^\u001a\u00020DH\u0002J\u0010\u0010_\u001a\u00020D2\u0006\u0010M\u001a\u000201H\u0004J\b\u0010`\u001a\u00020DH\u0004J\b\u0010a\u001a\u00020DH\u0004J\b\u0010b\u001a\u00020DH\u0002J\b\u0010c\u001a\u00020DH\u0004J\u001c\u0010d\u001a\u00020D2\u0012\u0010e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000fH\u0016J\u0012\u0010g\u001a\u00020D2\b\u0010h\u001a\u0004\u0018\u00010iH\u0014J\u001c\u0010j\u001a\u00020D2\u0012\u0010e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000kH\u0016J\u000e\u0010l\u001a\u00020D2\u0006\u0010e\u001a\u00020mJ\u000e\u0010n\u001a\u00020D2\u0006\u0010e\u001a\u00020oJ\u000e\u0010p\u001a\u00020D2\u0006\u0010e\u001a\u00020qJ\b\u0010r\u001a\u00020DH\u0014J\u0010\u0010s\u001a\u00020D2\u0006\u0010e\u001a\u00020tH\u0002J\u0018\u0010u\u001a\u00020D2\u0010\u0010e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010vJ\u0006\u0010w\u001a\u00020DJ\b\u0010x\u001a\u00020DH\u0002J\b\u0010y\u001a\u00020DH\u0016J\u000e\u0010z\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0006J\u000e\u0010{\u001a\u00020\u001f2\u0006\u0010|\u001a\u00020\u001fJ\u0006\u0010}\u001a\u00020DJ\r\u0010~\u001a\u00020DH\u0000\u00a2\u0006\u0002\b\u007fJ\u0012\u0010\u0080\u0001\u001a\u00020D2\u0007\u0010\u0081\u0001\u001a\u00020\u001fH\u0007J\u0010\u0010\u0082\u0001\u001a\u00020D2\u0007\u0010\u0083\u0001\u001a\u00020\u001fJ\u000f\u0010\u0084\u0001\u001a\u00020D2\u0006\u0010*\u001a\u00020\u001fJ\u001d\u0010\u0085\u0001\u001a\u00020D2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u00062\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0088\u0001\u001a\u00020D2\u0007\u0010\u0089\u0001\u001a\u00020\u001fJ\u0012\u0010\u008a\u0001\u001a\u00020D2\u0007\u0010\u008b\u0001\u001a\u00020\u001fH\u0016J\u0011\u0010\u008c\u0001\u001a\u00020D2\u0006\u0010|\u001a\u00020\u001fH\u0016J\u000f\u0010\u008d\u0001\u001a\u00020D2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010\u008e\u0001\u001a\u00020D2\u0007\u0010\u008f\u0001\u001a\u00020\u0006J\t\u0010\u0090\u0001\u001a\u00020DH\u0002J\u000f\u0010\u0091\u0001\u001a\u00020D2\u0006\u00100\u001a\u000201J\u0012\u0010\u0092\u0001\u001a\u00020D2\u0007\u0010\u0093\u0001\u001a\u000201H\u0016J\u0014\u0010\u0094\u0001\u001a\u00020D2\t\u0010\u0095\u0001\u001a\u0004\u0018\u00010\u0006H\u0014J\u0012\u0010\u0096\u0001\u001a\u00020D2\u0007\u0010\u0097\u0001\u001a\u00020\u001fH\u0016J\t\u0010\u0098\u0001\u001a\u00020DH\u0004J\u0011\u0010\u0099\u0001\u001a\u00020D2\b\u0010@\u001a\u0004\u0018\u00010AJ\u001a\u0010\u009a\u0001\u001a\u00020D2\t\u0010\u009b\u0001\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0003\b\u009c\u0001J\u0014\u0010\u009a\u0001\u001a\u00020D2\t\u0010\u009b\u0001\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u009d\u0001\u001a\u00020D2\u0007\u0010\u009e\u0001\u001a\u000201J\u0007\u0010\u009f\u0001\u001a\u00020DJ\u0012\u0010\u00a0\u0001\u001a\u00020D2\t\u0010\u00a1\u0001\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u00a2\u0001\u001a\u00020D2\t\u0010\u009b\u0001\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u00a3\u0001\u001a\u00020D2\u0007\u0010\u0093\u0001\u001a\u000201H\u0004J\u0010\u0010\u00a4\u0001\u001a\u00020D2\u0007\u0010\u00a5\u0001\u001a\u00020\u001fR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b \u0010!R\u001a\u0010#\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010$\"\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020\u001f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010$R\u000e\u0010*\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010$R\u0014\u0010,\u001a\u00020\u001f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010$R*\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00002\f\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001bR\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u00102\u001a\u0004\u0018\u0001038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u0002018DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u000e\u0010:\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010<\u001a\u0002012\u0006\u0010;\u001a\u0002018V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b=\u00109\"\u0004\b>\u0010?R\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a6\u0001"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "C", "Lcom/vaadin/flow/component/AbstractField;", "", "Lcom/vaadin/flow/component/HasSize;", "Lcom/vaadin/flow/component/AbstractCompositeField;", "", "Lcom/vaadin/flow/component/KeyNotifier;", "Lcom/vaadin/flow/component/HasStyle;", "Lcom/vaadin/flow/component/BlurNotifier;", "Lcom/vaadin/flow/component/Focusable;", "Lcom/vaadin/flow/component/textfield/HasAutocomplete;", "Lcom/vaadin/flow/component/textfield/HasPrefixAndSuffix;", "internalField", "(Lcom/vaadin/flow/component/AbstractField;)V", "align", "connector", "Lorg/kopi/galite/visual/ui/vaadin/field/TextField;", "getConnector$galite_core", "()Lorg/kopi/galite/visual/ui/vaadin/field/TextField;", "currentText", "fieldConnector", "Lorg/kopi/galite/visual/ui/vaadin/field/Field;", "getFieldConnector$galite_core", "()Lorg/kopi/galite/visual/ui/vaadin/field/Field;", "focusedTextField", "getFocusedTextField", "()Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "setFocusedTextField", "(Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;)V", "hasAutocomplete", "", "getInternalField", "()Lcom/vaadin/flow/component/AbstractField;", "Lcom/vaadin/flow/component/AbstractField;", "isAlreadySynchronized", "()Z", "setAlreadySynchronized", "(Z)V", "isAutoSelectEnabled", "setAutoSelectEnabled", "isChanged", "isCheckingValue", "isNull", "isWordwrap", "<set-?>", "lastFocusedTextField", "getLastFocusedTextField", "limit", "", "parentWindow", "Lorg/kopi/galite/visual/ui/vaadin/window/Window;", "getParentWindow", "()Lorg/kopi/galite/visual/ui/vaadin/window/Window;", "periodPressed", "record", "getRecord", "()I", "recordNumber", "value", "size", "getSize", "setSize", "(I)V", "validationStrategy", "Lorg/kopi/galite/visual/ui/vaadin/field/TextValidator;", "valueBeforeEdit", "addStyleDependentName", "", "dependentClassName", "addTextValueChangeListener", "Lcom/vaadin/flow/shared/Registration;", "listener", "Lcom/vaadin/flow/component/HasValue$ValueChangeListener;", "Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;", "cancelKey", "checkValue", "rec", "clearServerStyles", "delegateNavigationToServer", "delegateNavigationToServer$galite_core", "focus", "format", "s", "getMaxLength", "", "getSelectedText", "getValue", "gotoNextBlockTextInput", "handleEnumerationFields", "hasAutoComplete", "hideSuggestions", "initContent", "lazyHideSuggestions", "maybeCancelSuggestions", "maybeCheckValue", "maybeReplaceDecimalSeparator", "maybeRestoreOldValue", "maybeSelectAll", "maybeSynchronizeWithServerSide", "onBlur", "event", "Lcom/vaadin/flow/component/BlurNotifier$BlurEvent;", "onDetach", "detachEvent", "Lcom/vaadin/flow/component/DetachEvent;", "onFocus", "Lcom/vaadin/flow/component/FocusNotifier$FocusEvent;", "onKeyDown", "Lcom/vaadin/flow/component/KeyDownEvent;", "onKeyPress", "Lcom/vaadin/flow/component/KeyPressEvent;", "onKeyUp", "Lcom/vaadin/flow/component/KeyUpEvent;", "onLoad", "onPasteEvent", "Lcom/vaadin/flow/dom/DomEvent;", "onValueChange", "Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;", "refreshSuggestionList", "refreshSuggestions", "release", "removeStyleDependentName", "requestFocusInWindow", "focused", "selectAll", "sendDirtyValuesToServerSide", "sendDirtyValuesToServerSide$galite_core", "setAnimationEnabled", "enable", "setBlink", "blink", "setCheckingValue", "setColor", "foreground", "background", "setDisplayModality", "modal", "setEnabled", "enabled", "setFocus", "setHasAutocomplete", "setInputType", "type", "setLastFocusedInput", "setLimit", "setMaxLength", "maxLength", "setPresentationValue", "newPresentationValue", "setReadOnly", "readOnly", "setRecord", "setTextValidator", "setValue", "text", "setAnyValue", "setWidth", "width", "showSuggestionList", "showSuggestions", "query", "updateFieldContent", "updateMaxLength", "valueChange", "blurred", "galite-core"})
public class InputTextField<C extends AbstractField<C, ? extends Object>>
extends AbstractCompositeField<C, InputTextField<C>, String>
implements HasSize,
KeyNotifier,
HasStyle,
BlurNotifier<InputTextField<C>>,
Focusable<InputTextField<C>>,
HasAutocomplete,
HasPrefixAndSuffix {
    @NotNull
    private final C internalField;
    @Nullable
    private TextValidator validationStrategy;
    private boolean periodPressed;
    @Nullable
    private String currentText;
    private int limit;
    private boolean isAutoSelectEnabled;
    private boolean hasAutocomplete;
    @Nullable
    private String valueBeforeEdit;
    @Nullable
    private String align;
    private boolean isCheckingValue;
    private boolean isAlreadySynchronized;
    private int recordNumber;
    @Nullable
    private InputTextField<?> focusedTextField;
    @Nullable
    private InputTextField<?> lastFocusedTextField;

    public InputTextField(@NotNull C internalField) {
        Intrinsics.checkNotNullParameter(internalField, (String)"internalField");
        super(null);
        this.internalField = internalField;
        this.limit = 20;
        this.isAutoSelectEnabled = true;
        this.valueBeforeEdit = "";
        this.recordNumber = -1;
        this.setClassName("k-textinput");
        InputTextField inputTextField = this;
        this.addKeyPressListener(new ComponentEventListener(){

            public final void onComponentEvent(@NotNull KeyPressEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                InputTextField.this.onKeyPress(p0);
            }
        });
        inputTextField = this;
        this.addKeyUpListener(new ComponentEventListener(){

            public final void onComponentEvent(@NotNull KeyUpEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                InputTextField.this.onKeyUp(p0);
            }
        });
        inputTextField = this;
        this.addFocusListener(new ComponentEventListener(){

            public final void onComponentEvent(@NotNull FocusNotifier.FocusEvent<InputTextField<C>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                InputTextField.this.onFocus(p0);
            }
        });
        this.setAutocomplete(this.hasAutoComplete() ? Autocomplete.ON : Autocomplete.OFF);
    }

    @NotNull
    protected final C getInternalField() {
        return this.internalField;
    }

    @Nullable
    public final Window getParentWindow() {
        return this.getFieldConnector$galite_core().getWindow$galite_core();
    }

    public final boolean isAutoSelectEnabled() {
        return this.isAutoSelectEnabled;
    }

    public final void setAutoSelectEnabled(boolean bl) {
        this.isAutoSelectEnabled = bl;
    }

    public final boolean isAlreadySynchronized() {
        return this.isAlreadySynchronized;
    }

    public final void setAlreadySynchronized(boolean bl) {
        this.isAlreadySynchronized = bl;
    }

    @Nullable
    public final InputTextField<?> getFocusedTextField() {
        return this.focusedTextField;
    }

    public final void setFocusedTextField(@Nullable InputTextField<?> inputTextField) {
        this.focusedTextField = inputTextField;
    }

    @Nullable
    public final InputTextField<?> getLastFocusedTextField() {
        return this.lastFocusedTextField;
    }

    protected void setPresentationValue(@Nullable String newPresentationValue) {
        ((AbstractField)this.getContent()).setValue((Object)newPresentationValue);
    }

    @NotNull
    public final Registration addTextValueChangeListener(@NotNull HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<?, ?>> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Registration registration2 = this.internalField.addValueChangeListener(listener);
        Intrinsics.checkNotNullExpressionValue((Object)registration2, (String)"internalField.addValueChangeListener(listener)");
        return registration2;
    }

    @Nullable
    public String getValue() {
        return this.format(this.internalField.getValue());
    }

    private final String format(Object s) {
        Object object;
        return s instanceof LocalDate ? ((LocalDate)s).format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) : ((object = s) == null ? null : object.toString());
    }

    @NotNull
    protected C initContent() {
        return this.internalField;
    }

    public final void onKeyPress(@NotNull KeyPressEvent event) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object $this$trim$iv;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getKey(), (Object)Key.CONTROL) || Intrinsics.areEqual((Object)event.getKey(), (Object)Key.ALT) || Intrinsics.areEqual((Object)event.getKey(), (Object)Key.META)) break block11;
                List list = event.getKey().getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"event.key.keys");
                String string = String.valueOf(CollectionsKt.first((List)list));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valueOf(event.key.keys.first())");
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                $i$f$trim = false;
                if (!($this$trim$iv.length() == 0) || event.getKey() == Key.SPACE) break block12;
            }
            return;
        }
        if (this.getSelectedText() != null && StringsKt.equals$default((String)this.getSelectedText(), (String)this.getValue(), (boolean)false, (int)2, null) && this.validationStrategy != null && this.validationStrategy instanceof EnumValidator) {
            $this$trim$iv = event.getKey().getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)$this$trim$iv, (String)"event.key.keys");
            $this$forEach$iv = (Iterable)$this$trim$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                TextValidator textValidator = this.validationStrategy;
                Intrinsics.checkNotNull((Object)textValidator);
                if (textValidator.validate(it)) continue;
                this.cancelKey();
            }
            return;
        }
        if (this.validationStrategy != null) {
            $this$forEach$iv = event.getKey().getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"event.key.keys");
            $this$forEach$iv = $this$forEach$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                TextValidator textValidator = this.validationStrategy;
                Intrinsics.checkNotNull((Object)textValidator);
                if (textValidator.validate(Intrinsics.stringPlus((String)this.getValue(), (Object)it))) continue;
                this.cancelKey();
            }
        }
        if (event.getKey().matches(".")) {
            this.periodPressed = true;
        }
    }

    @Nullable
    public final String getSelectedText() {
        return null;
    }

    public final void cancelKey() {
    }

    private final void onPasteEvent(DomEvent event) {
        if (this.validationStrategy != null) {
            String before = this.getValue();
            TextValidator textValidator = this.validationStrategy;
            Intrinsics.checkNotNull((Object)textValidator);
            if (!textValidator.validate(this.getValue())) {
                this.setValue(before);
            } else {
                this.getFieldConnector$galite_core().setChanged(true);
                this.getFieldConnector$galite_core().markAsDirty(this.getRecord());
            }
        }
    }

    @JvmName(name="setAnyValue")
    public final void setAnyValue(@Nullable Object text) {
        this.setValue(this.format(text));
    }

    public void setValue(@Nullable String text) {
        String text2;
        block7: {
            block6: {
                text2 = text;
                this.setRecord();
                if (this.validationStrategy instanceof NoeditValidator) break block6;
                TextValidator textValidator = this.validationStrategy;
                Intrinsics.checkNotNull((Object)textValidator);
                if (!textValidator.validate(text2)) break block7;
            }
            if (text2 == null) {
                text2 = "";
            }
            if (!Intrinsics.areEqual((Object)text2, (Object)this.getValue())) {
                this.getFieldConnector$galite_core().setChanged(true);
            }
            this.setPresentationValue(text2);
        }
        if (text2 != null) {
            this.valueBeforeEdit = text2;
        }
    }

    public final void setColor(@Nullable String foreground, @Nullable String background) {
        boolean bl;
        CharSequence charSequence;
        block8: {
            block9: {
                block7: {
                    if (foreground == null) break block7;
                    charSequence = foreground;
                    bl = false;
                    if (!(charSequence.length() == 0)) break block8;
                }
                if (background == null) break block9;
                charSequence = background;
                bl = false;
                if (!(charSequence.length() == 0)) break block8;
            }
            this.clearServerStyles();
        }
        this.getStyle().set("text-align", this.align);
        if (foreground != null) {
            charSequence = foreground;
            bl = false;
            if (charSequence.length() > 0) {
                this.getStyle().set("color", Intrinsics.stringPlus((String)foreground, (Object)" !important"));
            }
        }
        if (background != null) {
            charSequence = background;
            bl = false;
            if (charSequence.length() > 0) {
                this.getStyle().set("background-color", Intrinsics.stringPlus((String)background, (Object)" !important"));
            }
        }
    }

    protected final void clearServerStyles() {
        String[] stringArray = this.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"className");
        CharSequence charSequence = (CharSequence)stringArray;
        stringArray = new String[]{"\\s"};
        for (String style : StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            if (!StringsKt.endsWith$default((String)style, (String)Intrinsics.stringPlus((String)"-", (Object)this.getFieldConnector$galite_core().getPosition()), (boolean)false, (int)2, null)) continue;
            this.removeClassName(style);
        }
    }

    public boolean hasAutoComplete() {
        return this.hasAutocomplete;
    }

    public final void setTextValidator(@Nullable TextValidator validationStrategy) {
        this.validationStrategy = validationStrategy;
    }

    public final void setWidth(int width) {
        this.setWidth(width + "ex");
    }

    public double getMaxLength() {
        return this.getElement().getProperty("maxlength", 0.0);
    }

    public void setMaxLength(int maxLength) {
        this.updateMaxLength(maxLength);
    }

    public int getSize() {
        String string = this.internalField.getElement().getProperty("size");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"internalField.element.getProperty(\"size\")");
        boolean bl = false;
        return Integer.parseInt(string);
    }

    public void setSize(int value) {
        this.getElement().setProperty("size", String.valueOf(value));
    }

    protected final void updateMaxLength(int maxLength) {
        if (maxLength >= 0) {
            this.getElement().setProperty("maxlength", (double)maxLength);
        } else {
            this.getElement().removeAttribute("maxLength");
        }
    }

    public final void setBlink(boolean blink) {
        if (blink) {
            this.addStyleDependentName("blink");
        } else {
            this.removeStyleDependentName("blink");
        }
    }

    public final void updateFieldContent(@Nullable String text) {
        this.setValue(text);
        this.getFieldConnector$galite_core().unsetDirty();
    }

    protected final void setRecord() {
        int position = this.getFieldConnector$galite_core().getPosition();
        ColumnView columnView = this.getFieldConnector$galite_core().getColumnView();
        Intrinsics.checkNotNull((Object)columnView);
        this.recordNumber = columnView.getRecordFromDisplayLine(position);
    }

    protected final int getRecord() {
        if (this.recordNumber == -1) {
            this.setRecord();
        }
        return this.recordNumber;
    }

    public final void valueChange(boolean blurred) {
        if (!this.getFieldConnector$galite_core().isChanged()) {
            return;
        }
        int rec = this.getRecord();
        if (!StringsKt.equals$default((String)this.getValue(), (String)this.getFieldConnector$galite_core().getCachedValueAt$galite_core(rec), (boolean)false, (int)2, null)) {
            this.getFieldConnector$galite_core().markAsDirty$galite_core(rec, this.getValue());
        }
        if (blurred) {
            this.maybeRestoreOldValue();
            if (this.getFieldConnector$galite_core().isDirty()) {
                this.maybeSynchronizeWithServerSide();
            }
        } else {
            this.handleEnumerationFields(rec);
            this.maybeCheckValue(rec);
        }
    }

    protected final void maybeRestoreOldValue() {
    }

    protected final void maybeSynchronizeWithServerSide() {
        if (this.delegateNavigationToServer$galite_core() && this.getConnector$galite_core().needsSynchronization$galite_core() && !this.isAlreadySynchronized) {
            this.sendDirtyValuesToServerSide$galite_core();
        }
    }

    protected final void maybeCheckValue(int rec) {
        if (!this.isCheckingValue && !this.delegateNavigationToServer$galite_core()) {
            try {
                this.checkValue(rec);
            }
            catch (CheckTypeException e) {
                e.displayError();
            }
        }
    }

    protected final void handleEnumerationFields(int rec) {
    }

    public final void sendDirtyValuesToServerSide$galite_core() {
        Block block;
        Window window = this.getParentWindow();
        Object t = this.getConnector$galite_core().getParent().get();
        Block block2 = block = t instanceof Block ? (Block)((Object)t) : null;
        if (block != null) {
            Window window2 = window;
            Intrinsics.checkNotNull((Object)((Object)window2));
            window2.cleanDirtyValues(block);
        }
        this.isAlreadySynchronized = true;
    }

    public final boolean delegateNavigationToServer$galite_core() {
        return this.getFieldConnector$galite_core().delegateNavigationToServer();
    }

    protected final boolean isWordwrap() {
        String string = this.getElement().getAttribute("wrap");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.getAttribute(\"wrap\")");
        String wrap = string;
        return !Intrinsics.areEqual((Object)"off", (Object)wrap);
    }

    public final void setCheckingValue(boolean isCheckingValue) {
        this.isCheckingValue = isCheckingValue;
    }

    public final void onKeyUp(@NotNull KeyUpEvent event) {
        Key key;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.hasAutocomplete && !(((((((((((Intrinsics.areEqual((Object)(key = event.getKey()), (Object)Key.ARROW_DOWN) ? true : Intrinsics.areEqual((Object)key, (Object)Key.PAGE_DOWN)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ARROW_UP)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.PAGE_UP)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ARROW_LEFT)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ARROW_RIGHT)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ENTER)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.TAB)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.SHIFT)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.CONTROL)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ALT)) ? true : Intrinsics.areEqual((Object)key, (Object)Key.ESCAPE))) {
            this.refreshSuggestions();
        }
        if (this.periodPressed) {
            this.maybeReplaceDecimalSeparator();
            this.periodPressed = false;
        }
        if (this.isChanged()) {
            this.getFieldConnector$galite_core().setChanged(true);
        }
        this.valueBeforeEdit = this.getValue();
    }

    protected final boolean isChanged() {
        boolean bl;
        if (this.validationStrategy instanceof StringValidator) {
            Object object = this.validationStrategy;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.field.StringValidator");
            }
            StringValidator strategy = (StringValidator)object;
            object = strategy.getConvertType();
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            switch (n) {
                case 1: {
                    String string;
                    String string2 = this.getValue();
                    if (string2 == null) {
                        string = null;
                    } else {
                        String string3 = string2;
                        boolean bl2 = false;
                        String string4 = string3.toUpperCase();
                        string = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
                    }
                    String string5 = this.valueBeforeEdit;
                    Intrinsics.checkNotNull((Object)string5);
                    string2 = string5;
                    boolean bl3 = false;
                    String string6 = string2;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toUpperCase()");
                    if (!Intrinsics.areEqual((Object)string, (Object)string7)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    String string;
                    String string8 = this.getValue();
                    if (string8 == null) {
                        string = null;
                    } else {
                        String string9 = string8;
                        boolean bl4 = false;
                        String string10 = string9.toLowerCase();
                        string = string10;
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase()");
                    }
                    String string11 = this.valueBeforeEdit;
                    Intrinsics.checkNotNull((Object)string11);
                    string8 = string11;
                    boolean bl5 = false;
                    String string12 = string8;
                    if (string12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string13 = string12.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.String).toLowerCase()");
                    if (!Intrinsics.areEqual((Object)string, (Object)string13)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    if (!StringsKt.equals$default((String)this.getValue(), (String)this.valueBeforeEdit, (boolean)false, (int)2, null)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        } else {
            bl = !StringsKt.equals$default((String)this.getValue(), (String)this.valueBeforeEdit, (boolean)false, (int)2, null);
        }
        return bl;
    }

    protected final void maybeReplaceDecimalSeparator() {
        if (this.validationStrategy instanceof DecimalValidator) {
            String string = this.getValue();
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null)) {
                Object object = DecimalFormatSymbols.getInstance(new Locale(MainWindow.Companion.getLocale()));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(Locale(MainWindow.locale))");
                DecimalFormatSymbols dfs = object;
                if (dfs.getDecimalSeparator() != '.') {
                    object = this.getValue();
                    this.setValue(object == null ? null : StringsKt.replace$default((String)object, (char)'.', (char)dfs.getDecimalSeparator(), (boolean)false, (int)4, null));
                }
            }
        }
    }

    public final void onValueChange(@Nullable HasValue.ValueChangeEvent<String> event) {
        this.valueChange(false);
    }

    public final void onKeyDown(@NotNull KeyDownEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public final boolean requestFocusInWindow(boolean focused) {
        if (Intrinsics.areEqual(this.focusedTextField, (Object)((Object)this))) {
            return true;
        }
        this.focus();
        this.setFocus(focused);
        return false;
    }

    public void setFocus(boolean focused) {
        if (focused) {
            this.focus();
        } else {
            this.blur();
        }
    }

    public void focus() {
        if (this.internalField instanceof Focusable) {
            ((Focusable)this.internalField).focus();
        } else {
            super.focus();
        }
    }

    public final void gotoNextBlockTextInput() {
        this.sendDirtyValuesToServerSide$galite_core();
        ColumnView columnView = this.getFieldConnector$galite_core().getColumnView();
        Intrinsics.checkNotNull((Object)columnView);
        columnView.gotoNextField();
    }

    protected void onLoad() {
    }

    public void onBlur(@NotNull BlurNotifier.BlurEvent<InputTextField<C>> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (this.focusedTextField != this || this.focusedTextField == null) {
            return;
        }
        this.removeStyleDependentName("focus");
        this.focusedTextField = null;
        this.valueChange(true);
        this.lazyHideSuggestions();
        this.recordNumber = -1;
    }

    public void onFocus(@NotNull FocusNotifier.FocusEvent<InputTextField<C>> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual(this.focusedTextField, (Object)((Object)this))) {
            return;
        }
        this.focusedTextField = this;
        this.setRecord();
        ColumnView columnView = this.getFieldConnector$galite_core().getColumnView();
        Intrinsics.checkNotNull((Object)columnView);
        columnView.disableAllBlocksActors();
        this.addStyleDependentName("focus");
        this.setLastFocusedInput();
        this.maybeCancelSuggestions();
        ColumnView columnView2 = this.getFieldConnector$galite_core().getColumnView();
        Intrinsics.checkNotNull((Object)columnView2);
        columnView2.setAsActiveField(-1);
        this.getFieldConnector$galite_core().setChanged(false);
        this.isAlreadySynchronized = false;
        this.valueBeforeEdit = this.getValue();
        this.getFieldConnector$galite_core().setActorsEnabled(true);
        this.maybeSelectAll();
    }

    public final void selectAll() {
    }

    protected void onDetach(@Nullable DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        if (Intrinsics.areEqual(this.focusedTextField, (Object)((Object)this))) {
            this.focusedTextField = null;
        }
    }

    public void setReadOnly(boolean readOnly) {
        boolean wasReadOnly = this.isReadOnly();
        if (readOnly) {
            this.setTabIndex(-1);
        } else if (wasReadOnly && !readOnly && this.getTabIndex() == -1) {
            this.setTabIndex(0);
        }
        super.setReadOnly(readOnly);
    }

    private final void maybeSelectAll() {
        if (this.getValue() != null) {
            String string = this.getValue();
            Intrinsics.checkNotNull((Object)string);
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                this.selectAll();
            }
        }
    }

    private final void setLastFocusedInput() {
        if (this.getParent() != null) {
            this.lastFocusedTextField = this;
        }
    }

    private final void maybeCancelSuggestions() {
        if (this.getValue() != null) {
            String string = this.getValue();
            Intrinsics.checkNotNull((Object)string);
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() == 0) {
                // empty if block
            }
        }
    }

    @NotNull
    public final TextField getConnector$galite_core() {
        return (TextField)((Object)super.getParent().get());
    }

    public final void checkValue(int rec) {
        this.isCheckingValue = true;
        if (this.validationStrategy != null) {
            String string;
            TextValidator textValidator = this.validationStrategy;
            Intrinsics.checkNotNull((Object)textValidator);
            if (this.getValue() == null) {
                string = "";
            } else {
                String string2 = this.getValue();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = string2;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            }
            textValidator.checkType(this, string);
            if (!StringsKt.equals$default((String)this.getValue(), (String)this.getFieldConnector$galite_core().getCachedValueAt$galite_core(rec), (boolean)false, (int)2, null)) {
                this.getConnector$galite_core().markAsDirty$galite_core(rec, this.getValue());
            }
        }
        this.isCheckingValue = false;
    }

    /*
     * Unable to fully structure code
     */
    private final void refreshSuggestions() {
        text = this.getValue();
        if (text == null) ** GOTO lbl-1000
        var2_2 = text;
        var3_3 = false;
        if (var2_2.length() == 0 || (double)text.length() == this.getMaxLength()) lbl-1000:
        // 2 sources

        {
            this.hideSuggestions();
        } else {
            this.currentText = text;
        }
        this.showSuggestions(text);
    }

    public final void hideSuggestions() {
    }

    public final void lazyHideSuggestions() {
    }

    @NotNull
    public final Field getFieldConnector$galite_core() {
        return this.getConnector$galite_core().getFieldParent();
    }

    public final boolean isNull() {
        return this.getValue() == null || Intrinsics.areEqual((Object)"", (Object)this.getValue());
    }

    public final void showSuggestions(@Nullable String query) {
        if (!this.hasAutocomplete) {
            return;
        }
    }

    public final void refreshSuggestionList() {
        if (this.isAttached() && this.hasAutocomplete) {
            this.refreshSuggestions();
        }
    }

    public final void showSuggestionList() {
        if (this.isAttached() && this.hasAutocomplete) {
            this.currentText = null;
            this.refreshSuggestions();
        }
    }

    public final void setDisplayModality(boolean modal) {
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void release() {
        this.validationStrategy = null;
        this.currentText = null;
        this.valueBeforeEdit = null;
        this.align = null;
    }

    @Deprecated(message="use {@link DefaultSuggestionDisplay#setAnimationEnabled(boolean)} instead")
    public final void setAnimationEnabled(boolean enable) {
    }

    public final void setHasAutocomplete(boolean hasAutocomplete) {
        this.hasAutocomplete = hasAutocomplete;
    }

    public final void setInputType(@NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.getElement().getNode().runWhenAttached(new SerializableConsumer(this, type2){
            final /* synthetic */ InputTextField<C> this$0;
            final /* synthetic */ String $type;
            {
                this.this$0 = $receiver;
                this.$type = $type;
            }

            public final void accept(UI ui) {
                Serializable[] serializableArray = new Serializable[]{(Serializable)((Object)this.this$0), (Serializable)((Object)this.$type)};
                ui.getPage().executeJs("$0.focusElement.type=$1", serializableArray);
            }
        });
    }

    public final void addStyleDependentName(@NotNull String dependentClassName) {
        Intrinsics.checkNotNullParameter((Object)dependentClassName, (String)"dependentClassName");
        if (this.getClassName() != null) {
            this.getElement().getClassList().add((Object)Intrinsics.stringPlus((String)"k-textinput-", (Object)dependentClassName));
        }
    }

    public final void removeStyleDependentName(@NotNull String dependentClassName) {
        Intrinsics.checkNotNullParameter((Object)dependentClassName, (String)"dependentClassName");
        if (this.getClassName() != null) {
            this.getElement().getClassList().remove((Object)Intrinsics.stringPlus((String)"k-textinput-", (Object)dependentClassName));
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextField.ConvertType.values().length];
            nArray[TextField.ConvertType.UPPER.ordinal()] = 1;
            nArray[TextField.ConvertType.LOWER.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

