/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.ui.vaadin.field.AllowAllValidator;
import org.kopi.galite.visual.ui.vaadin.field.CheckTypeException;
import org.kopi.galite.visual.ui.vaadin.field.InputTextField;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/TimeValidator;", "Lorg/kopi/galite/visual/ui/vaadin/field/AllowAllValidator;", "maxLength", "", "(I)V", "checkType", "", "field", "Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "text", "", "isTime", "", "h", "m", "toString", "hours", "minutes", "validate", "c", "", "galite-core"})
public final class TimeValidator
extends AllowAllValidator {
    public TimeValidator(int maxLength) {
        super(maxLength);
    }

    @Override
    public boolean validate(char c) {
        return ('0' <= c ? c <= '9' : false) || c == ':';
    }

    @Override
    public void checkType(@NotNull InputTextField<?> field2, @NotNull String text) {
        Intrinsics.checkNotNullParameter(field2, (String)"field");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)"", (Object)text)) {
            field2.setValue(null);
        } else {
            int hours = -1;
            int minutes = 0;
            String buffer = Intrinsics.stringPlus((String)text, (Object)"\u0000");
            int bp = 0;
            int state = 0;
            state = 1;
            while (state > 0) {
                int n = state;
                switch (n) {
                    case 1: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            hours = buffer.charAt(bp) - 48;
                            state = 2;
                            break;
                        }
                        if (buffer.charAt(bp) == '\u0000') {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 2: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            hours = 10 * hours + (buffer.charAt(bp) - 48);
                            state = 3;
                            break;
                        }
                        if (buffer.charAt(bp) == ':') {
                            state = 4;
                            break;
                        }
                        if (buffer.charAt(bp) == '\u0000') {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 3: {
                        char c = buffer.charAt(bp);
                        state = c == ':' ? 4 : (c == '\u0000' ? 0 : -1);
                        break;
                    }
                    case 4: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            minutes = buffer.charAt(bp) - 48;
                            state = 5;
                            break;
                        }
                        if (buffer.charAt(bp) == '\u0000') {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 5: {
                        char c = buffer.charAt(bp);
                        boolean bl = '0' <= c ? c <= '9' : false;
                        if (bl) {
                            minutes = 10 * minutes + (buffer.charAt(bp) - 48);
                            state = 6;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 6: {
                        state = buffer.charAt(bp) == '\u0000' ? 0 : -1;
                    }
                }
                ++bp;
            }
            if (state == -1) {
                throw new CheckTypeException(field2, "00007");
            }
            if (hours == -1) {
                field2.setValue(null);
            } else {
                if (!this.isTime(hours, minutes)) {
                    throw new CheckTypeException(field2, "00007");
                }
                field2.setValue(this.toString(hours, minutes));
            }
        }
    }

    private final boolean isTime(int h, int m) {
        return (0 <= h ? h <= 23 : false) && m >= 0 && m < 60;
    }

    private final String toString(int hours, int minutes) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        $this$toString_u24lambda_u2d0.append(hours / 10);
        $this$toString_u24lambda_u2d0.append(hours % 10);
        $this$toString_u24lambda_u2d0.append(':');
        $this$toString_u24lambda_u2d0.append(minutes / 10);
        $this$toString_u24lambda_u2d0.append(minutes % 10);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

