/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.base.UComponent;
import org.kopi.galite.visual.form.Alignment;
import org.kopi.galite.visual.form.BlockAlignment;
import org.kopi.galite.visual.form.UBlock;
import org.kopi.galite.visual.form.UForm;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldUI;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.block.Block;
import org.kopi.galite.visual.ui.vaadin.block.BlockLayout;
import org.kopi.galite.visual.ui.vaadin.block.SimpleBlockLayout;
import org.kopi.galite.visual.ui.vaadin.form.DFieldUI;
import org.kopi.galite.visual.ui.vaadin.form.DForm;
import org.kopi.galite.visual.ui.vaadin.form.Page;
import org.kopi.galite.visual.visual.VExecFailedException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@CssImport(value="./styles/galite/block.css")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020+H\u0016J\b\u00105\u001a\u00020+H\u0016J\b\u00106\u001a\u00020+H\u0016J\u001a\u00107\u001a\u00020+2\u0006\u00101\u001a\u00020\u00062\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u001a\u0010:\u001a\u00020+2\u0006\u00101\u001a\u00020\u00062\b\u00108\u001a\u0004\u0018\u000109H\u0016J\b\u0010;\u001a\u00020+H\u0016J\u0018\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u000209H\u0014J\u001a\u0010>\u001a\u0004\u0018\u00010\n2\u0006\u0010=\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u000209H\u0002J\b\u0010?\u001a\u00020+H\u0014J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020+H\u0016J\b\u0010C\u001a\u00020+H\u0016J,\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\u00172\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010I\u001a\u0004\u0018\u00010HH\u0016J\u0010\u0010J\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u0017H\u0016J\n\u0010L\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010M\u001a\u00020\u0017H\u0016J\u0010\u0010M\u001a\u00020\u00172\u0006\u0010N\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\u00172\u0006\u0010Q\u001a\u00020\u0017H\u0016J\b\u0010R\u001a\u000203H\u0016J\u0010\u0010S\u001a\u00020+2\u0006\u0010T\u001a\u00020UH\u0014J\b\u0010V\u001a\u00020+H\u0016J\b\u0010W\u001a\u00020+H\u0014J\u0018\u0010X\u001a\u00020+2\u0006\u0010F\u001a\u00020\u00172\u0006\u0010Y\u001a\u00020\u0017H\u0016J\u0010\u0010Z\u001a\u00020+2\u0006\u0010[\u001a\u000203H\u0016J-\u0010\\\u001a\u00020+2\u0006\u0010]\u001a\u00020\u00172\b\u0010^\u001a\u0004\u0018\u00010H2\f\u0010_\u001a\b\u0012\u0002\b\u0003\u0018\u00010`H\u0000\u00a2\u0006\u0002\baJ\u0010\u0010b\u001a\u00020+2\u0006\u0010c\u001a\u00020\u0017H\u0014J\b\u0010d\u001a\u00020+H\u0016R$\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0084.\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0019\"\u0004\b#\u0010\u001bR\u001a\u0010$\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0019\"\u0004\b&\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001e\u00a8\u0006e"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DBlock;", "Lorg/kopi/galite/visual/ui/vaadin/block/Block;", "Lorg/kopi/galite/visual/form/UBlock;", "parent", "Lorg/kopi/galite/visual/ui/vaadin/form/DForm;", "model", "Lorg/kopi/galite/visual/form/VBlock;", "(Lorg/kopi/galite/visual/ui/vaadin/form/DForm;Lorg/kopi/galite/visual/form/VBlock;)V", "columnViews", "", "Lorg/kopi/galite/visual/form/VFieldUI;", "getColumnViews", "()[Lorg/kopi/galite/visual/form/VFieldUI;", "setColumnViews", "([Lorg/kopi/galite/visual/form/VFieldUI;)V", "[Lorg/kopi/galite/visual/form/VFieldUI;", "currentUI", "Lcom/vaadin/flow/component/UI;", "getCurrentUI", "()Lcom/vaadin/flow/component/UI;", "setCurrentUI", "(Lcom/vaadin/flow/component/UI;)V", "displayedFields", "", "getDisplayedFields", "()I", "setDisplayedFields", "(I)V", "formView", "getFormView", "()Lorg/kopi/galite/visual/ui/vaadin/form/DForm;", "setFormView", "(Lorg/kopi/galite/visual/ui/vaadin/form/DForm;)V", "maxColumnPos", "getMaxColumnPos", "setMaxColumnPos", "maxRowPos", "getMaxRowPos", "setMaxRowPos", "getModel", "()Lorg/kopi/galite/visual/form/VBlock;", "getParent", "add", "", "comp", "Lorg/kopi/galite/visual/base/UComponent;", "constraints", "Lorg/kopi/galite/visual/form/Alignment;", "blockAccessChanged", "block", "newAccess", "", "blockChanged", "blockCleared", "blockClosed", "blockViewModeEntered", "activeField", "Lorg/kopi/galite/visual/form/VField;", "blockViewModeLeaved", "clear", "createFieldDisplay", "index", "createFieldDisplays", "createFields", "createLayout", "Lorg/kopi/galite/visual/ui/vaadin/block/BlockLayout;", "filterHidden", "filterShown", "fireColorChanged", "col", "rec", "foreground", "", "background", "getColumnPos", "x", "getCurrentDisplay", "getDisplayLine", "recno", "Lorg/kopi/galite/visual/form/UForm;", "getRecordFromDisplayLine", "line", "inDetailMode", "onAttach", "attachEvent", "Lcom/vaadin/flow/component/AttachEvent;", "orderChanged", "rebuildCachedInfos", "recordInfoChanged", "info", "refresh", "force", "setBorder", "style", "title", "page", "Lorg/kopi/galite/visual/ui/vaadin/form/Page;", "setBorder$galite_core", "setScrollPos", "value", "validRecordNumberChanged", "galite-core"})
public class DBlock
extends Block
implements UBlock {
    @NotNull
    private final DForm parent;
    @NotNull
    private final VBlock model;
    @NotNull
    private DForm formView;
    protected VFieldUI[] columnViews;
    private int maxRowPos;
    private int maxColumnPos;
    private int displayedFields;
    @Nullable
    private UI currentUI;

    public DBlock(@NotNull DForm parent, @NotNull VBlock model2) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(model2.isDroppable());
        this.parent = parent;
        this.model = model2;
        this.formView = this.parent;
        this.maxRowPos = this.model.getMaxRowPos();
        this.maxColumnPos = this.model.getMaxColumnPos();
        this.displayedFields = this.model.getDisplayedFields();
        this.maxRowPos = this.model.getMaxRowPos();
        this.maxColumnPos = this.model.getMaxColumnPos();
        this.displayedFields = this.model.getDisplayedFields();
        this.formView = this.parent;
        this.model.addBlockListener(this);
        this.setBufferSize(this.model.getBufferSize(), this.model.getDisplaySize());
        this.setSortedRecords(this.model.getSortedRecords());
        this.setNoMove(this.model.noMove());
        this.setNoChart(this.model.noChart());
        if (this.model.isMulti()) {
            this.setSortedRecToDisplay(new int[this.model.getBufferSize()]);
            this.setDisplayToSortedRec(new int[this.model.getDisplaySize()]);
        } else {
            this.setSortedRecToDisplay(new int[1]);
            this.setDisplayToSortedRec(new int[1]);
        }
        this.rebuildCachedInfos();
        this.createFields();
        if (this.model.isDroppable()) {
            // empty if block
        }
        if ((n2 = 0) < (n = this.model.getBufferSize())) {
            do {
                int i;
                if (this.model.getRecordInfoAt(i = n2++) == 0) continue;
                this.fireRecordInfoChanged(i, this.model.getRecordInfoAt(i));
            } while (n2 < n);
        }
    }

    @NotNull
    public final DForm getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public final VBlock getModel() {
        return this.model;
    }

    @Override
    @NotNull
    protected final DForm getFormView() {
        return this.formView;
    }

    protected final void setFormView(@NotNull DForm dForm) {
        Intrinsics.checkNotNullParameter((Object)dForm, (String)"<set-?>");
        this.formView = dForm;
    }

    @NotNull
    protected final VFieldUI[] getColumnViews() {
        VFieldUI[] vFieldUIArray = this.columnViews;
        if (vFieldUIArray != null) {
            return vFieldUIArray;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"columnViews");
        return null;
    }

    protected final void setColumnViews(@NotNull VFieldUI[] vFieldUIArray) {
        Intrinsics.checkNotNullParameter((Object)vFieldUIArray, (String)"<set-?>");
        this.columnViews = vFieldUIArray;
    }

    protected final int getMaxRowPos() {
        return this.maxRowPos;
    }

    protected final void setMaxRowPos(int n) {
        this.maxRowPos = n;
    }

    protected final int getMaxColumnPos() {
        return this.maxColumnPos;
    }

    protected final void setMaxColumnPos(int n) {
        this.maxColumnPos = n;
    }

    protected final int getDisplayedFields() {
        return this.displayedFields;
    }

    protected final void setDisplayedFields(int n) {
        this.displayedFields = n;
    }

    /*
     * WARNING - void declaration
     */
    protected void createFields() {
        VField[] fields = this.model.getFields();
        int index = 0;
        this.setColumnViews(new VFieldUI[fields.length]);
        VField[] $this$forEachIndexed$iv = fields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (VField item$iv : $this$forEachIndexed$iv) {
            void field2;
            int n = index$iv++;
            VField vField2 = item$iv;
            int i = n;
            boolean bl = false;
            this.getColumnViews()[i] = this.createFieldDisplays(index, (VField)field2);
            if (this.getColumnViews()[i] == null) continue;
            ++index;
        }
    }

    @Override
    protected void rebuildCachedInfos() {
        int n;
        int cnt = 0;
        int i = 0;
        while (i < this.getSortedToprec()) {
            this.getSortedRecToDisplay()[i] = -1;
            n = i;
            i = n + 1;
        }
        while (cnt < this.model.getDisplaySize() && i < this.model.getBufferSize()) {
            int n2;
            int[] nArray = this.getSortedRecToDisplay();
            if (this.model.isSortedRecordDeleted(i)) {
                n2 = -1;
            } else {
                n = cnt;
                cnt = n + 1;
                n2 = n;
            }
            nArray[i] = n2;
            n = i;
            i = n + 1;
        }
        while (i < this.model.getBufferSize()) {
            this.getSortedRecToDisplay()[i] = -1;
            n = i;
            i = n + 1;
        }
        cnt = this.getSortedToprec();
        i = 0;
        while (i < this.model.getDisplaySize()) {
            while (cnt < this.model.getBufferSize() && this.model.isSortedRecordDeleted(cnt)) {
                n = cnt;
                cnt = n + 1;
            }
            if (cnt < this.model.getBufferSize()) {
                n = cnt;
                cnt = n + 1;
                this.getDisplayToSortedRec()[i] = n;
            }
            n = i;
            i = n + 1;
        }
    }

    private final VFieldUI createFieldDisplays(int index, VField model2) {
        return !model2.isInternal() ? this.createFieldDisplay(index, model2) : (VFieldUI)null;
    }

    @NotNull
    protected VFieldUI createFieldDisplay(int index, @NotNull VField model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return new DFieldUI(this, model2, index);
    }

    public void refresh(boolean force) {
        int n;
        int n2;
        int i22;
        boolean redisplay = false;
        int recno = 0;
        if (!this.model.isMulti()) {
            return;
        }
        if (this.model.getActiveRecord() == -1) {
            this.rebuildCachedInfos();
            int n3 = 0;
            int n4 = this.getColumnViews().length + -1;
            if (n3 <= n4) {
                do {
                    int i22 = n3++;
                    if (this.getColumnViews()[i22] == null) continue;
                    VFieldUI vFieldUI = this.getColumnViews()[i22];
                    Intrinsics.checkNotNull((Object)vFieldUI);
                    vFieldUI.scrollTo(this.getSortedToprec());
                } while (n3 <= n4);
            }
            return;
        }
        recno = this.model.getSortedPosition(this.model.getActiveRecord());
        if (recno < this.getSortedToprec()) {
            this.setSortedToprec(recno);
            int i = recno - 1;
            int scrollMore = this.model.getDisplaySize() / 4;
            while (scrollMore > 0 && i > 0) {
                if (!this.model.isSortedRecordDeleted(i)) {
                    DBlock i22 = this;
                    i22.setSortedToprec(i22.getSortedToprec() - 1);
                    i22 = scrollMore;
                    scrollMore = i22 + -1;
                }
                i22 = i;
                i = i22 + -1;
            }
            redisplay = true;
        } else {
            int displine = 0;
            for (int i = this.getSortedToprec(); i < recno; ++i) {
                if (this.model.isSortedRecordDeleted(i)) continue;
                ++displine;
            }
            if (displine < this.model.getDisplaySize()) {
                redisplay = force;
            } else {
                do {
                    if (!this.model.isSortedRecordDeleted(this.getSortedToprec())) {
                        --displine;
                    }
                    DBlock i22 = this;
                    i22.setSortedToprec(i22.getSortedToprec() + 1);
                } while (displine >= this.model.getDisplaySize());
                i22 = recno + 1;
                int scrollMore = this.model.getDisplaySize() / 4;
                while (scrollMore > 0 && i22 < this.model.getBufferSize()) {
                    int n5;
                    if (!this.model.isSortedRecordDeleted(i22)) {
                        DBlock dBlock = this;
                        dBlock.setSortedToprec(dBlock.getSortedToprec() + 1);
                        n5 = scrollMore;
                        scrollMore = n5 + -1;
                    }
                    n5 = i22;
                    i22 = n5 + 1;
                }
                redisplay = true;
            }
        }
        this.rebuildCachedInfos();
        if (redisplay && (n2 = 0) <= (n = this.getColumnViews().length + -1)) {
            do {
                i22 = n2++;
                if (this.getColumnViews()[i22] == null) continue;
                VFieldUI vFieldUI = this.getColumnViews()[i22];
                Intrinsics.checkNotNull((Object)vFieldUI);
                vFieldUI.scrollTo(this.getSortedToprec());
            } while (n2 <= n);
        }
        BackgroundThreadHandler.INSTANCE.access(this.currentUI, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DBlock this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DBlock.access$fireActiveRecordChanged(this.this$0, this.this$0.getModel().getActiveRecord());
            }
        }));
    }

    @Nullable
    public final UI getCurrentUI() {
        return this.currentUI;
    }

    public final void setCurrentUI(@Nullable UI uI) {
        this.currentUI = uI;
    }

    protected void onAttach(@NotNull AttachEvent attachEvent) {
        Intrinsics.checkNotNullParameter((Object)attachEvent, (String)"attachEvent");
        this.currentUI = attachEvent.getUI();
    }

    public void fireColorChanged(int col, int rec, @Nullable String foreground, @Nullable String background) {
        this.getCachedColors().add(new Block.CachedColor(col, rec, foreground, background));
    }

    @Override
    protected void setScrollPos(int value) {
        int value2 = value;
        boolean bl = value2 < this.model.getBufferSize();
        int n = 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.getSortedToprec() != value2) {
            int recno = 0;
            while (value2 > 0) {
                if (!this.model.isSortedRecordDeleted(recno)) {
                    n = value2;
                    value2 = n + -1;
                }
                n = recno;
                recno = n + 1;
            }
            if (this.model.getActiveField() != null) {
                int lastVisibleRec = recno;
                int nbDisplay = this.model.getDisplaySize() - 1;
                int activeRecord = this.model.getActiveRecord();
                boolean inside = false;
                while (nbDisplay > 0) {
                    if (!this.model.isSortedRecordDeleted(lastVisibleRec)) {
                        int n2 = nbDisplay;
                        nbDisplay = n2 + -1;
                    }
                    if (activeRecord == this.model.getDataPosition(lastVisibleRec)) {
                        inside = true;
                    }
                    ++lastVisibleRec;
                }
                this.setSortedToprec(recno);
                if (inside) {
                    if (this.model.getActiveField() != null) {
                        VField vField2 = this.model.getActiveField();
                        Intrinsics.checkNotNull((Object)vField2);
                        vField2.updateText();
                    }
                    this.blockChanged();
                } else {
                    int nextRec;
                    int n3 = nextRec = this.model.getSortedPosition(this.model.getActiveRecord()) < recno ? this.model.getDataPosition(recno) : this.model.getDataPosition(lastVisibleRec);
                    if (this.model.noMove() || !this.model.isRecordAccessible(nextRec)) {
                        throw new VExecFailedException();
                    }
                    this.model.changeActiveRecord(nextRec);
                }
            } else {
                if (this.model.noMove() || this.model.isRecordDeleted(this.model.getDataPosition(recno))) {
                    throw new VExecFailedException();
                }
                this.setSortedToprec(recno);
                this.blockChanged();
                if (this.model != this.model.getForm().getActiveBlock()) {
                    this.model.setActiveRecord(-1);
                }
            }
        }
    }

    @Override
    public void clear() {
        this.setSortedToprec(0);
        this.refresh(true);
    }

    public final void setBorder$galite_core(int style, @Nullable String title, @Nullable Page<?> page) {
        String string;
        if (style != 0 && (string = title) != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.setCaption(it, page);
        }
    }

    @Override
    @NotNull
    public UForm getFormView() {
        return this.formView;
    }

    @Override
    public int getDisplayLine(int recno) {
        if (recno < 0) {
            return -1;
        }
        int pos = this.model.getSortedPosition(recno);
        return pos < 0 ? -1 : this.getSortedRecToDisplay()[pos];
    }

    @Override
    public int getDisplayLine() {
        return this.getDisplayLine(this.model.getActiveRecord());
    }

    @Override
    public int getRecordFromDisplayLine(int line) {
        return this.model.getDataPosition(this.getDisplayToSortedRec()[line]);
    }

    @Override
    public void add(@Nullable UComponent comp, @NotNull Alignment constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        this.addComponent(comp instanceof Component ? (Component)comp : null, constraints.getX(), constraints.getY(), constraints.getWidth(), constraints.getHeight(), constraints.getAlignRight(), constraints.getUseAll());
    }

    @Override
    public int getColumnPos(int x) {
        return 0;
    }

    @Override
    public boolean inDetailMode() {
        return false;
    }

    @Override
    @NotNull
    public BlockLayout createLayout() {
        SimpleBlockLayout layout2 = new SimpleBlockLayout(2 * this.maxColumnPos, this.maxRowPos);
        if (this.model.getAlignment() != null) {
            BlockAlignment blockAlignment = this.model.getAlignment();
            Intrinsics.checkNotNull((Object)blockAlignment);
            UBlock uBlock = this.formView.getBlockView(blockAlignment.getBlock());
            if (uBlock == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.component.Component");
            }
            Component component = (Component)uBlock;
            BlockAlignment blockAlignment2 = this.model.getAlignment();
            Intrinsics.checkNotNull((Object)blockAlignment2);
            int[] nArray = blockAlignment2.getTargets();
            BlockAlignment blockAlignment3 = this.model.getAlignment();
            Intrinsics.checkNotNull((Object)blockAlignment3);
            layout2.setBlockAlignment(component, nArray, blockAlignment3.isChart());
        }
        return layout2;
    }

    @Override
    public void blockClosed() {
    }

    @Override
    public void blockChanged() {
        this.refresh(true);
    }

    @Override
    public void blockCleared() {
        this.clear();
    }

    @Override
    public void blockAccessChanged(@NotNull VBlock block, boolean newAccess) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
    }

    @Override
    public void blockViewModeLeaved(@NotNull VBlock block, @Nullable VField activeField) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
    }

    @Override
    public void blockViewModeEntered(@NotNull VBlock block, @Nullable VField activeField) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
    }

    @Override
    public void validRecordNumberChanged() {
    }

    @Override
    public void recordInfoChanged(int rec, int info) {
    }

    @Override
    public void orderChanged() {
        this.fireOrderChanged(this.model.getSortedRecords());
        this.refresh(true);
    }

    @Override
    public void filterHidden() {
    }

    @Override
    public void filterShown() {
    }

    @Override
    @Nullable
    public UBlock getCurrentDisplay() {
        return this;
    }

    public static final /* synthetic */ void access$fireActiveRecordChanged(DBlock $this, int record) {
        $this.fireActiveRecordChanged(record);
    }
}

