/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dnd.DragSource;
import com.vaadin.flow.server.StreamVariable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.activation.MimetypesFileTypeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VImageField;
import org.kopi.galite.visual.form.VStringField;
import org.kopi.galite.visual.visual.VException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J$\u0010\u0013\u001a\u00020\u000e2\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0012\u0010\u001a\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;", "Lcom/vaadin/flow/component/dnd/DragSource;", "Lcom/vaadin/flow/component/Component;", "block", "Lorg/kopi/galite/visual/form/VBlock;", "component", "(Lorg/kopi/galite/visual/form/VBlock;Lcom/vaadin/flow/component/Component;)V", "fileList", "Ljava/util/ArrayList;", "Ljava/io/File;", "Lkotlin/collections/ArrayList;", "filesCount", "", "isChartBlockContext", "", "()Z", "acceptDrop", "", "file", "handleDrop", "flavor", "", "files", "handleImage", "target", "Lorg/kopi/galite/visual/form/VImageField;", "isAccepted", "Companion", "StreamHandler", "galite-core"})
public final class DBlockDropHandler
implements DragSource<Component> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VBlock block;
    private final /* synthetic */ DragSource<Component> $$delegate_0;
    @Nullable
    private ArrayList<File> fileList;
    private int filesCount;
    @NotNull
    private static final MimetypesFileTypeMap MIMETYPES_FILE_TYPEMAP = new MimetypesFileTypeMap();
    private static final long serialVersionUID = 3924306391945432925L;

    public DBlockDropHandler(@NotNull VBlock block, @NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.block = block;
        this.$$delegate_0 = DragSource.configure((Component)component);
    }

    private final void acceptDrop(File file) {
        if (file != null) {
            try {
                if (this.isChartBlockContext()) {
                    ArrayList<File> arrayList = this.fileList;
                    Intrinsics.checkNotNull(arrayList);
                    arrayList.add(file);
                    ArrayList<File> arrayList2 = this.fileList;
                    Intrinsics.checkNotNull(arrayList2);
                    if (arrayList2.size() == this.filesCount) {
                        this.handleDrop(this.fileList);
                    }
                } else {
                    this.handleDrop(file, DBlockDropHandler.Companion.getExtension(file));
                }
            }
            catch (VException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAccepted(String flavor) {
        if (flavor == null) return false;
        CharSequence charSequence = flavor;
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (!this.block.isAccepted(flavor)) return false;
        return true;
    }

    private final boolean handleDrop(ArrayList<File> files) {
        int n = 0;
        ArrayList<File> arrayList = files;
        Intrinsics.checkNotNull(arrayList);
        int n2 = arrayList.size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                File file = files.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"files[i]");
                File file2 = file;
                if (this.handleDrop(file2, DBlockDropHandler.Companion.getExtension(file2))) continue;
                return false;
            } while (n <= n2);
        }
        return true;
    }

    private final boolean handleDrop(File file, String flavor) {
        boolean bl;
        String string = flavor;
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        VField vField2 = this.block.getDropTarget(string2);
        if (vField2 == null) {
            return false;
        }
        VField target = vField2;
        target.onBeforeDrop();
        if (target instanceof VStringField) {
            if (target.getWidth() < file.getAbsolutePath().length()) {
                bl = false;
            } else if (this.isChartBlockContext()) {
                int rec = DBlockDropHandler.Companion.getFirstUnfilledRecord(this.block, target);
                this.block.setActiveRecord(rec);
                this.block.setCurrentRecord(rec);
                target.setString(rec, file.getAbsolutePath());
                target.onAfterDrop();
                this.block.setActiveRecord(rec + 1);
                this.block.setCurrentRecord(rec + 1);
                this.block.gotoRecord(this.block.getActiveRecord());
                bl = true;
            } else {
                target.setString(file.getAbsolutePath());
                target.onAfterDrop();
                bl = true;
            }
        } else {
            bl = target instanceof VImageField ? (!target.isInternal() ? (DBlockDropHandler.Companion.isImage(file) ? this.handleImage((VImageField)target, file) : false) : this.handleImage((VImageField)target, file)) : false;
        }
        return bl;
    }

    private final boolean handleImage(VImageField target, File file) {
        boolean bl;
        if (this.isChartBlockContext()) {
            int rec = DBlockDropHandler.Companion.getFirstUnfilledRecord(this.block, target);
            this.block.setActiveRecord(rec);
            this.block.setCurrentRecord(rec);
            target.setImage(rec, DBlockDropHandler.Companion.toByteArray(file));
            target.onAfterDrop();
            this.block.setActiveRecord(rec + 1);
            this.block.setCurrentRecord(rec + 1);
            this.block.gotoRecord(this.block.getActiveRecord());
            bl = true;
        } else {
            target.setImage(DBlockDropHandler.Companion.toByteArray(file));
            target.onAfterDrop();
            bl = true;
        }
        return bl;
    }

    private final boolean isChartBlockContext() {
        return this.block.noDetail() || this.block.isMulti() && !this.block.isDetailMode();
    }

    static {
        MIMETYPES_FILE_TYPEMAP.addMimeTypes("image/png png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0004J\u0012\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0004J\u0012\u0010\n\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler$StreamHandler;", "Lcom/vaadin/flow/server/StreamVariable;", "(Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;)V", "bas", "Ljava/io/ByteArrayOutputStream;", "createTempFile", "Ljava/io/File;", "defaultName", "", "getBaseFileName", "getExtension", "getOutputStream", "Ljava/io/OutputStream;", "isInterrupted", "", "listenProgress", "onProgress", "", "event", "Lcom/vaadin/flow/server/StreamVariable$StreamingProgressEvent;", "streamingFailed", "Lcom/vaadin/flow/server/StreamVariable$StreamingErrorEvent;", "streamingFinished", "Lcom/vaadin/flow/server/StreamVariable$StreamingEndEvent;", "streamingStarted", "Lcom/vaadin/flow/server/StreamVariable$StreamingStartEvent;", "galite-core"})
    private final class StreamHandler
    implements StreamVariable {
        @NotNull
        private final ByteArrayOutputStream bas;

        public StreamHandler() {
            Intrinsics.checkNotNullParameter((Object)DBlockDropHandler.this, (String)"this$0");
            this.bas = new ByteArrayOutputStream();
        }

        @NotNull
        public OutputStream getOutputStream() {
            return this.bas;
        }

        public boolean listenProgress() {
            return true;
        }

        public void onProgress(@NotNull StreamVariable.StreamingProgressEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getContentLength() > 0x3200000L) {
                DBlockDropHandler.this.block.getForm().setCurrentJob((int)event.getBytesReceived());
            }
        }

        public void streamingStarted(@NotNull StreamVariable.StreamingStartEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getContentLength() > 0x3200000L) {
                DBlockDropHandler.this.block.getForm().setProgressDialog("", (int)event.getContentLength());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamingFinished(@NotNull StreamVariable.StreamingEndEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            try {
                FileOutputStream out = null;
                File temp = this.createTempFile(event.getFileName());
                out = new FileOutputStream(temp);
                this.bas.writeTo(out);
                DBlockDropHandler.this.acceptDrop(temp);
            }
            catch (IOException e) {
                DBlockDropHandler.this.acceptDrop(null);
            }
            finally {
                if (event.getContentLength() > 0x3200000L) {
                    DBlockDropHandler.this.block.getForm().unsetProgressDialog();
                }
            }
        }

        public void streamingFailed(@NotNull StreamVariable.StreamingErrorEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.getException().printStackTrace(System.err);
            new Thread(() -> StreamHandler.streamingFailed$lambda-0(DBlockDropHandler.this, event)).start();
        }

        public boolean isInterrupted() {
            return false;
        }

        @NotNull
        protected final File createTempFile(@Nullable String defaultName) {
            String basename = this.getBaseFileName(defaultName);
            String extension = this.getExtension(defaultName);
            File file = File.createTempFile(basename, Intrinsics.stringPlus((String)".", (Object)extension), null);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(basename, \".$extension\", null)");
            return file;
        }

        @NotNull
        protected final String getExtension(@Nullable String defaultName) {
            int index;
            if (defaultName != null && (index = StringsKt.lastIndexOf$default((CharSequence)defaultName, (char)'.', (int)0, (boolean)false, (int)6, null)) != -1) {
                String string = defaultName;
                int n = Math.min(defaultName.length(), index + 1);
                boolean bl = false;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                return string2;
            }
            return "";
        }

        @NotNull
        protected final String getBaseFileName(@Nullable String defaultName) {
            int index;
            if (defaultName != null && (index = StringsKt.lastIndexOf$default((CharSequence)defaultName, (char)'.', (int)0, (boolean)false, (int)6, null)) != -1) {
                String string = defaultName;
                int n = 0;
                int n2 = Math.min(defaultName.length(), index);
                boolean bl = false;
                String string2 = string.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string2;
            }
            return "";
        }

        private static final void streamingFailed$lambda-0(DBlockDropHandler this$0, StreamVariable.StreamingErrorEvent $event) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
            this$0.block.getForm().error($event.getException().getMessage());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler$Companion;", "", "()V", "MIMETYPES_FILE_TYPEMAP", "Ljavax/activation/MimetypesFileTypeMap;", "serialVersionUID", "", "copy", "", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "bufferSize", "", "getExtension", "", "file", "Ljava/io/File;", "getFirstUnfilledRecord", "block", "Lorg/kopi/galite/visual/form/VBlock;", "target", "Lorg/kopi/galite/visual/form/VField;", "isImage", "", "toByteArray", "", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getExtension(File file) {
            String extension = null;
            String name = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            int index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (index > 0 && index < name.length() - 1) {
                String string = name;
                int n = index + 1;
                boolean bl = false;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                string = string2;
                n = 0;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                extension = string4;
            }
            return extension;
        }

        private final boolean isImage(File file) {
            String mimeType = MIMETYPES_FILE_TYPEMAP.getContentType(file);
            Intrinsics.checkNotNullExpressionValue((Object)mimeType, (String)"mimeType");
            String[] stringArray = new String[]{"/"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)mimeType, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return Intrinsics.areEqual((Object)stringArray2[0], (Object)"image");
        }

        private final byte[] toByteArray(File file) {
            byte[] byArray;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.copy(new FileInputStream(file), baos, 1024);
                byArray = baos.toByteArray();
            }
            catch (IOException e) {
                byArray = null;
            }
            return byArray;
        }

        private final void copy(InputStream input, OutputStream output, int bufferSize) {
            byte[] buf = new byte[bufferSize];
            int bytesRead = input.read(buf);
            while (bytesRead != -1) {
                output.write(buf, 0, bytesRead);
                bytesRead = input.read(buf);
            }
            output.flush();
        }

        private final int getFirstUnfilledRecord(VBlock block, VField target) {
            int n = 0;
            int n2 = block.getBufferSize();
            if (n < n2) {
                do {
                    int i;
                    if (!target.isNull(i = n++)) continue;
                    return i;
                } while (n < n2);
            }
            return 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

